/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.module;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.descriptors.IdeaPluginXmlDetector;
import com.jetbrains.plugin.structure.intellij.plugin.descriptors.IdeaPluginXmlDetectorKt;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModule;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleScannerKt;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModules;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J2\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00120\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\nH\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\nH\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\nH\u0002J\f\u0010\u001c\u001a\u00020\u001a*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner;", "", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "ideaPluginXmlDetector", "Lcom/jetbrains/plugin/structure/intellij/plugin/descriptors/IdeaPluginXmlDetector;", "getContentModules", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModules;", "pluginArtifact", "Ljava/nio/file/Path;", "getJarContentModules", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModule;", "jarPath", "resolveContentModule", "descriptorPath", "withPluginJar", "T", "action", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/jar/PluginJar;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getModuleName", "", "isDescriptor", "", "isMetaInfPluginXml", "isPluginDescriptorInJarRoot", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nContentModuleScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentModuleScanner.kt\ncom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n58#1,3:98\n62#1,3:105\n1360#2:92\n1446#2,5:93\n1549#2:101\n1620#2,3:102\n1549#2:108\n1620#2,3:109\n*E\n*S KotlinDebug\n*F\n+ 1 ContentModuleScanner.kt\ncom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner\n*L\n43#1,3:98\n43#1,3:105\n36#1:92\n36#1,5:93\n45#1:101\n45#1,3:102\n81#1:108\n81#1,3:109\n*E\n"})
public final class ContentModuleScanner {
    private final IdeaPluginXmlDetector ideaPluginXmlDetector;
    private final JarFileSystemProvider fileSystemProvider;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContentModules getContentModules(@NotNull Path pluginArtifact) {
        void $this$flatMapTo$iv$iv;
        Path libDir;
        Intrinsics.checkNotNullParameter((Object)pluginArtifact, (String)"pluginArtifact");
        Path path = libDir = pluginArtifact.resolve("lib");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"libDir");
        if (!FileUtilKt.exists((Path)path)) {
            return new ContentModules(pluginArtifact, CollectionsKt.emptyList());
        }
        List jarPaths = FileUtilKt.listJars((Path)libDir);
        Path path2 = libDir.resolve("modules");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"libDir.resolve(MODULES_DIR)");
        List moduleJarPaths = FileUtilKt.listJars((Path)path2);
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)jarPaths, (Iterable)moduleJarPaths);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Path jarPath = (Path)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getJarContentModules(jarPath);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List contentModules = (List)destination$iv$iv;
        return new ContentModules(pluginArtifact, contentModules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<ContentModule> getJarContentModules(Path jarPath) {
        Object object;
        Object object2;
        ContentModuleScanner this_$iv = this;
        boolean $i$f$withPluginJar = false;
        try {
            List list;
            object2 = (AutoCloseable)new PluginJar(jarPath, this_$iv.fileSystemProvider);
            Throwable throwable = null;
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PluginJar jar$iv = (PluginJar)object2;
                boolean bl = false;
                PluginJar jar = jar$iv;
                boolean bl2 = false;
                Iterable iterable = jar.resolveDescriptors(new PluginJar.PluginDescriptorFilter(this, jarPath){
                    final /* synthetic */ ContentModuleScanner this$0;
                    final /* synthetic */ Path $jarPath$inlined;
                    {
                        this.this$0 = contentModuleScanner;
                        this.$jarPath$inlined = path;
                    }

                    public final boolean accept(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return ContentModuleScanner.access$isDescriptor(this.this$0, it);
                    }
                });
                boolean $i$f$map = false;
                void var12_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    ContentModule contentModule = this.resolveContentModule(jarPath, (Path)it);
                    collection.add(contentModule);
                }
                list = (List)destination$iv$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
            }
            object2 = list;
        }
        catch (JarArchiveCannotBeOpenException e$iv) {
            Throwable throwable = e$iv.getCause();
            ContentModuleScannerKt.access$getLOG$p().warn("Unable to open " + jarPath + ": " + (throwable != null ? throwable.getMessage() : null));
            object2 = null;
        }
        if ((object = object2) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final ContentModule resolveContentModule(Path jarPath, Path descriptorPath) {
        String moduleName = this.isMetaInfPluginXml(descriptorPath) ? "ROOT" : this.getModuleName(descriptorPath);
        return new ContentModule(moduleName, jarPath, descriptorPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withPluginJar(Path jarPath, Function1<? super PluginJar, ? extends T> action) {
        Object object;
        int $i$f$withPluginJar = 0;
        try {
            Object object2;
            object = (AutoCloseable)new PluginJar(jarPath, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginJar jar = (PluginJar)object;
                boolean bl = false;
                object2 = action.invoke((Object)jar);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (JarArchiveCannotBeOpenException e) {
            Throwable throwable = e.getCause();
            ContentModuleScannerKt.access$getLOG$p().warn("Unable to open " + jarPath + ": " + (throwable != null ? throwable.getMessage() : null));
            object = null;
        }
        return (T)object;
    }

    private final boolean isDescriptor(Path $this$isDescriptor) {
        boolean bl;
        switch ($this$isDescriptor.getNameCount()) {
            case 1: {
                Path path = $this$isDescriptor.getName(0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getName(0)");
                bl = this.isPluginDescriptorInJarRoot(path);
                break;
            }
            case 2: {
                bl = this.isMetaInfPluginXml($this$isDescriptor);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMetaInfPluginXml(Path $this$isMetaInfPluginXml) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$isMetaInfPluginXml;
        List list = ContentModuleScannerKt.access$getMETA_INF_PLUGIN_XML_PATH_COMPONENTS$p();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return Intrinsics.areEqual((Object)list, (Object)collection);
    }

    private final boolean isPluginDescriptorInJarRoot(Path $this$isPluginDescriptorInJarRoot) {
        boolean isXml = FileUtilKt.hasExtension((Path)$this$isPluginDescriptorInJarRoot, (String)"xml");
        return isXml && this.ideaPluginXmlDetector.isPluginDescriptor($this$isPluginDescriptorInJarRoot);
    }

    private final String getModuleName(Path $this$getModuleName) {
        return StringsKt.removeSuffix((String)((Object)$this$getModuleName.getFileName()).toString(), (CharSequence)".xml");
    }

    public ContentModuleScanner(@NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        this.fileSystemProvider = fileSystemProvider;
        this.ideaPluginXmlDetector = IdeaPluginXmlDetectorKt.createIdeaPluginXmlDetector();
    }

    public static final /* synthetic */ boolean access$isDescriptor(ContentModuleScanner $this, Path $this$access_u24isDescriptor) {
        return $this.isDescriptor($this$access_u24isDescriptor);
    }
}

