/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.platform;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.ModuleBean;
import com.jetbrains.plugin.structure.intellij.extractor.ModuleUnmarshaller;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesResolver;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesResolverKt;
import com.jetbrains.plugin.structure.intellij.platform.InvalidIdeException;
import com.jetbrains.plugin.structure.intellij.platform.ModulesResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/platform/BundledModulesResolver;", "Lcom/jetbrains/plugin/structure/intellij/platform/ModulesResolver;", "idePath", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "getIdePath", "()Ljava/nio/file/Path;", "moduleDescriptorsJarPath", "resolveModules", "", "Lcom/jetbrains/plugin/structure/intellij/beans/ModuleBean;", "unmarshallModule", "xmlPath", "structure-intellij"})
public final class BundledModulesResolver
implements ModulesResolver {
    @NotNull
    private final Path idePath;
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;
    @NotNull
    private final Path moduleDescriptorsJarPath;

    public BundledModulesResolver(@NotNull Path idePath, @NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        this.idePath = idePath;
        this.fileSystemProvider = fileSystemProvider;
        Path path = this.idePath.resolve("modules").resolve("module-descriptors.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"idePath.resolve(MODULES_\u2026e(MODULE_DESCRIPTORS_JAR)");
        this.moduleDescriptorsJarPath = path;
        if (!FileUtilKt.exists((Path)this.moduleDescriptorsJarPath)) {
            throw new InvalidIdeException("IDE path [" + this.idePath + "] does not contain 'modules/module-descriptors.jar' file");
        }
    }

    @NotNull
    public final Path getIdePath() {
        return this.idePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ModuleBean> resolveModules() {
        List list;
        Closeable closeable = this.fileSystemProvider.getFileSystem(this.moduleDescriptorsJarPath);
        Throwable throwable = null;
        try {
            List list2;
            FileSystem jarFs = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = jarFs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"jarFs.rootDirectories");
            Object object = CollectionsKt.first(iterable);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jarFs.rootDirectories.first()");
            Path root = (Path)object;
            AutoCloseable autoCloseable = Files.list(root);
            Throwable throwable2 = null;
            try {
                Stream files = (Stream)autoCloseable;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)files, (String)"files");
                list2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)files), (Function1)resolveModules.1.1.1.INSTANCE), (Function1)((Function1)new Function1<Path, ModuleBean>((Object)this){

                    @Nullable
                    public final ModuleBean invoke(@NotNull Path p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return BundledModulesResolver.access$unmarshallModule((BundledModulesResolver)this.receiver, p0);
                    }
                })));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            list = list2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    private final ModuleBean unmarshallModule(Path xmlPath) {
        try {
            return ModuleUnmarshaller.INSTANCE.unmarshall(xmlPath);
        }
        catch (JAXBException e) {
            Object[] objectArray = new Object[]{this.moduleDescriptorsJarPath, xmlPath, e.getMessage()};
            BundledModulesResolverKt.access$getLOG$p().debug("Cannot unmarshall [{}/{}]: {}", objectArray);
            return null;
        }
    }

    public static final /* synthetic */ ModuleBean access$unmarshallModule(BundledModulesResolver $this, Path xmlPath) {
        return $this.unmarshallModule(xmlPath);
    }
}

