/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.intellij.plugin.CompositePluginProviderKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProviderResult;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvision;
import com.jetbrains.plugin.structure.intellij.plugin.PluginQuery;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\bH\u0016J)\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0011H\u0082\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/CompositePluginProvider;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "pluginProviders", "", "(Ljava/util/Collection;)V", "findPluginById", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginId", "", "findPluginByIdOrModuleId", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProviderResult;", "pluginIdOrModuleId", "findPluginByModule", "moduleId", "firstNotNullOfOrNull", "id", "transform", "Lkotlin/Function1;", "query", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvision;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginQuery;", "Companion", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nCompositePluginProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositePluginProvider.kt\ncom/jetbrains/plugin/structure/intellij/plugin/CompositePluginProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n24#1,3:60\n27#1,4:64\n24#1,3:68\n27#1,4:72\n1#2:63\n1#2:71\n1#2:76\n*E\n*S KotlinDebug\n*F\n+ 1 CompositePluginProvider.kt\ncom/jetbrains/plugin/structure/intellij/plugin/CompositePluginProvider\n*L\n15#1,3:60\n15#1,4:64\n19#1,3:68\n19#1,4:72\n15#1:63\n19#1:71\n*E\n"})
public final class CompositePluginProvider
implements PluginProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<PluginProvider> pluginProviders;

    public CompositePluginProvider(@NotNull Collection<? extends PluginProvider> pluginProviders) {
        Intrinsics.checkNotNullParameter(pluginProviders, (String)"pluginProviders");
        this.pluginProviders = pluginProviders;
    }

    @Override
    @Nullable
    public IdePlugin findPluginById(@NotNull String pluginId) {
        IdePlugin idePlugin;
        block1: {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            CompositePluginProvider this_$iv = this;
            boolean $i$f$firstNotNullOfOrNull = false;
            for (PluginProvider provider$iv : this_$iv.pluginProviders) {
                IdePlugin idePlugin2;
                CompositePluginProviderKt.access$getLOG$p().debug("Searching for plugin or module '{}' in '{}'", (Object)pluginId, (Object)provider$iv.getPresentableName());
                PluginProvider it = provider$iv;
                boolean bl = false;
                IdePlugin idePlugin3 = it.findPluginById(pluginId);
                if (idePlugin3 == null) continue;
                IdePlugin it$iv = idePlugin3;
                boolean bl2 = false;
                IdePlugin it$iv2 = idePlugin2 = it$iv;
                boolean bl3 = false;
                CompositePluginProviderKt.access$getLOG$p().debug("Found plugin or module '{}' in '{}'", (Object)pluginId, (Object)provider$iv.getPresentableName());
                idePlugin = idePlugin2;
                break block1;
            }
            idePlugin = null;
        }
        return idePlugin;
    }

    @Override
    @Nullable
    public IdePlugin findPluginByModule(@NotNull String moduleId) {
        IdePlugin idePlugin;
        block1: {
            Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
            CompositePluginProvider this_$iv = this;
            boolean $i$f$firstNotNullOfOrNull = false;
            for (PluginProvider provider$iv : this_$iv.pluginProviders) {
                IdePlugin idePlugin2;
                CompositePluginProviderKt.access$getLOG$p().debug("Searching for plugin or module '{}' in '{}'", (Object)moduleId, (Object)provider$iv.getPresentableName());
                PluginProvider it = provider$iv;
                boolean bl = false;
                IdePlugin idePlugin3 = it.findPluginByModule(moduleId);
                if (idePlugin3 == null) continue;
                IdePlugin it$iv = idePlugin3;
                boolean bl2 = false;
                IdePlugin it$iv2 = idePlugin2 = it$iv;
                boolean bl3 = false;
                CompositePluginProviderKt.access$getLOG$p().debug("Found plugin or module '{}' in '{}'", (Object)moduleId, (Object)provider$iv.getPresentableName());
                idePlugin = idePlugin2;
                break block1;
            }
            idePlugin = null;
        }
        return idePlugin;
    }

    private final IdePlugin firstNotNullOfOrNull(String id, Function1<? super PluginProvider, ? extends IdePlugin> transform) {
        boolean $i$f$firstNotNullOfOrNull = false;
        for (PluginProvider provider : this.pluginProviders) {
            IdePlugin idePlugin;
            CompositePluginProviderKt.access$getLOG$p().debug("Searching for plugin or module '{}' in '{}'", (Object)id, (Object)provider.getPresentableName());
            IdePlugin idePlugin2 = (IdePlugin)transform.invoke((Object)provider);
            if (idePlugin2 == null) continue;
            IdePlugin it = idePlugin2;
            boolean bl = false;
            IdePlugin it2 = idePlugin = it;
            boolean bl2 = false;
            CompositePluginProviderKt.access$getLOG$p().debug("Found plugin or module '{}' in '{}'", (Object)id, (Object)provider.getPresentableName());
            return idePlugin;
        }
        return null;
    }

    @Override
    @Nullable
    public PluginProviderResult findPluginByIdOrModuleId(@NotNull String pluginIdOrModuleId) {
        Intrinsics.checkNotNullParameter((Object)pluginIdOrModuleId, (String)"pluginIdOrModuleId");
        for (PluginProvider provider : this.pluginProviders) {
            IdePlugin idePlugin = provider.findPluginById(pluginIdOrModuleId);
            if (idePlugin != null) {
                IdePlugin it = idePlugin;
                boolean bl = false;
                return new PluginProviderResult(PluginProviderResult.Type.PLUGIN, it);
            }
            idePlugin = provider.findPluginByModule(pluginIdOrModuleId);
            if (idePlugin == null) continue;
            IdePlugin it = idePlugin;
            boolean bl = false;
            return new PluginProviderResult(PluginProviderResult.Type.MODULE, it);
        }
        return null;
    }

    @Override
    @NotNull
    public PluginProvision query(@NotNull PluginQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        for (PluginProvider provider : this.pluginProviders) {
            PluginProvision provision;
            Intrinsics.checkNotNullExpressionValue((Object)provider.query(query), (String)"provider.query(query)");
            if (!(provision instanceof PluginProvision.Found)) continue;
            return provision;
        }
        return PluginProvision.NotFound.INSTANCE;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/CompositePluginProvider$Companion;", "", "()V", "of", "Lcom/jetbrains/plugin/structure/intellij/plugin/CompositePluginProvider;", "pluginProviders", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "([Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;)Lcom/jetbrains/plugin/structure/intellij/plugin/CompositePluginProvider;", "structure-intellij"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompositePluginProvider of(PluginProvider ... pluginProviders) {
            Intrinsics.checkNotNullParameter((Object)pluginProviders, (String)"pluginProviders");
            return new CompositePluginProvider(ArraysKt.toList((Object[])pluginProviders));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

