/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.jar;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.jar.PluginDescriptorProviderKt;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00060\n\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/jar/PluginDescriptorProvider;", "", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "resolveFromJar", "T", "jarFile", "Ljava/nio/file/Path;", "onSuccess", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/jar/PluginDescriptorResult$Found;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "structure-intellij"})
public final class PluginDescriptorProvider {
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;

    public PluginDescriptorProvider(@NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        this.fileSystemProvider = fileSystemProvider;
    }

    public /* synthetic */ PluginDescriptorProvider(JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jarFileSystemProvider = (JarFileSystemProvider)SingletonCachingJarFileSystemProvider.INSTANCE;
        }
        this(jarFileSystemProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T resolveFromJar(@NotNull Path jarFile, @NotNull Function1<? super PluginDescriptorResult.Found, ? extends T> onSuccess) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        try {
            Object object2;
            object = (AutoCloseable)new PluginJar(jarFile, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                Object object3;
                PluginJar jar = (PluginJar)object;
                boolean bl = false;
                PluginDescriptorResult descriptor = jar.getPluginDescriptor("META-INF/plugin.xml");
                if (descriptor instanceof PluginDescriptorResult.Found) {
                    object3 = onSuccess.invoke((Object)descriptor);
                } else {
                    Object var8_14;
                    Object it = var8_14 = null;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{"META-INF/plugin.xml", jarFile, descriptor};
                    PluginDescriptorProviderKt.access$getLOG$p().debug("Unable to resolve descriptor [{}] from [{}] ({})", objectArray);
                    object3 = var8_14;
                }
                object2 = object3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = object2;
        }
        catch (JarArchiveCannotBeOpenException e) {
            Object var5_9;
            Object it = var5_9 = null;
            boolean bl = false;
            Object[] objectArray = new Object[]{jarFile, "META-INF/plugin.xml", LanguageUtilsKt.getShortExceptionMessage((Throwable)e)};
            PluginDescriptorProviderKt.access$getLOG$p().warn("Unable to extract {} (searching for {}): {}", objectArray);
            object = var5_9;
        }
        return (T)object;
    }

    public PluginDescriptorProvider() {
        this(null, 1, null);
    }
}

