/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.verifiers;

import com.jetbrains.plugin.structure.base.problems.ContainsNewlines;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.TooLongPropertyValue;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a0\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"MAX_PROPERTY_LENGTH", "", "verifyNewlines", "", "propertyName", "", "propertyValue", "descriptorPath", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "verifyPropertyLength", "maxLength", "structure-intellij"})
public final class SimpleVerifiersKt {
    public static final int MAX_PROPERTY_LENGTH = 255;

    public static final void verifyNewlines(@NotNull String propertyName, @NotNull String propertyValue, @NotNull String descriptorPath, @NotNull ProblemRegistrar problemRegistrar) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemRegistrar, (String)"problemRegistrar");
        if (StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)propertyValue)).toString(), (CharSequence)"\n", (boolean)false, (int)2, null)) {
            problemRegistrar.registerProblem((PluginProblem)new ContainsNewlines(propertyName, descriptorPath));
        }
    }

    public static /* synthetic */ void verifyNewlines$default(String string, String string2, String string3, ProblemRegistrar problemRegistrar, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "plugin.xml";
        }
        SimpleVerifiersKt.verifyNewlines(string, string2, string3, problemRegistrar);
    }

    public static final void verifyPropertyLength(@NotNull String propertyName, @NotNull String propertyValue, int maxLength, @NotNull String descriptorPath, @NotNull ProblemRegistrar problemRegistrar) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemRegistrar, (String)"problemRegistrar");
        if (propertyValue.length() > maxLength) {
            problemRegistrar.registerProblem((PluginProblem)new TooLongPropertyValue(descriptorPath, propertyName, propertyValue.length(), maxLength));
        }
    }

    public static /* synthetic */ void verifyPropertyLength$default(String string, String string2, int n, String string3, ProblemRegistrar problemRegistrar, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string3 = "plugin.xml";
        }
        SimpleVerifiersKt.verifyPropertyLength(string, string2, n, string3, problemRegistrar);
    }
}

