/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.verifiers;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.problems.StatusBarWidgetFactoryExtensionPointIdMissing;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/StatusBarWidgetFactoryExtensionPointVerifier;", "", "()V", "extensionPointName", "", "verify", "", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nExtensionPointVerifiers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionPointVerifiers.kt\ncom/jetbrains/plugin/structure/intellij/verifiers/StatusBarWidgetFactoryExtensionPointVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1855#2,2:76\n*E\n*S KotlinDebug\n*F\n+ 1 ExtensionPointVerifiers.kt\ncom/jetbrains/plugin/structure/intellij/verifiers/StatusBarWidgetFactoryExtensionPointVerifier\n*L\n47#1,2:76\n*E\n"})
public final class StatusBarWidgetFactoryExtensionPointVerifier {
    @NotNull
    private final String extensionPointName;

    public StatusBarWidgetFactoryExtensionPointVerifier() {
        this.extensionPointName = "com.intellij.statusBarWidgetFactory";
    }

    public final void verify(@NotNull IdePlugin plugin, @NotNull ProblemRegistrar problemRegistrar) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)problemRegistrar, (String)"problemRegistrar");
        List list = plugin.getExtensions().get(this.extensionPointName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List statusBarWidgetFactories = list;
        Iterable $this$forEach$iv = statusBarWidgetFactories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Attribute extensionId;
            String implementation;
            String string;
            String string2;
            Element it = (Element)element$iv;
            boolean bl = false;
            Attribute attribute = it.getAttribute("implementation");
            String string3 = string2 = attribute != null ? attribute.getValue() : null;
            if (string3 == null) {
                string = "N/A";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.getAttribute(\"implementation\")?.value ?: \"N/A\"");
                string = implementation = string2;
            }
            if ((extensionId = it.getAttribute("id")) != null) continue;
            problemRegistrar.registerProblem(new StatusBarWidgetFactoryExtensionPointIdMissing(implementation));
        }
    }
}

