/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.Classpath;
import com.jetbrains.plugin.structure.intellij.plugin.ClasspathOrigin;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/LibDirJarsClasspathProvider;", "", "()V", "getClasspath", "Lcom/jetbrains/plugin/structure/intellij/plugin/Classpath;", "path", "Ljava/nio/file/Path;", "structure-intellij"})
public final class LibDirJarsClasspathProvider {
    @NotNull
    public final Classpath getClasspath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path libDir = path.resolve("lib");
        Intrinsics.checkNotNullExpressionValue((Object)libDir, (String)"libDir");
        if (!FileUtilKt.exists((Path)libDir)) {
            return Classpath.EMPTY;
        }
        List jarPaths = FileUtilKt.listJars((Path)libDir);
        return Classpath.Companion.of(jarPaths, ClasspathOrigin.PLUGIN_ARTIFACT);
    }
}

