/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.problems.NotBoolean;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.TooLongPropertyValue;
import com.jetbrains.plugin.structure.base.problems.ValidatorKt;
import com.jetbrains.plugin.structure.base.problems.VendorCannotBeEmpty;
import com.jetbrains.plugin.structure.intellij.beans.IdeaVersionBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependencyBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginVendorBean;
import com.jetbrains.plugin.structure.intellij.beans.ProductDescriptorBean;
import com.jetbrains.plugin.structure.intellij.plugin.PluginBeanValidatorKt;
import com.jetbrains.plugin.structure.intellij.plugin.ValidationContext;
import com.jetbrains.plugin.structure.intellij.problems.DefaultChangeNotes;
import com.jetbrains.plugin.structure.intellij.problems.DescriptionNotStartingWithLatinCharacters;
import com.jetbrains.plugin.structure.intellij.problems.ErroneousSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.HttpLinkInDescription;
import com.jetbrains.plugin.structure.intellij.problems.InvalidDependencyId;
import com.jetbrains.plugin.structure.intellij.problems.InvalidModuleBean;
import com.jetbrains.plugin.structure.intellij.problems.InvalidSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyConfigFileIsEmpty;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyConfigFileNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.ProductCodePrefixInBuild;
import com.jetbrains.plugin.structure.intellij.problems.PropertyWithDefaultValue;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseDateInFuture;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseDateWrongFormat;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildCannotContainWildcard;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.SuperfluousNonOptionalDependencyDeclaration;
import com.jetbrains.plugin.structure.intellij.problems.TemplateWordInPluginName;
import com.jetbrains.plugin.structure.intellij.verifiers.PluginIdVerifier;
import com.jetbrains.plugin.structure.intellij.verifiers.PluginUntilBuildVerifier;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import com.jetbrains.plugin.structure.intellij.verifiers.ProductReleaseVersionVerifier;
import com.jetbrains.plugin.structure.intellij.verifiers.ReusedDescriptorVerifier;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\t\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0012\u001a\u00020\n*\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0016\u0010\u0018\u001a\u00020\n*\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010\u001a\u001a\u00020\n*\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0016\u0010\u001e\u001a\u00020\n*\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010 \u001a\u00020\n*\u00020\u000e2\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0014\u0010\"\u001a\u00020\n*\u00020\u000e2\u0006\u0010#\u001a\u00020\fH\u0002J\u0016\u0010$\u001a\u00020\n*\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0014\u0010'\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010(\u001a\u00020\n*\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010)\u001a\u00020\n*\u00020\u000e2\u0006\u0010*\u001a\u00020\u0014H\u0002J\u0016\u0010+\u001a\u00020\n*\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0002J\u001e\u0010-\u001a\u00020\n*\u00020\u000e2\u0006\u0010#\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J$\u00100\u001a\u00020\n*\u00020\u000e2\u0006\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u000204H\u0002J\u0016\u00105\u001a\u00020\n*\u00020\u000e2\b\u00106\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u00107\u001a\u00020\n*\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u0014H\u0002J\u0016\u00109\u001a\u00020\n*\u00020\u000e2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u0016\u0010<\u001a\u00020\n*\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginBeanValidator;", "", "()V", "pluginIdVerifier", "Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginIdVerifier;", "pluginProductReleaseVersionVerifier", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProductReleaseVersionVerifier;", "pluginUntilBuildVerifier", "Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginUntilBuildVerifier;", "validate", "", "pluginBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "validationContext", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext;", "validateDescriptor", "", "bean", "validateBeanUrl", "beanUrl", "", "validateBooleanFlag", "flag", "name", "validateChangeNotes", "changeNotes", "validateDependencies", "dependencies", "", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginDependencyBean;", "validateDescription", "htmlDescription", "validateEapFlag", "eapFlag", "validateId", "plugin", "validateIdeaVersion", "versionBean", "Lcom/jetbrains/plugin/structure/intellij/beans/IdeaVersionBean;", "validateModules", "validateName", "validateOptionalFlag", "optionalFlag", "validateProductCode", "productCode", "validateProductDescriptor", "productDescriptor", "Lcom/jetbrains/plugin/structure/intellij/beans/ProductDescriptorBean;", "validatePropertyLength", "propertyName", "propertyValue", "maxLength", "", "validateReleaseDate", "releaseDate", "validateSinceBuild", "sinceBuild", "validateVendor", "vendorBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginVendorBean;", "validateVersion", "pluginVersion", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginBeanValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginBeanValidator.kt\ncom/jetbrains/plugin/structure/intellij/plugin/PluginBeanValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1747#2,3:290\n1747#2,3:294\n1855#2,2:297\n1747#2,3:299\n1#3:293\n*E\n*S KotlinDebug\n*F\n+ 1 PluginBeanValidator.kt\ncom/jetbrains/plugin/structure/intellij/plugin/PluginBeanValidator\n*L\n88#1,3:290\n128#1,3:294\n138#1,2:297\n285#1,3:299\n*E\n"})
public final class PluginBeanValidator {
    @NotNull
    private final PluginIdVerifier pluginIdVerifier = new PluginIdVerifier();
    @NotNull
    private final PluginUntilBuildVerifier pluginUntilBuildVerifier = new PluginUntilBuildVerifier();
    @NotNull
    private final ProductReleaseVersionVerifier pluginProductReleaseVersionVerifier = new ProductReleaseVersionVerifier();

    public final void validate(@NotNull PluginBean pluginBean, @NotNull ValidationContext validationContext, boolean validateDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginBean, (String)"pluginBean");
        Intrinsics.checkNotNullParameter((Object)validationContext, (String)"validationContext");
        this.validate(validationContext, pluginBean, validateDescriptor);
    }

    private final void validate(ValidationContext $this$validate, PluginBean bean, boolean validateDescriptor) {
        if (validateDescriptor) {
            this.validateBeanUrl($this$validate, bean.url);
            this.validateId($this$validate, bean);
            this.validateName($this$validate, bean.name);
            this.validateVersion($this$validate, bean.pluginVersion);
            this.validateDescription($this$validate, bean.description);
            this.validateChangeNotes($this$validate, bean.changeNotes);
            this.validateVendor($this$validate, bean.vendor);
            this.validateIdeaVersion($this$validate, bean.ideaVersion);
            this.pluginUntilBuildVerifier.verify(bean, $this$validate.getDescriptorPath(), new ProblemRegistrar($this$validate){
                final /* synthetic */ ValidationContext $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void registerProblem(@NotNull PluginProblem p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$tmp0.registerProblem(p0);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, ValidationContext.class, "registerProblem", "registerProblem(Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;)V", 0);
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof ProblemRegistrar ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            this.validateProductDescriptor($this$validate, bean, bean.productDescriptor);
        }
        List<PluginDependencyBean> list = bean.dependencies;
        Intrinsics.checkNotNullExpressionValue(list, (String)"bean.dependencies");
        this.validateDependencies($this$validate, list);
        this.validateModules($this$validate, bean);
    }

    private final void validatePropertyLength(ValidationContext $this$validatePropertyLength, String propertyName, String propertyValue, int maxLength) {
        if (propertyValue.length() > maxLength) {
            $this$validatePropertyLength.registerProblem((PluginProblem)new TooLongPropertyValue($this$validatePropertyLength.getDescriptorPath(), propertyName, propertyValue.length(), maxLength));
        }
    }

    private final void validateId(ValidationContext $this$validateId, PluginBean plugin) {
        this.pluginIdVerifier.verify(plugin, $this$validateId.getDescriptorPath(), new ProblemRegistrar($this$validateId){
            final /* synthetic */ ValidationContext $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void registerProblem(@NotNull PluginProblem p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.$tmp0.registerProblem(p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, ValidationContext.class, "registerProblem", "registerProblem(Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;)V", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ProblemRegistrar ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final void validateName(ValidationContext $this$validateName, String name) {
        block8: {
            String string;
            block6: {
                String it;
                Object element$iv2;
                block9: {
                    boolean bl;
                    block5: {
                        block7: {
                            CharSequence charSequence = name;
                            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block7;
                            $this$validateName.registerProblem((PluginProblem)new PropertyNotSpecified("name", $this$validateName.getDescriptorPath()));
                            break block8;
                        }
                        Iterable $this$any$iv = PluginBeanValidatorKt.access$getDEFAULT_TEMPLATE_NAMES$p();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (String)element$iv2;
                                boolean bl2 = false;
                                if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block9;
                    $this$validateName.registerProblem((PluginProblem)new PropertyWithDefaultValue($this$validateName.getDescriptorPath(), PropertyWithDefaultValue.DefaultProperty.NAME, name));
                    break block8;
                }
                Iterable iterable = PluginBeanValidatorKt.access$getPLUGIN_NAME_RESTRICTED_WORDS$p();
                element$iv2 = iterable.iterator();
                while (element$iv2.hasNext()) {
                    String it2 = it = element$iv2.next();
                    boolean bl = false;
                    if (!StringsKt.contains((CharSequence)name, (CharSequence)it2, (boolean)true)) continue;
                    string = it;
                    break block6;
                }
                string = null;
            }
            String templateWord = string;
            if (templateWord != null) {
                $this$validateName.registerProblem((PluginProblem)new TemplateWordInPluginName($this$validateName.getDescriptorPath(), name, templateWord));
            }
            this.validatePropertyLength($this$validateName, "name", name, 64);
            PluginProblem pluginProblem = ValidatorKt.validatePluginNameIsCorrect((String)$this$validateName.getDescriptorPath(), (String)((Object)StringsKt.trim((CharSequence)name)).toString());
            if (pluginProblem == null) break block8;
            PluginProblem it = pluginProblem;
            boolean bl = false;
            $this$validateName.registerProblem(it);
        }
    }

    private final void validateBeanUrl(ValidationContext $this$validateBeanUrl, String beanUrl) {
        if (beanUrl != null) {
            this.validatePropertyLength($this$validateBeanUrl, "plugin url", beanUrl, 255);
        }
    }

    private final void validateVersion(ValidationContext $this$validateVersion, String pluginVersion) {
        CharSequence charSequence = pluginVersion;
        if (charSequence == null || charSequence.length() == 0) {
            $this$validateVersion.registerProblem((PluginProblem)new PropertyNotSpecified("version", $this$validateVersion.getDescriptorPath()));
        } else {
            this.validatePropertyLength($this$validateVersion, "version", pluginVersion, 64);
        }
    }

    private final void validateDescription(ValidationContext $this$validateDescription, String htmlDescription) {
        String latinDescriptionPart;
        boolean bl;
        String textDescription;
        Document html;
        block8: {
            CharSequence charSequence = htmlDescription;
            if (charSequence == null || charSequence.length() == 0) {
                $this$validateDescription.registerProblem((PluginProblem)new PropertyNotSpecified("description", $this$validateDescription.getDescriptorPath()));
                return;
            }
            this.validatePropertyLength($this$validateDescription, "description", htmlDescription, 65535);
            html = Jsoup.parseBodyFragment((String)htmlDescription);
            textDescription = html.text();
            Iterable $this$any$iv = PluginBeanValidatorKt.access$getDEFAULT_TEMPLATE_DESCRIPTIONS$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)textDescription, (String)"textDescription");
                    if (!StringsKt.contains$default((CharSequence)textDescription, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            String string = $this$validateDescription.getDescriptorPath();
            Intrinsics.checkNotNullExpressionValue((Object)textDescription, (String)"textDescription");
            $this$validateDescription.registerProblem((PluginProblem)new PropertyWithDefaultValue(string, PropertyWithDefaultValue.DefaultProperty.DESCRIPTION, textDescription));
            return;
        }
        Regex regex = PluginBeanValidatorKt.access$getSTARTS_WITH_LATIN_SYMBOLS_REGEX$p();
        Intrinsics.checkNotNullExpressionValue((Object)textDescription, (String)"textDescription");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)textDescription, (int)0, (int)2, null);
        String string = latinDescriptionPart = matchResult != null ? matchResult.getValue() : null;
        if (latinDescriptionPart == null) {
            $this$validateDescription.registerProblem((PluginProblem)new DescriptionNotStartingWithLatinCharacters());
        }
        Elements links = html.select("[href],img[src]");
        Intrinsics.checkNotNullExpressionValue((Object)links, (String)"links");
        Iterable $this$forEach$iv = (Iterable)links;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element link = (Element)element$iv;
            boolean bl3 = false;
            String href = link.attr("abs:href");
            String src = link.attr("abs:src");
            Intrinsics.checkNotNullExpressionValue((Object)href, (String)"href");
            if (StringsKt.startsWith$default((String)href, (String)"http://", (boolean)false, (int)2, null)) {
                $this$validateDescription.registerProblem((PluginProblem)new HttpLinkInDescription(href));
            }
            Intrinsics.checkNotNullExpressionValue((Object)src, (String)"src");
            if (!StringsKt.startsWith$default((String)src, (String)"http://", (boolean)false, (int)2, null)) continue;
            $this$validateDescription.registerProblem((PluginProblem)new HttpLinkInDescription(src));
        }
    }

    private final void validateChangeNotes(ValidationContext $this$validateChangeNotes, String changeNotes) {
        CharSequence charSequence = changeNotes;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)changeNotes, (CharSequence)"Add change notes here", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)changeNotes, (CharSequence)"most HTML tags may be used", (boolean)false, (int)2, null)) {
            $this$validateChangeNotes.registerProblem((PluginProblem)new DefaultChangeNotes($this$validateChangeNotes.getDescriptorPath()));
        }
        this.validatePropertyLength($this$validateChangeNotes, "<change-notes>", changeNotes, 65535);
    }

    private final void validateVendor(ValidationContext $this$validateVendor, PluginVendorBean vendorBean) {
        if (vendorBean == null) {
            $this$validateVendor.registerProblem((PluginProblem)new PropertyNotSpecified("vendor", $this$validateVendor.getDescriptorPath()));
            return;
        }
        CharSequence charSequence = vendorBean.name;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            $this$validateVendor.registerProblem((PluginProblem)new VendorCannotBeEmpty($this$validateVendor.getDescriptorPath()));
            return;
        }
        if (Intrinsics.areEqual((Object)"YourCompany", (Object)vendorBean.name)) {
            String string = $this$validateVendor.getDescriptorPath();
            String string2 = vendorBean.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"vendorBean.name");
            $this$validateVendor.registerProblem((PluginProblem)new PropertyWithDefaultValue(string, PropertyWithDefaultValue.DefaultProperty.VENDOR, string2));
        }
        String string = vendorBean.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vendorBean.name");
        this.validatePropertyLength($this$validateVendor, "vendor", string, 255);
        if (Intrinsics.areEqual((Object)"https://www.yourcompany.com", (Object)vendorBean.url)) {
            String string3 = $this$validateVendor.getDescriptorPath();
            String string4 = vendorBean.url;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"vendorBean.url");
            $this$validateVendor.registerProblem((PluginProblem)new PropertyWithDefaultValue(string3, PropertyWithDefaultValue.DefaultProperty.VENDOR_URL, string4));
        }
        String string5 = vendorBean.url;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"vendorBean.url");
        this.validatePropertyLength($this$validateVendor, "vendor url", string5, 255);
        if (Intrinsics.areEqual((Object)"support@yourcompany.com", (Object)vendorBean.email)) {
            String string6 = $this$validateVendor.getDescriptorPath();
            String string7 = vendorBean.email;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"vendorBean.email");
            $this$validateVendor.registerProblem((PluginProblem)new PropertyWithDefaultValue(string6, PropertyWithDefaultValue.DefaultProperty.VENDOR_EMAIL, string7));
        }
        String string8 = vendorBean.email;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"vendorBean.email");
        this.validatePropertyLength($this$validateVendor, "vendor email", string8, 255);
    }

    private final void validateIdeaVersion(ValidationContext $this$validateIdeaVersion, IdeaVersionBean versionBean) {
        if (versionBean == null) {
            $this$validateIdeaVersion.registerProblem((PluginProblem)new PropertyNotSpecified("idea-version", $this$validateIdeaVersion.getDescriptorPath()));
            return;
        }
        String sinceBuild = versionBean.sinceBuild;
        this.validateSinceBuild($this$validateIdeaVersion, sinceBuild);
    }

    private final void validateSinceBuild(ValidationContext $this$validateSinceBuild, String sinceBuild) {
        if (sinceBuild == null) {
            $this$validateSinceBuild.registerProblem((PluginProblem)new SinceBuildNotSpecified($this$validateSinceBuild.getDescriptorPath()));
        } else {
            IdeVersion sinceBuildParsed = IdeVersion.createIdeVersionIfValid(sinceBuild);
            if (sinceBuildParsed == null) {
                $this$validateSinceBuild.registerProblem((PluginProblem)new InvalidSinceBuild($this$validateSinceBuild.getDescriptorPath(), sinceBuild));
            } else {
                if (StringsKt.endsWith$default((String)sinceBuild, (String)".*", (boolean)false, (int)2, null)) {
                    $this$validateSinceBuild.registerProblem((PluginProblem)new SinceBuildCannotContainWildcard($this$validateSinceBuild.getDescriptorPath(), sinceBuildParsed));
                }
                if (sinceBuildParsed.getBaselineVersion() < 130) {
                    $this$validateSinceBuild.registerProblem((PluginProblem)new InvalidSinceBuild($this$validateSinceBuild.getDescriptorPath(), sinceBuild));
                }
                if (sinceBuildParsed.getBaselineVersion() > 999) {
                    $this$validateSinceBuild.registerProblem((PluginProblem)new ErroneousSinceBuild($this$validateSinceBuild.getDescriptorPath(), sinceBuildParsed));
                }
                if (((CharSequence)sinceBuildParsed.getProductCode()).length() > 0) {
                    $this$validateSinceBuild.registerProblem((PluginProblem)new ProductCodePrefixInBuild($this$validateSinceBuild.getDescriptorPath()));
                }
            }
        }
    }

    private final void validateProductDescriptor(ValidationContext $this$validateProductDescriptor, PluginBean plugin, ProductDescriptorBean productDescriptor) {
        block2: {
            String it;
            if (productDescriptor == null) break block2;
            this.validateProductCode($this$validateProductDescriptor, productDescriptor.code);
            this.validateReleaseDate($this$validateProductDescriptor, productDescriptor.releaseDate);
            this.pluginProductReleaseVersionVerifier.verify(plugin, $this$validateProductDescriptor.getDescriptorPath(), new ProblemRegistrar($this$validateProductDescriptor){
                final /* synthetic */ ValidationContext $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void registerProblem(@NotNull PluginProblem p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    this.$tmp0.registerProblem(p0);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, ValidationContext.class, "registerProblem", "registerProblem(Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;)V", 0);
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof ProblemRegistrar ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            String string = productDescriptor.eap;
            if (string != null) {
                it = string;
                boolean bl = false;
                this.validateEapFlag($this$validateProductDescriptor, it);
            }
            String string2 = productDescriptor.optional;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                this.validateOptionalFlag($this$validateProductDescriptor, it);
            }
        }
    }

    private final void validateProductCode(ValidationContext $this$validateProductCode, String productCode) {
        CharSequence charSequence = productCode;
        if (charSequence == null || charSequence.length() == 0) {
            $this$validateProductCode.registerProblem((PluginProblem)new PropertyNotSpecified("code", $this$validateProductCode.getDescriptorPath()));
        } else {
            this.validatePropertyLength($this$validateProductCode, "Product code", productCode, 15);
        }
    }

    private final void validateReleaseDate(ValidationContext $this$validateReleaseDate, String releaseDate) {
        CharSequence charSequence = releaseDate;
        if (charSequence == null || charSequence.length() == 0) {
            $this$validateReleaseDate.registerProblem((PluginProblem)new PropertyNotSpecified("release-date", $this$validateReleaseDate.getDescriptorPath()));
        } else {
            try {
                LocalDate date = LocalDate.parse(releaseDate, PluginBeanValidatorKt.access$getRELEASE_DATE_FORMATTER$p());
                if (date.compareTo(LocalDate.now().plusDays(5L)) > 0) {
                    $this$validateReleaseDate.registerProblem((PluginProblem)new ReleaseDateInFuture($this$validateReleaseDate.getDescriptorPath()));
                }
            }
            catch (DateTimeParseException e) {
                $this$validateReleaseDate.registerProblem((PluginProblem)new ReleaseDateWrongFormat($this$validateReleaseDate.getDescriptorPath()));
            }
        }
    }

    private final void validateEapFlag(ValidationContext $this$validateEapFlag, String eapFlag) {
        this.validateBooleanFlag($this$validateEapFlag, eapFlag, "eap");
    }

    private final void validateOptionalFlag(ValidationContext $this$validateOptionalFlag, String optionalFlag) {
        this.validateBooleanFlag($this$validateOptionalFlag, optionalFlag, "optional");
    }

    private final void validateBooleanFlag(ValidationContext $this$validateBooleanFlag, String flag, String name) {
        if (!Intrinsics.areEqual((Object)flag, (Object)"true") && !Intrinsics.areEqual((Object)flag, (Object)"false")) {
            $this$validateBooleanFlag.registerProblem((PluginProblem)new NotBoolean(name, $this$validateBooleanFlag.getDescriptorPath()));
        }
    }

    private final void validateDependencies(ValidationContext $this$validateDependencies, List<? extends PluginDependencyBean> dependencies) {
        for (PluginDependencyBean pluginDependencyBean : dependencies) {
            block7: {
                block6: {
                    CharSequence charSequence = pluginDependencyBean.dependencyId;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block6;
                    String string = pluginDependencyBean.dependencyId;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) break block7;
                }
                String string = $this$validateDependencies.getDescriptorPath();
                String string2 = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dependencyBean.dependencyId");
                $this$validateDependencies.registerProblem((PluginProblem)new InvalidDependencyId(string, string2));
                continue;
            }
            if (Intrinsics.areEqual((Object)pluginDependencyBean.optional, (Object)true)) {
                if (pluginDependencyBean.configFile == null) {
                    String string = pluginDependencyBean.dependencyId;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                    $this$validateDependencies.registerProblem(new OptionalDependencyConfigFileNotSpecified(string));
                    continue;
                }
                String string = pluginDependencyBean.configFile;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.configFile");
                if (!StringsKt.isBlank((CharSequence)string)) continue;
                String string3 = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dependencyBean.dependencyId");
                $this$validateDependencies.registerProblem((PluginProblem)new OptionalDependencyConfigFileIsEmpty(string3, $this$validateDependencies.getDescriptorPath()));
                continue;
            }
            if (!Intrinsics.areEqual((Object)pluginDependencyBean.optional, (Object)false)) continue;
            String string = pluginDependencyBean.dependencyId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
            $this$validateDependencies.registerProblem(new SuperfluousNonOptionalDependencyDeclaration(string));
        }
        new ReusedDescriptorVerifier($this$validateDependencies.getDescriptorPath()).verify((Collection<? extends PluginDependencyBean>)dependencies, (Function1<? super PluginProblem, Unit>)((Function1)new Function1<PluginProblem, Unit>((Object)$this$validateDependencies){

            public final void invoke(@NotNull PluginProblem p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ValidationContext)this.receiver).registerProblem(p0);
            }
        }));
    }

    private final void validateModules(ValidationContext $this$validateModules, PluginBean bean) {
        boolean bl;
        List<String> list = bean.pluginAliases;
        if (list != null) {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        boolean bl4 = ((CharSequence)it).length() == 0;
                        if (!bl4) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            $this$validateModules.registerProblem((PluginProblem)new InvalidModuleBean($this$validateModules.getDescriptorPath()));
        }
    }
}

