/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.extractor.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDescriptorParserKt;
import com.jetbrains.plugin.structure.intellij.plugin.ValidationContext;
import com.jetbrains.plugin.structure.intellij.problems.XIncludeResolutionErrors;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluder;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluderException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JB\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser;", "", "()V", "parse", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "descriptorPath", "", "pluginFileName", "originalDocument", "Lorg/jdom2/Document;", "documentPath", "Ljava/nio/file/Path;", "documentName", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "validationContext", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext;", "readDocumentIntoXmlBean", "document", "resolveXIncludesOfDocument", "presentablePath", "ParseResult", "structure-intellij"})
public final class PluginDescriptorParser {
    @NotNull
    public final ParseResult parse(@NotNull String descriptorPath, @NotNull String pluginFileName, @NotNull Document originalDocument, @NotNull Path documentPath, @NotNull String documentName, @NotNull ResourceResolver pathResolver, @NotNull ValidationContext validationContext) {
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)pluginFileName, (String)"pluginFileName");
        Intrinsics.checkNotNullParameter((Object)originalDocument, (String)"originalDocument");
        Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
        Intrinsics.checkNotNullParameter((Object)documentName, (String)"documentName");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        Intrinsics.checkNotNullParameter((Object)validationContext, (String)"validationContext");
        Document document2 = this.resolveXIncludesOfDocument(descriptorPath, pluginFileName, originalDocument, documentName, pathResolver, documentPath, validationContext);
        if (document2 == null) {
            return ParseResult.InvalidXml.INSTANCE;
        }
        Document document3 = document2;
        return this.readDocumentIntoXmlBean(descriptorPath, pluginFileName, document3, validationContext);
    }

    private final ParseResult readDocumentIntoXmlBean(String descriptorPath, String pluginFileName, Document document2, ValidationContext validationContext) {
        ParseResult parseResult;
        try {
            PluginBean bean = PluginBeanExtractor.INSTANCE.extractPluginBean(document2);
            parseResult = new ParseResult.Parsed(document2, bean);
        }
        catch (Exception e) {
            validationContext.plusAssign((PluginProblem)new UnableToReadDescriptor(descriptorPath, e.getLocalizedMessage()));
            PluginDescriptorParserKt.access$getLOG$p().info("Unable to read plugin descriptor " + descriptorPath + " of " + pluginFileName, (Throwable)e);
            parseResult = new ParseResult.InvalidBean(document2);
        }
        return parseResult;
    }

    private final Document resolveXIncludesOfDocument(String descriptorPath, String pluginFileName, Document document2, String presentablePath, ResourceResolver pathResolver, Path documentPath, ValidationContext validationContext) {
        Document document3;
        try {
            document3 = XIncluder.Companion.resolveXIncludes(document2, presentablePath, pathResolver, documentPath);
        }
        catch (XIncluderException e) {
            PluginDescriptorParserKt.access$getLOG$p().info("Unable to resolve <xi:include> elements of descriptor '" + descriptorPath + "' from '" + pluginFileName + "'", (Throwable)e);
            validationContext.plusAssign((PluginProblem)new XIncludeResolutionErrors(descriptorPath, e.getMessage()));
            document3 = null;
        }
        return document3;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "", "()V", "InvalidBean", "InvalidXml", "Parsed", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidBean;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidXml;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$Parsed;", "structure-intellij"})
    public static abstract class ParseResult {
        private ParseResult() {
        }

        public /* synthetic */ ParseResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidBean;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "document", "Lorg/jdom2/Document;", "(Lorg/jdom2/Document;)V", "getDocument", "()Lorg/jdom2/Document;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class InvalidBean
        extends ParseResult {
            @NotNull
            private final Document document;

            public InvalidBean(@NotNull Document document2) {
                Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
                super(null);
                this.document = document2;
            }

            @NotNull
            public final Document getDocument() {
                return this.document;
            }

            @NotNull
            public final Document component1() {
                return this.document;
            }

            @NotNull
            public final InvalidBean copy(@NotNull Document document2) {
                Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
                return new InvalidBean(document2);
            }

            public static /* synthetic */ InvalidBean copy$default(InvalidBean invalidBean, Document document2, int n, Object object) {
                if ((n & 1) != 0) {
                    document2 = invalidBean.document;
                }
                return invalidBean.copy(document2);
            }

            @NotNull
            public String toString() {
                return "InvalidBean(document=" + this.document + ")";
            }

            public int hashCode() {
                return this.document.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InvalidBean)) {
                    return false;
                }
                InvalidBean invalidBean = (InvalidBean)other;
                return Intrinsics.areEqual((Object)this.document, (Object)invalidBean.document);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidXml;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "()V", "structure-intellij"})
        public static final class InvalidXml
        extends ParseResult {
            @NotNull
            public static final InvalidXml INSTANCE = new InvalidXml();

            private InvalidXml() {
                super(null);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$Parsed;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "document", "Lorg/jdom2/Document;", "bean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "(Lorg/jdom2/Document;Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;)V", "getBean", "()Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "getDocument", "()Lorg/jdom2/Document;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class Parsed
        extends ParseResult {
            @NotNull
            private final Document document;
            @NotNull
            private final PluginBean bean;

            public Parsed(@NotNull Document document2, @NotNull PluginBean bean) {
                Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
                Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
                super(null);
                this.document = document2;
                this.bean = bean;
            }

            @NotNull
            public final Document getDocument() {
                return this.document;
            }

            @NotNull
            public final PluginBean getBean() {
                return this.bean;
            }

            @NotNull
            public final Document component1() {
                return this.document;
            }

            @NotNull
            public final PluginBean component2() {
                return this.bean;
            }

            @NotNull
            public final Parsed copy(@NotNull Document document2, @NotNull PluginBean bean) {
                Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
                Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
                return new Parsed(document2, bean);
            }

            public static /* synthetic */ Parsed copy$default(Parsed parsed, Document document2, PluginBean pluginBean, int n, Object object) {
                if ((n & 1) != 0) {
                    document2 = parsed.document;
                }
                if ((n & 2) != 0) {
                    pluginBean = parsed.bean;
                }
                return parsed.copy(document2, pluginBean);
            }

            @NotNull
            public String toString() {
                return "Parsed(document=" + this.document + ", bean=" + this.bean + ")";
            }

            public int hashCode() {
                int result = this.document.hashCode();
                result = result * 31 + this.bean.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Parsed)) {
                    return false;
                }
                Parsed parsed = (Parsed)other;
                if (!Intrinsics.areEqual((Object)this.document, (Object)parsed.document)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.bean, (Object)parsed.bean);
            }
        }
    }
}

