/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdeTheme;
import com.jetbrains.plugin.structure.intellij.problems.UnableToFindTheme;
import com.jetbrains.plugin.structure.intellij.problems.UnableToReadTheme;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u0005\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0015\u001a\u00020\u0014*\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader;", "", "()V", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "load", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "descriptorPath", "Ljava/nio/file/Path;", "resolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdeTheme;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result$Found;", "themePath", "", "unableToFind", "", "unableToRead", "Result", "SimpleProblemRegistrar", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginThemeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginThemeLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1603#2,9:93\n1855#2:102\n1856#2:104\n1612#2:105\n1#3:103\n1#3:106\n*E\n*S KotlinDebug\n*F\n+ 1 PluginThemeLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader\n*L\n24#1,9:93\n24#1:102\n24#1:104\n24#1:105\n24#1:103\n*E\n"})
public final class PluginThemeLoader {
    @NotNull
    private final ObjectMapper json = ExtensionsKt.jacksonObjectMapper();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result load(@NotNull IdePlugin plugin, @NotNull Path descriptorPath, @NotNull ResourceResolver resolver, @NotNull ProblemRegistrar problemRegistrar) {
        Result result;
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)problemRegistrar, (String)"problemRegistrar");
        List<Element> list = plugin.getExtensions().get("com.intellij.themeProvider");
        if (list != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv;
                boolean bl2 = false;
                Attribute attribute = it.getAttribute("path");
                if ((attribute != null ? attribute.getValue() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return Result.NotFound.INSTANCE;
        }
        List themePaths = (List)destination$iv$iv;
        List themes = new ArrayList();
        SimpleProblemRegistrar problems = new SimpleProblemRegistrar(null, 1, null);
        Object object = themePaths.iterator();
        while (object.hasNext()) {
            String themePath = (String)object.next();
            Object absolutePath = StringsKt.startsWith$default((String)themePath, (String)"/", (boolean)false, (int)2, null) ? themePath : "/" + themePath;
            ResourceResolver.Result resolvedTheme = resolver.resolveResource((String)absolutePath, descriptorPath);
            if (resolvedTheme instanceof ResourceResolver.Result.Found) {
                if (this.load((ResourceResolver.Result.Found)resolvedTheme, descriptorPath, themePath, (ProblemRegistrar)problems) != null) {
                    IdeTheme it;
                    boolean bl = false;
                    ((Collection)themes).add(it);
                }
                continue;
            }
            if (resolvedTheme instanceof ResourceResolver.Result.NotFound) {
                this.unableToFind(problems, descriptorPath, themePath);
                continue;
            }
            if (!(resolvedTheme instanceof ResourceResolver.Result.Failed)) continue;
            this.unableToRead(problems, descriptorPath, themePath);
        }
        if (!((Collection)themes).isEmpty() && problems.isEmpty()) {
            result = new Result.Found(themes);
        } else if (problems.isNotEmpty()) {
            Object it = object = Result.Failed.INSTANCE;
            boolean bl = false;
            problems.copyTo(problemRegistrar);
            result = (Result)object;
        } else {
            result = Result.NotFound.INSTANCE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IdeTheme load(ResourceResolver.Result.Found $this$load, Path descriptorPath, String themePath, ProblemRegistrar problemRegistrar) {
        IdeTheme ideTheme;
        Closeable closeable = $this$load;
        Throwable throwable = null;
        try {
            Object object;
            Object $this$load_u24lambda_u245_u24lambda_u243;
            ResourceResolver.Result.Found it = (ResourceResolver.Result.Found)closeable;
            boolean bl = false;
            Object object2 = $this$load;
            try {
                $this$load_u24lambda_u245_u24lambda_u243 = object2;
                boolean bl2 = false;
                $this$load_u24lambda_u245_u24lambda_u243 = kotlin.Result.constructor-impl((Object)((IdeTheme)this.json.readValue(it.getResourceStream(), IdeTheme.class)));
            }
            catch (Throwable bl2) {
                $this$load_u24lambda_u245_u24lambda_u243 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$load_u24lambda_u245_u24lambda_u243;
            Throwable throwable2 = kotlin.Result.exceptionOrNull-impl((Object)object2);
            if (throwable2 == null) {
                object = object2;
            } else {
                Throwable it2 = throwable2;
                boolean bl3 = false;
                this.unableToRead(problemRegistrar, descriptorPath, themePath);
                object = null;
            }
            ideTheme = (IdeTheme)object;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return ideTheme;
    }

    private final void unableToRead(ProblemRegistrar $this$unableToRead, Path descriptorPath, String themePath) {
        $this$unableToRead.registerProblem((PluginProblem)new UnableToReadTheme(((Object)descriptorPath.getFileName()).toString(), themePath));
    }

    private final void unableToFind(ProblemRegistrar $this$unableToFind, Path descriptorPath, String themePath) {
        $this$unableToFind.registerProblem((PluginProblem)new UnableToFindTheme(((Object)descriptorPath.getFileName()).toString(), themePath));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result;", "", "()V", "Failed", "Found", "NotFound", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result$Failed;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result$Found;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result$NotFound;", "structure-intellij"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result$Failed;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result;", "()V", "structure-intellij"})
        public static final class Failed
        extends Result {
            @NotNull
            public static final Failed INSTANCE = new Failed();

            private Failed() {
                super(null);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result$Found;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result;", "themes", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdeTheme;", "(Ljava/util/List;)V", "getThemes", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class Found
        extends Result {
            @NotNull
            private final List<IdeTheme> themes;

            public Found(@NotNull List<IdeTheme> themes) {
                Intrinsics.checkNotNullParameter(themes, (String)"themes");
                super(null);
                this.themes = themes;
            }

            @NotNull
            public final List<IdeTheme> getThemes() {
                return this.themes;
            }

            @NotNull
            public final List<IdeTheme> component1() {
                return this.themes;
            }

            @NotNull
            public final Found copy(@NotNull List<IdeTheme> themes) {
                Intrinsics.checkNotNullParameter(themes, (String)"themes");
                return new Found(themes);
            }

            public static /* synthetic */ Found copy$default(Found found, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = found.themes;
                }
                return found.copy(list);
            }

            @NotNull
            public String toString() {
                return "Found(themes=" + this.themes + ")";
            }

            public int hashCode() {
                return ((Object)this.themes).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Found)) {
                    return false;
                }
                Found found = (Found)other;
                return Intrinsics.areEqual(this.themes, found.themes);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result$NotFound;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$Result;", "()V", "structure-intellij"})
        public static final class NotFound
        extends Result {
            @NotNull
            public static final NotFound INSTANCE = new NotFound();

            private NotFound() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$SimpleProblemRegistrar;", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "problems", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "(Ljava/util/List;)V", "getProblems", "()Ljava/util/List;", "copyTo", "", "other", "isEmpty", "", "isNotEmpty", "registerProblem", "problem", "structure-intellij"})
    @SourceDebugExtension(value={"SMAP\nPluginThemeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginThemeLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$SimpleProblemRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1855#2,2:93\n*E\n*S KotlinDebug\n*F\n+ 1 PluginThemeLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginThemeLoader$SimpleProblemRegistrar\n*L\n83#1,2:93\n*E\n"})
    private static final class SimpleProblemRegistrar
    implements ProblemRegistrar {
        @NotNull
        private final List<PluginProblem> problems;

        public SimpleProblemRegistrar(@NotNull List<PluginProblem> problems) {
            Intrinsics.checkNotNullParameter(problems, (String)"problems");
            this.problems = problems;
        }

        public /* synthetic */ SimpleProblemRegistrar(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<PluginProblem> getProblems() {
            return this.problems;
        }

        @Override
        public void registerProblem(@NotNull PluginProblem problem) {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            ((Collection)this.problems).add(problem);
        }

        public final boolean isNotEmpty() {
            return !((Collection)this.problems).isEmpty();
        }

        public final boolean isEmpty() {
            return this.problems.isEmpty();
        }

        public final void copyTo(@NotNull ProblemRegistrar other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Iterable $this$forEach$iv = this.problems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PluginProblem it = (PluginProblem)element$iv;
                boolean bl = false;
                other.registerProblem(it);
            }
        }

        public SimpleProblemRegistrar() {
            this(null, 1, null);
        }
    }
}

