/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems;

import com.jetbrains.plugin.structure.base.problems.InvalidDescriptorProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.ProblemSolutionHint;
import com.jetbrains.plugin.structure.intellij.version.ProductReleaseVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/ReleaseVersionAndPluginVersionMismatch;", "Lcom/jetbrains/plugin/structure/base/problems/InvalidDescriptorProblem;", "descriptorPath", "", "releaseVersion", "Lcom/jetbrains/plugin/structure/intellij/version/ProductReleaseVersion;", "pluginVersion", "(Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/version/ProductReleaseVersion;Ljava/lang/String;)V", "hint", "Lcom/jetbrains/plugin/structure/base/problems/ProblemSolutionHint;", "getHint", "()Lcom/jetbrains/plugin/structure/base/problems/ProblemSolutionHint;", "level", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem$Level;", "getLevel", "()Lcom/jetbrains/plugin/structure/base/problems/PluginProblem$Level;", "structure-intellij"})
public final class ReleaseVersionAndPluginVersionMismatch
extends InvalidDescriptorProblem {
    public ReleaseVersionAndPluginVersionMismatch(@NotNull String descriptorPath, @NotNull ProductReleaseVersion releaseVersion, @NotNull String pluginVersion) {
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)releaseVersion, (String)"releaseVersion");
        Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
        super(descriptorPath, "The <release-version> parameter [" + releaseVersion + "] and the plugin version [" + pluginVersion + "] should have a matching beginning. For example, release version '20201' should match plugin version 2020.1.1");
    }

    @NotNull
    public PluginProblem.Level getLevel() {
        return PluginProblem.Level.ERROR;
    }

    @NotNull
    public ProblemSolutionHint getHint() {
        return new ProblemSolutionHint("release-version=\"20201\" and <version>2020.1</version>", "https://plugins.jetbrains.com/docs/marketplace/add-required-parameters.html");
    }
}

