/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems.remapping;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblems;
import com.jetbrains.plugin.structure.intellij.problems.IgnoredLevel;
import com.jetbrains.plugin.structure.intellij.problems.LevelRemappingPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.StandardLevel;
import com.jetbrains.plugin.structure.intellij.problems.remapping.LevelRemappingDefinition;
import com.jetbrains.plugin.structure.intellij.problems.remapping.LevelRemappingDefinitions;
import com.jetbrains.plugin.structure.intellij.problems.remapping.ProblemLevelRemappingManager;
import com.jetbrains.plugin.structure.intellij.problems.remapping.RemappingSet;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/remapping/JsonUrlProblemLevelRemappingManager;", "Lcom/jetbrains/plugin/structure/intellij/problems/remapping/ProblemLevelRemappingManager;", "pluginProblemsJsonUrl", "Ljava/net/URL;", "(Ljava/net/URL;)V", "initialize", "Lcom/jetbrains/plugin/structure/intellij/problems/remapping/LevelRemappingDefinitions;", "load", "Companion", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nProblemLevelRemappingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemLevelRemappingManager.kt\ncom/jetbrains/plugin/structure/intellij/problems/remapping/JsonUrlProblemLevelRemappingManager\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n49#2:118\n43#2:119\n125#3:120\n152#3,2:121\n135#3,9:123\n215#3:132\n216#3:134\n144#3:135\n154#3:136\n1#4:133\n*E\n*S KotlinDebug\n*F\n+ 1 ProblemLevelRemappingManager.kt\ncom/jetbrains/plugin/structure/intellij/problems/remapping/JsonUrlProblemLevelRemappingManager\n*L\n67#1:118\n67#1:119\n69#1:120\n69#1,2:121\n71#1,9:123\n71#1:132\n71#1:134\n71#1:135\n69#1:136\n71#1:133\n*E\n"})
public final class JsonUrlProblemLevelRemappingManager
implements ProblemLevelRemappingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL pluginProblemsJsonUrl;
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();
    @NotNull
    public static final String PLUGIN_PROBLEMS_FILE_NAME = "plugin-problems.json";

    public JsonUrlProblemLevelRemappingManager(@NotNull URL pluginProblemsJsonUrl) {
        Intrinsics.checkNotNullParameter((Object)pluginProblemsJsonUrl, (String)"pluginProblemsJsonUrl");
        this.pluginProblemsJsonUrl = pluginProblemsJsonUrl;
    }

    @Override
    @NotNull
    public LevelRemappingDefinitions initialize() throws IOException {
        return this.load();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LevelRemappingDefinitions load() throws IOException {
        LevelRemappingDefinitions definitions = new LevelRemappingDefinitions();
        try {
            void $this$mapTo$iv$iv;
            void $this$readValue$iv;
            Map rawRemapping;
            ObjectMapper objectMapper = JsonUrlProblemLevelRemappingManager.objectMapper;
            URL src$iv = this.pluginProblemsJsonUrl;
            boolean $i$f$readValue22 = false;
            boolean $i$f$jacksonTypeRef = false;
            Map $this$map$iv = rawRemapping = (Map)$this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<Map<String, ? extends Map<String, ? extends String>>>(){});
            boolean $i$f$map = false;
            Map $i$f$readValue22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapNotNullTo$iv$iv;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String id = (String)entry.getKey();
                Map problemRemapping = (Map)entry.getValue();
                RemappingSet remappingSet = RemappingSet.Companion.fromId(id);
                Map $this$mapNotNull$iv = problemRemapping;
                boolean $i$f$mapNotNull = false;
                Map map = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Pair pair;
                    block23: {
                        String problemLevel;
                        block22: {
                            Map.Entry element$iv$iv$iv;
                            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl2 = false;
                            Map.Entry entry2 = element$iv$iv;
                            boolean bl3 = false;
                            String problemId = (String)entry2.getKey();
                            problemLevel = (String)entry2.getValue();
                            if (PluginProblems.INSTANCE.resolveClass(problemId) != null) break block22;
                            pair = null;
                            break block23;
                        }
                        switch (problemLevel) {
                            case "ignore": {
                                KClass pluginProblemKClass;
                                pair = TuplesKt.to((Object)pluginProblemKClass, (Object)IgnoredLevel.INSTANCE);
                                break;
                            }
                            case "warning": {
                                KClass pluginProblemKClass;
                                pair = TuplesKt.to((Object)pluginProblemKClass, (Object)new StandardLevel(PluginProblem.Level.WARNING));
                                break;
                            }
                            case "unacceptable-warning": {
                                KClass pluginProblemKClass;
                                pair = TuplesKt.to((Object)pluginProblemKClass, (Object)new StandardLevel(PluginProblem.Level.UNACCEPTABLE_WARNING));
                                break;
                            }
                            case "error": {
                                KClass pluginProblemKClass;
                                pair = TuplesKt.to((Object)pluginProblemKClass, (Object)new StandardLevel(PluginProblem.Level.ERROR));
                                break;
                            }
                            default: {
                                pair = null;
                            }
                        }
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Map levelRemapping = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                definitions.set(remappingSet, levelRemapping);
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        catch (IOException e) {
            throw new IOException("Cannot load plugin problems definitions from <" + this.pluginProblemsJsonUrl + ">", e);
        }
        catch (StreamReadException e) {
            throw new IOException("Cannot parse plugin problems definitions from JSON in <" + this.pluginProblemsJsonUrl + ">", e);
        }
        catch (DatabindException e) {
            throw new IOException("Cannot deserialize plugin problems definitions from JSON in <" + this.pluginProblemsJsonUrl + ">", e);
        }
        return definitions;
    }

    @Override
    @NotNull
    public LevelRemappingDefinition getLevelRemapping(@NotNull RemappingSet remappingSet) {
        return ProblemLevelRemappingManager.DefaultImpls.getLevelRemapping(this, remappingSet);
    }

    @Override
    @NotNull
    public PluginCreationResultResolver newDefaultResolver(@NotNull RemappingSet remappingSet) {
        return ProblemLevelRemappingManager.DefaultImpls.newDefaultResolver(this, remappingSet);
    }

    @Override
    @NotNull
    public PluginCreationResultResolver defaultExistingPluginResolver() {
        return ProblemLevelRemappingManager.DefaultImpls.defaultExistingPluginResolver(this);
    }

    @Override
    @NotNull
    public PluginCreationResultResolver defaultNewPluginResolver() {
        return ProblemLevelRemappingManager.DefaultImpls.defaultNewPluginResolver(this);
    }

    @Override
    @NotNull
    public LevelRemappingPluginCreationResultResolver defaultJetBrainsPluginResolver(@NotNull PluginCreationResultResolver defaultResolver) {
        return ProblemLevelRemappingManager.DefaultImpls.defaultJetBrainsPluginResolver(this, defaultResolver);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/remapping/JsonUrlProblemLevelRemappingManager$Companion;", "", "()V", "PLUGIN_PROBLEMS_FILE_NAME", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "fromClassPathJson", "Lcom/jetbrains/plugin/structure/intellij/problems/remapping/JsonUrlProblemLevelRemappingManager;", "structure-intellij"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonUrlProblemLevelRemappingManager fromClassPathJson() throws IOException {
            URL uRL = this.getClass().getResource(JsonUrlProblemLevelRemappingManager.PLUGIN_PROBLEMS_FILE_NAME);
            if (uRL == null) {
                throw new IOException("Plugin problem level remapping definition cannot be found at <plugin-problems.json>");
            }
            URL pluginProblemsJsonUrl = uRL;
            return new JsonUrlProblemLevelRemappingManager(pluginProblemsJsonUrl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

