/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.verifiers;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.intellij.beans.IdeaVersionBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.problems.InvalidUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.InvalidUntilBuildWithJustBranch;
import com.jetbrains.plugin.structure.intellij.problems.InvalidUntilBuildWithMagicNumber;
import com.jetbrains.plugin.structure.intellij.problems.NonexistentReleaseInUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.ProductCodePrefixInBuild;
import com.jetbrains.plugin.structure.intellij.problems.SuspiciousUntilBuild;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0019\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginUntilBuildVerifier;", "", "()V", "isJustASingleComponent", "", "untilBuild", "", "isSpecialSingleComponent", "verify", "", "plugin", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "descriptorPath", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "verifyBaseLineVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "untilBuildValue", "verifyBaseline", "baseline", "", "verifyInThreeReleasesPerYear", "baselineVersion", "verifyMagicNumber", "Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginUntilBuildVerifier$ValidationResult;", "verifySingleComponentUntilBuild", "ValidationResult", "structure-intellij"})
public final class PluginUntilBuildVerifier {
    public final void verify(@NotNull PluginBean plugin, @NotNull String descriptorPath, @NotNull ProblemRegistrar problemRegistrar) {
        String string;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemRegistrar, (String)"problemRegistrar");
        ProblemRegistrar $this$verify_u24lambda_u240 = problemRegistrar;
        boolean bl = false;
        IdeaVersionBean ideaVersionBean = plugin.ideaVersion;
        String string2 = string = ideaVersionBean != null ? ideaVersionBean.untilBuild : null;
        if (string2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"plugin.ideaVersion?.untilBuild ?: return");
        String untilBuild = string;
        if (this.isJustASingleComponent(untilBuild)) {
            if (this.isSpecialSingleComponent(untilBuild)) {
                return;
            }
            if (this.verifyMagicNumber(untilBuild, descriptorPath, problemRegistrar) == ValidationResult.INVALID) {
                return;
            }
            $this$verify_u24lambda_u240.registerProblem((PluginProblem)new InvalidUntilBuildWithJustBranch(descriptorPath, untilBuild));
            this.verifySingleComponentUntilBuild(untilBuild, descriptorPath, problemRegistrar);
            return;
        }
        IdeVersion untilBuildParsed = IdeVersion.createIdeVersionIfValid(untilBuild);
        if (untilBuildParsed == null) {
            $this$verify_u24lambda_u240.registerProblem((PluginProblem)new InvalidUntilBuild(descriptorPath, untilBuild, null, null, 12, null));
        } else {
            this.verifyBaseLineVersion(untilBuildParsed, untilBuild, descriptorPath, problemRegistrar);
            if (((CharSequence)untilBuildParsed.getProductCode()).length() > 0) {
                $this$verify_u24lambda_u240.registerProblem((PluginProblem)new ProductCodePrefixInBuild(descriptorPath));
            }
        }
    }

    private final void verifyBaseLineVersion(IdeVersion untilBuild, String untilBuildValue, String descriptorPath, ProblemRegistrar problemRegistrar) {
        ProblemRegistrar $this$verifyBaseLineVersion_u24lambda_u241 = problemRegistrar;
        boolean bl = false;
        this.verifyBaseline(untilBuild.getBaselineVersion(), untilBuildValue, untilBuild, descriptorPath, problemRegistrar);
    }

    private final void verifyBaseline(int baseline, String untilBuildValue, IdeVersion untilBuild, String descriptorPath, ProblemRegistrar problemRegistrar) {
        ProblemRegistrar $this$verifyBaseline_u24lambda_u242 = problemRegistrar;
        boolean bl = false;
        if (baseline >= 2016) {
            $this$verifyBaseline_u24lambda_u242.registerProblem((PluginProblem)new InvalidUntilBuild(descriptorPath, untilBuildValue, untilBuild, null, 8, null));
        } else if (baseline >= 999) {
            $this$verifyBaseline_u24lambda_u242.registerProblem((PluginProblem)new InvalidUntilBuildWithMagicNumber(descriptorPath, untilBuildValue, String.valueOf(baseline)));
        } else if (baseline >= 281) {
            $this$verifyBaseline_u24lambda_u242.registerProblem(new SuspiciousUntilBuild(untilBuildValue, null, 2, null));
        } else {
            this.verifyInThreeReleasesPerYear(untilBuildValue, baseline, problemRegistrar);
        }
    }

    private final ValidationResult verifyMagicNumber(String untilBuildValue, String descriptorPath, ProblemRegistrar problemRegistrar) {
        ValidationResult validationResult2;
        ProblemRegistrar $this$verifyMagicNumber_u24lambda_u243 = problemRegistrar;
        boolean bl = false;
        Integer n = StringsKt.toIntOrNull((String)untilBuildValue);
        if (n == null) {
            return ValidationResult.NOT_APPLICABLE;
        }
        int untilBuild = n;
        if (untilBuild >= 999) {
            $this$verifyMagicNumber_u24lambda_u243.registerProblem((PluginProblem)new InvalidUntilBuildWithMagicNumber(descriptorPath, untilBuildValue, untilBuildValue));
            validationResult2 = ValidationResult.INVALID;
        } else {
            validationResult2 = ValidationResult.VALID;
        }
        return validationResult2;
    }

    private final void verifySingleComponentUntilBuild(String untilBuild, String descriptorPath, ProblemRegistrar problemRegistrar) {
        try {
            int untilBuildNumber = Integer.parseInt(untilBuild);
            this.verifyBaseline(untilBuildNumber, untilBuild, null, descriptorPath, problemRegistrar);
        }
        catch (NumberFormatException e) {
            problemRegistrar.registerProblem((PluginProblem)new InvalidUntilBuild(descriptorPath, untilBuild, null, null, 12, null));
        }
    }

    private final void verifyInThreeReleasesPerYear(String untilBuildValue, int baselineVersion, ProblemRegistrar problemRegistrar) {
        ProblemRegistrar $this$verifyInThreeReleasesPerYear_u24lambda_u244 = problemRegistrar;
        boolean bl = false;
        if (baselineVersion >= 162) {
            int lastDigit = baselineVersion % 10;
            int releaseVersion = baselineVersion / 10;
            if (!(1 <= lastDigit ? lastDigit < 4 : false)) {
                $this$verifyInThreeReleasesPerYear_u24lambda_u244.registerProblem(new NonexistentReleaseInUntilBuild(untilBuildValue, "20" + releaseVersion + "." + lastDigit));
            }
        }
    }

    private final boolean isSpecialSingleComponent(String untilBuild) {
        return Intrinsics.areEqual((Object)"__BUILD_NUMBER__", (Object)untilBuild) || Intrinsics.areEqual((Object)"SNAPSHOT", (Object)untilBuild);
    }

    private final boolean isJustASingleComponent(String untilBuild) {
        if (!StringsKt.contains$default((CharSequence)untilBuild, (char)'.', (boolean)false, (int)2, null) && !StringsKt.isBlank((CharSequence)untilBuild)) {
            return true;
        }
        char[] cArray = new char[]{'.'};
        int components = StringsKt.split$default((CharSequence)untilBuild, (char[])cArray, (boolean)false, (int)0, (int)6, null).size();
        return components == 1;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/PluginUntilBuildVerifier$ValidationResult;", "", "(Ljava/lang/String;I)V", "VALID", "INVALID", "NOT_APPLICABLE", "structure-intellij"})
    private static final class ValidationResult
    extends Enum<ValidationResult> {
        public static final /* enum */ ValidationResult VALID = new ValidationResult();
        public static final /* enum */ ValidationResult INVALID = new ValidationResult();
        public static final /* enum */ ValidationResult NOT_APPLICABLE = new ValidationResult();
        private static final /* synthetic */ ValidationResult[] $VALUES;

        public static ValidationResult[] values() {
            return (ValidationResult[])$VALUES.clone();
        }

        public static ValidationResult valueOf(String value) {
            return Enum.valueOf(ValidationResult.class, value);
        }

        static {
            $VALUES = validationResultArray = new ValidationResult[]{ValidationResult.VALID, ValidationResult.INVALID, ValidationResult.NOT_APPLICABLE};
        }
    }
}

