/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.verifiers;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.problems.ElementAvailableOnlySinceNewerVersion;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/verifiers/ProjectAndApplicationListenerAvailabilityVerifier;", "", "()V", "listenersAvailableSinceBuild", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "Lorg/jetbrains/annotations/NotNull;", "verify", "", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "problemRegistrar", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "registerUnavailableElement", "sinceBuild", "elementName", "", "structure-intellij"})
public final class ProjectAndApplicationListenerAvailabilityVerifier {
    @NotNull
    private final IdeVersion listenersAvailableSinceBuild;

    public ProjectAndApplicationListenerAvailabilityVerifier() {
        IdeVersion ideVersion = IdeVersion.createIdeVersion("193");
        Intrinsics.checkNotNullExpressionValue((Object)ideVersion, (String)"createIdeVersion(\"193\")");
        this.listenersAvailableSinceBuild = ideVersion;
    }

    public final void verify(@NotNull IdePlugin plugin, @NotNull ProblemRegistrar problemRegistrar) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)problemRegistrar, (String)"problemRegistrar");
        IdeVersion sinceBuild = plugin.getSinceBuild();
        if (sinceBuild == null || sinceBuild.compareTo(this.listenersAvailableSinceBuild) >= 0) {
            return;
        }
        if (!((Collection)plugin.getAppContainerDescriptor().getListeners()).isEmpty()) {
            this.registerUnavailableElement(problemRegistrar, plugin, sinceBuild, "applicationListeners");
        }
        if (!((Collection)plugin.getProjectContainerDescriptor().getListeners()).isEmpty()) {
            this.registerUnavailableElement(problemRegistrar, plugin, sinceBuild, "projectListeners");
        }
    }

    private final void registerUnavailableElement(ProblemRegistrar $this$registerUnavailableElement, IdePlugin plugin, IdeVersion sinceBuild, String elementName) {
        $this$registerUnavailableElement.registerProblem(new ElementAvailableOnlySinceNewerVersion(elementName, this.listenersAvailableSinceBuild, sinceBuild, plugin.getUntilBuild()));
    }
}

