/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public abstract class NotNullLazyValue<T> {
    private T myValue;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
    protected NotNullLazyValue() {
    }

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result2 = this.myValue;
        if (result2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result2;
            }
        }
        T t2 = result2;
        if (t2 == null) {
            NotNullLazyValue.$$$reportNull$$$0(0);
        }
        return t2;
    }

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(@NotNull T value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(1);
        }
        return NotNullLazyValue.lazy(() -> value);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createValue(@NotNull NotNullFactory<? extends T> value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(2);
        }
        return NotNullLazyValue.lazy(value::create);
    }

    @NotNull
    public static <T> NotNullLazyValue<T> lazy(final @NotNull Supplier<? extends T> value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(3);
        }
        return new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t2 = value.get();
                if (t2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return t2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$1", "compute"));
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> atomicLazy(final @NotNull @NotNull Supplier<@NotNull ? extends T> value) {
        if (value == null) {
            NotNullLazyValue.$$$reportNull$$$0(4);
        }
        return new AtomicNotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t2 = value.get();
                if (t2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return t2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$2", "compute"));
            }
        };
    }

    @NotNull
    public static <T> NotNullLazyValue<T> volatileLazy(final @NotNull @NotNull Supplier<@NotNull ? extends T> supplier) {
        if (supplier == null) {
            NotNullLazyValue.$$$reportNull$$$0(5);
        }
        return new NotNullLazyValue<T>(){
            private volatile T value;

            @Override
            @NotNull
            public T getValue() {
                Object value = this.value;
                if (value == null) {
                    RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                    value = this.compute();
                    if (stamp.mayCacheNow()) {
                        this.value = value;
                    }
                }
                Object t2 = value;
                if (t2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return t2;
            }

            @Override
            public boolean isComputed() {
                return this.value != null;
            }

            @Override
            @NotNull
            protected T compute() {
                Object t2 = supplier.get();
                if (t2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return t2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/util/NotNullLazyValue$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "compute";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/NotNullLazyValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/NotNullLazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConstantValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lazy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "atomicLazy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "volatileLazy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

