/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.fastutil;

import com.intellij.util.lang.fastutil.Hash;
import java.util.NoSuchElementException;

public final class StrippedLongOpenHashSet {
    private transient long[] key;
    private transient int mask;
    private transient boolean containsNull;
    private transient int n;
    private transient int maxFill;
    private final transient int minN;
    private int size;
    private final float f;

    public StrippedLongOpenHashSet(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = Hash.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = Hash.maxFill(this.n, f);
        this.key = new long[this.n + 1];
    }

    public StrippedLongOpenHashSet(int expected) {
        this(expected, 0.75f);
    }

    public StrippedLongOpenHashSet() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public boolean add(long k) {
        if (k == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            long[] key = this.key;
            int pos = (int)Hash.mix(k) & this.mask;
            long curr = key[pos];
            if (curr != 0L) {
                if (curr == k) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0L) {
                    if (curr != k) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize(this.size + 1, this.f));
        }
        return true;
    }

    private void shiftKeys(int pos) {
        long[] key = this.key;
        while (true) {
            long curr;
            int last2 = pos;
            pos = last2 + 1 & this.mask;
            while (true) {
                if ((curr = key[pos]) == 0L) {
                    key[last2] = 0L;
                    return;
                }
                int slot = (int)Hash.mix(curr) & this.mask;
                if (last2 <= pos ? last2 >= slot || slot > pos : last2 >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key[last2] = curr;
        }
    }

    private boolean removeEntry(int pos) {
        --this.size;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0L;
        --this.size;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    public boolean remove(long k) {
        if (k == 0L) {
            if (this.containsNull) {
                return this.removeNullEntry();
            }
            return false;
        }
        long[] key = this.key;
        int pos = (int)Hash.mix(k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return false;
        }
        if (k == curr) {
            return this.removeEntry(pos);
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k != curr);
        return this.removeEntry(pos);
    }

    public boolean contains(long k) {
        if (k == 0L) {
            return this.containsNull;
        }
        long[] key = this.key;
        int pos = (int)Hash.mix(k) & this.mask;
        long curr = key[pos];
        if (curr == 0L) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k != curr);
        return true;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public SetIterator iterator() {
        return new SetIterator();
    }

    private void rehash(int newN) {
        long[] key = this.key;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0L) {
            }
            int pos = (int)Hash.mix(key[i]) & mask;
            if (newKey[pos] != 0L) {
                while (newKey[pos = pos + 1 & mask] != 0L) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public int hashCode() {
        int h2 = 0;
        int j = this.realSize();
        int i = 0;
        while (j-- != 0) {
            while (this.key[i] == 0L) {
                ++i;
            }
            h2 += Hash.long2int(this.key[i]);
            ++i;
        }
        return h2;
    }

    public final class SetIterator {
        int pos;
        int c;
        boolean mustReturnNull;

        public SetIterator() {
            this.pos = StrippedLongOpenHashSet.this.n;
            this.c = StrippedLongOpenHashSet.this.size;
            this.mustReturnNull = StrippedLongOpenHashSet.this.containsNull;
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public long nextLong() {
            long v;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                return StrippedLongOpenHashSet.this.key[StrippedLongOpenHashSet.this.n];
            }
            long[] key = StrippedLongOpenHashSet.this.key;
            while ((v = key[--this.pos]) == 0L) {
            }
            return v;
        }
    }
}

