/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.blockmap.core;

import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/blockmap/core/ChunkMerger;", "", "oldFile", "Ljava/io/File;", "oldBlockMap", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "newBlockMap", "bufferSize", "", "(Ljava/io/File;Lcom/jetbrains/plugin/blockmap/core/BlockMap;Lcom/jetbrains/plugin/blockmap/core/BlockMap;I)V", "buffer", "", "downloadChunkFromNewData", "", "newChunk", "Lcom/jetbrains/plugin/blockmap/core/Chunk;", "newChunkDataSource", "", "output", "Ljava/io/OutputStream;", "downloadChunkFromOldData", "oldChunk", "oldFileRAF", "Ljava/io/RandomAccessFile;", "merge", "blockmap"})
public class ChunkMerger {
    private final byte[] buffer;
    private final File oldFile;
    private final BlockMap oldBlockMap;
    private final BlockMap newBlockMap;
    private final int bufferSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void merge(@NotNull OutputStream output, @NotNull Iterator<byte[]> newChunkDataSource) throws IOException {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(newChunkDataSource, "newChunkDataSource");
        Closeable closeable = new RandomAccessFile(this.oldFile, "r");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            RandomAccessFile oldFileRAF = (RandomAccessFile)closeable;
            boolean bl3 = false;
            Closeable closeable2 = output;
            int n = 8192;
            boolean bl4 = false;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            n = 0;
            bl4 = false;
            Throwable throwable2 = null;
            try {
                void $this$associateByTo$iv$iv;
                BufferedOutputStream bufferedOutput = (BufferedOutputStream)closeable2;
                boolean bl5 = false;
                Iterable $this$associateBy$iv = this.oldBlockMap.getChunks();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    Chunk chunk = (Chunk)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl6 = false;
                    String string2 = it.getHash();
                    map2.put(string2, element$iv$iv);
                }
                Map oldMap = destination$iv$iv;
                for (Chunk newChunk : this.newBlockMap.getChunks()) {
                    Chunk oldChunk = (Chunk)oldMap.get(newChunk.getHash());
                    if (oldChunk != null) {
                        this.downloadChunkFromOldData(oldChunk, oldFileRAF, bufferedOutput);
                        continue;
                    }
                    this.downloadChunkFromNewData(newChunk, newChunkDataSource, bufferedOutput);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public void downloadChunkFromOldData(@NotNull Chunk oldChunk, @NotNull RandomAccessFile oldFileRAF, @NotNull OutputStream output) throws IOException {
        int length;
        Intrinsics.checkNotNullParameter(oldChunk, "oldChunk");
        Intrinsics.checkNotNullParameter(oldFileRAF, "oldFileRAF");
        Intrinsics.checkNotNullParameter(output, "output");
        oldFileRAF.seek(oldChunk.getOffset());
        for (int remainingBytes = oldChunk.getLength(); remainingBytes != 0; remainingBytes -= length) {
            length = remainingBytes >= this.bufferSize ? this.bufferSize : remainingBytes;
            oldFileRAF.read(this.buffer, 0, length);
            output.write(this.buffer, 0, length);
        }
    }

    public void downloadChunkFromNewData(@NotNull Chunk newChunk, @NotNull Iterator<byte[]> newChunkDataSource, @NotNull OutputStream output) throws IOException {
        byte[] chunkData;
        Intrinsics.checkNotNullParameter(newChunk, "newChunk");
        Intrinsics.checkNotNullParameter(newChunkDataSource, "newChunkDataSource");
        Intrinsics.checkNotNullParameter(output, "output");
        if (newChunkDataSource.hasNext()) {
            chunkData = newChunkDataSource.next();
            if (chunkData.length != newChunk.getLength()) {
                throw (Throwable)new IOException("Received chunk has wrong length: " + chunkData.length + " but expected " + newChunk.getLength() + '.');
            }
        } else {
            throw (Throwable)new IOException("New chunks data iterator hasn't got enough chunks.");
        }
        output.write(chunkData);
    }

    public ChunkMerger(@NotNull File oldFile, @NotNull BlockMap oldBlockMap, @NotNull BlockMap newBlockMap, int bufferSize) {
        Intrinsics.checkNotNullParameter(oldFile, "oldFile");
        Intrinsics.checkNotNullParameter(oldBlockMap, "oldBlockMap");
        Intrinsics.checkNotNullParameter(newBlockMap, "newBlockMap");
        this.oldFile = oldFile;
        this.oldBlockMap = oldBlockMap;
        this.newBlockMap = newBlockMap;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
    }

    public /* synthetic */ ChunkMerger(File file2, BlockMap blockMap, BlockMap blockMap2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 8) != 0) {
            n = 65536;
        }
        this(file2, blockMap, blockMap2, n);
    }
}

