/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.resolver;

import com.jetbrains.plugin.structure.ide.layout.IdeRelativePath;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponents;
import com.jetbrains.plugin.structure.ide.layout.MissingClasspathFileInLayoutComponentException;
import com.jetbrains.plugin.structure.ide.layout.MissingLayoutFileMode;
import com.jetbrains.plugin.structure.ide.layout.ResolvedLayoutComponent;
import com.jetbrains.plugin.structure.ide.resolver.LayoutComponentsProvider;
import com.jetbrains.plugin.structure.ide.resolver.LayoutComponentsProviderKt;
import com.jetbrains.plugin.structure.intellij.platform.LayoutComponent;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00020\b*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/ide/resolver/LayoutComponentsProvider;", "", "missingLayoutFileMode", "Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;", "(Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;)V", "existingClasspaths", "", "", "Lcom/jetbrains/plugin/structure/ide/layout/ResolvedLayoutComponent;", "getExistingClasspaths", "(Lcom/jetbrains/plugin/structure/ide/layout/ResolvedLayoutComponent;)Ljava/util/List;", "logUnavailableClasspath", "", "failedComponents", "resolveLayoutComponents", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponents;", "productInfo", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "idePath", "Ljava/nio/file/Path;", "skipMissingClasspathElements", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nLayoutComponentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutComponentsProvider.kt\ncom/jetbrains/plugin/structure/ide/resolver/LayoutComponentsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n3190#2,10:65\n1549#2:75\n1620#2,3:76\n766#2:79\n857#2,2:80\n1549#2:82\n1620#2,3:83\n*E\n*S KotlinDebug\n*F\n+ 1 LayoutComponentsProvider.kt\ncom/jetbrains/plugin/structure/ide/resolver/LayoutComponentsProvider\n*L\n27#1,10:65\n32#1:75\n32#1,3:76\n53#1:79\n53#1,2:80\n54#1:82\n54#1,3:83\n*E\n"})
public final class LayoutComponentsProvider {
    private final MissingLayoutFileMode missingLayoutFileMode;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LayoutComponents resolveLayoutComponents(@NotNull ProductInfo productInfo, @NotNull Path idePath) throws MissingClasspathFileInLayoutComponentException {
        LayoutComponents layoutComponents;
        Intrinsics.checkNotNullParameter(productInfo, "productInfo");
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        LayoutComponents layoutComponents2 = LayoutComponents.Companion.of(idePath, productInfo);
        if (this.missingLayoutFileMode == MissingLayoutFileMode.IGNORE) {
            layoutComponents = layoutComponents2;
        } else {
            void okComponents;
            Iterable $this$partition$iv = layoutComponents2;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            Iterable<Object> second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                ResolvedLayoutComponent it = (ResolvedLayoutComponent)element$iv;
                boolean bl = false;
                if (it.allClasspathsExist()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List list = pair.component1();
            List failedComponents = pair.component2();
            List acceptedComponents = new ArrayList();
            Collection collection = failedComponents;
            if (!collection.isEmpty()) {
                if (this.missingLayoutFileMode == MissingLayoutFileMode.FAIL) {
                    throw (Throwable)MissingClasspathFileInLayoutComponentException.Companion.of(idePath, failedComponents);
                }
                if (this.missingLayoutFileMode == MissingLayoutFileMode.SKIP_CLASSPATH) {
                    void $this$mapTo$iv$iv;
                    collection = acceptedComponents;
                    Iterable $this$map$iv = failedComponents;
                    boolean $i$f$map = false;
                    second$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ResolvedLayoutComponent resolvedLayoutComponent = (ResolvedLayoutComponent)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        ResolvedLayoutComponent resolvedLayoutComponent2 = this.skipMissingClasspathElements((ResolvedLayoutComponent)it);
                        collection2.add(resolvedLayoutComponent2);
                    }
                    Iterable iterable = (List)destination$iv$iv;
                    CollectionsKt.addAll(collection, iterable);
                }
                this.logUnavailableClasspath(failedComponents);
            }
            layoutComponents = new LayoutComponents(CollectionsKt.plus((Collection)okComponents, (Iterable)acceptedComponents));
        }
        return layoutComponents;
    }

    private final ResolvedLayoutComponent skipMissingClasspathElements(ResolvedLayoutComponent $this$skipMissingClasspathElements) {
        LayoutComponent layoutComponent;
        LayoutComponent layoutComponent2;
        LayoutComponent $this$with = layoutComponent2 = $this$skipMissingClasspathElements.getLayoutComponent();
        boolean bl = false;
        LayoutComponent layoutComponent3 = $this$with;
        if (layoutComponent3 instanceof LayoutComponent.ModuleV2) {
            layoutComponent = LayoutComponent.ModuleV2.copy$default((LayoutComponent.ModuleV2)$this$with, null, this.getExistingClasspaths($this$skipMissingClasspathElements), 1, null);
        } else if (layoutComponent3 instanceof LayoutComponent.Plugin) {
            layoutComponent = LayoutComponent.Plugin.copy$default((LayoutComponent.Plugin)$this$with, null, this.getExistingClasspaths($this$skipMissingClasspathElements), 1, null);
        } else if (layoutComponent3 instanceof LayoutComponent.ProductModuleV2) {
            layoutComponent = LayoutComponent.ProductModuleV2.copy$default((LayoutComponent.ProductModuleV2)$this$with, null, this.getExistingClasspaths($this$skipMissingClasspathElements), 1, null);
        } else if (layoutComponent3 instanceof LayoutComponent.PluginAlias) {
            layoutComponent = $this$with;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LayoutComponent it = layoutComponent2 = layoutComponent;
        boolean bl2 = false;
        return new ResolvedLayoutComponent($this$skipMissingClasspathElements.getIdePath(), it);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getExistingClasspaths(ResolvedLayoutComponent $this$existingClasspaths) {
        void $this$mapTo$iv$iv;
        IdeRelativePath it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$existingClasspaths.resolveClasspaths();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeRelativePath)element$iv$iv;
            boolean bl = false;
            if (!it.getExists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeRelativePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = ((Object)it.getRelativePath()).toString();
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private final void logUnavailableClasspath(List<ResolvedLayoutComponent> failedComponents) {
        if (this.missingLayoutFileMode == MissingLayoutFileMode.SKIP_SILENTLY || !LayoutComponentsProviderKt.access$getLOG$p().isWarnEnabled()) {
            return;
        }
        String logMsg2 = CollectionsKt.joinToString$default(failedComponents, "\n", null, null, 0, null, logUnavailableClasspath.logMsg.1.INSTANCE, 30, null);
        LayoutComponentsProviderKt.access$getLOG$p().warn(logMsg2);
    }

    public LayoutComponentsProvider(@NotNull MissingLayoutFileMode missingLayoutFileMode) {
        Intrinsics.checkNotNullParameter((Object)missingLayoutFileMode, "missingLayoutFileMode");
        this.missingLayoutFileMode = missingLayoutFileMode;
    }
}

