/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.platform;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.ModuleBean;
import com.jetbrains.plugin.structure.intellij.extractor.ModuleUnmarshaller;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesResolver;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesResolverKt;
import com.jetbrains.plugin.structure.intellij.platform.InvalidIdeException;
import com.jetbrains.plugin.structure.intellij.platform.ModulesResolver;
import com.jetbrains.plugin.structure.jar.DefaultJarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/intellij/platform/BundledModulesResolver;", "Ljava/lang/AutoCloseable;", "Lcom/jetbrains/plugin/structure/intellij/platform/ModulesResolver;", "idePath", "Ljava/nio/file/Path;", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "getIdePath", "()Ljava/nio/file/Path;", "moduleDescriptorsJarPath", "close", "", "resolveModules", "", "Lcom/jetbrains/plugin/structure/intellij/beans/ModuleBean;", "unmarshallModule", "xmlPath", "structure-intellij"})
public final class BundledModulesResolver
implements AutoCloseable,
ModulesResolver {
    private final Path moduleDescriptorsJarPath;
    @NotNull
    private final Path idePath;
    private final JarFileSystemProvider jarFileSystemProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ModuleBean> resolveModules() {
        List<ModuleBean> list;
        FileSystem jarFs = this.jarFileSystemProvider.getFileSystem(this.moduleDescriptorsJarPath);
        Iterable<Path> iterable = jarFs.getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable, "jarFs.rootDirectories");
        Path path = CollectionsKt.first(iterable);
        Intrinsics.checkNotNullExpressionValue(path, "jarFs.rootDirectories.first()");
        Path root = path;
        AutoCloseable autoCloseable = Files.list(root);
        Throwable throwable = null;
        try {
            Stream files2 = (Stream)autoCloseable;
            boolean bl = false;
            Stream stream = files2;
            Intrinsics.checkNotNullExpressionValue(stream, "files");
            list = SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.filter(StreamsKt.asSequence(stream), resolveModules.1.1.INSTANCE), (Function1)new Function1<Path, ModuleBean>(this){

                @Nullable
                public final ModuleBean invoke(@NotNull Path p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    return BundledModulesResolver.access$unmarshallModule((BundledModulesResolver)this.receiver, p1);
                }
            }));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return list;
    }

    @Override
    public void close() {
        this.jarFileSystemProvider.close(this.moduleDescriptorsJarPath);
    }

    private final ModuleBean unmarshallModule(Path xmlPath) {
        try {
            return ModuleUnmarshaller.INSTANCE.unmarshall(xmlPath);
        }
        catch (JAXBException e) {
            BundledModulesResolverKt.access$getLOG$p().debug("Cannot unmarshall [{}/{}]: {}", this.moduleDescriptorsJarPath, xmlPath, e.getMessage());
            return null;
        }
    }

    @NotNull
    public final Path getIdePath() {
        return this.idePath;
    }

    public BundledModulesResolver(@NotNull Path idePath, @NotNull JarFileSystemProvider jarFileSystemProvider) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Intrinsics.checkNotNullParameter(jarFileSystemProvider, "jarFileSystemProvider");
        this.idePath = idePath;
        this.jarFileSystemProvider = jarFileSystemProvider;
        Path path = this.idePath.resolve("modules").resolve("module-descriptors.jar");
        Intrinsics.checkNotNullExpressionValue(path, "idePath.resolve(MODULES_\u2026e(MODULE_DESCRIPTORS_JAR)");
        this.moduleDescriptorsJarPath = path;
        if (!FileUtilKt.exists(this.moduleDescriptorsJarPath)) {
            throw (Throwable)new InvalidIdeException("IDE path [" + this.idePath + "] does not contain 'modules/module-descriptors.jar' file");
        }
    }

    public /* synthetic */ BundledModulesResolver(Path path, JarFileSystemProvider jarFileSystemProvider, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            jarFileSystemProvider = new DefaultJarFileSystemProvider();
        }
        this(path, jarFileSystemProvider);
    }

    public static final /* synthetic */ ModuleBean access$unmarshallModule(BundledModulesResolver $this, Path xmlPath) {
        return $this.unmarshallModule(xmlPath);
    }
}

