/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier;

import com.jetbrains.plugin.structure.base.telemetry.PluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import com.jetbrains.pluginverifier.dymamic.DynamicPluginStatus;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecatedApiUsage;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalApiUsage;
import com.jetbrains.pluginverifier.usages.internal.InternalApiUsage;
import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableApiUsage;
import com.jetbrains.pluginverifier.usages.overrideOnly.OverrideOnlyMethodUsage;
import com.jetbrains.pluginverifier.warnings.CompatibilityWarning;
import com.jetbrains.pluginverifier.warnings.PluginStructureError;
import com.jetbrains.pluginverifier.warnings.PluginStructureWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0004\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "", "plugin", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "(Lcom/jetbrains/pluginverifier/repository/PluginInfo;Lcom/jetbrains/pluginverifier/PluginVerificationTarget;)V", "getPlugin", "()Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "getVerificationTarget", "()Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "verificationVerdict", "", "getVerificationVerdict", "()Ljava/lang/String;", "toString", "FailedToDownload", "InvalidPlugin", "NotFound", "Verified", "Lcom/jetbrains/pluginverifier/PluginVerificationResult$FailedToDownload;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult$InvalidPlugin;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult$NotFound;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult$Verified;", "verifier-intellij"})
public abstract class PluginVerificationResult {
    @NotNull
    private final PluginInfo plugin;
    @NotNull
    private final PluginVerificationTarget verificationTarget;

    private PluginVerificationResult(PluginInfo plugin, PluginVerificationTarget verificationTarget) {
        this.plugin = plugin;
        this.verificationTarget = verificationTarget;
    }

    @NotNull
    public final PluginInfo getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final PluginVerificationTarget getVerificationTarget() {
        return this.verificationTarget;
    }

    @NotNull
    public abstract String getVerificationVerdict();

    @NotNull
    public final String toString() {
        return this.getVerificationVerdict();
    }

    public /* synthetic */ PluginVerificationResult(PluginInfo plugin, PluginVerificationTarget verificationTarget, DefaultConstructorMarker $constructor_marker) {
        this(plugin, verificationTarget);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/jetbrains/pluginverifier/PluginVerificationResult$FailedToDownload;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "plugin", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "failedToDownloadReason", "", "(Lcom/jetbrains/pluginverifier/repository/PluginInfo;Lcom/jetbrains/pluginverifier/PluginVerificationTarget;Ljava/lang/String;)V", "getFailedToDownloadReason", "()Ljava/lang/String;", "verificationVerdict", "getVerificationVerdict", "verifier-intellij"})
    public static final class FailedToDownload
    extends PluginVerificationResult {
        @NotNull
        private final String failedToDownloadReason;

        public FailedToDownload(@NotNull PluginInfo plugin, @NotNull PluginVerificationTarget verificationTarget, @NotNull String failedToDownloadReason) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
            Intrinsics.checkNotNullParameter(failedToDownloadReason, "failedToDownloadReason");
            super(plugin, verificationTarget, null);
            this.failedToDownloadReason = failedToDownloadReason;
        }

        @NotNull
        public final String getFailedToDownloadReason() {
            return this.failedToDownloadReason;
        }

        @Override
        @NotNull
        public String getVerificationVerdict() {
            return "Failed to download plugin: " + this.failedToDownloadReason;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/pluginverifier/PluginVerificationResult$InvalidPlugin;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "plugin", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "pluginStructureErrors", "", "Lcom/jetbrains/pluginverifier/warnings/PluginStructureError;", "(Lcom/jetbrains/pluginverifier/repository/PluginInfo;Lcom/jetbrains/pluginverifier/PluginVerificationTarget;Ljava/util/Set;)V", "getPluginStructureErrors", "()Ljava/util/Set;", "verificationVerdict", "", "getVerificationVerdict", "()Ljava/lang/String;", "verifier-intellij"})
    public static final class InvalidPlugin
    extends PluginVerificationResult {
        @NotNull
        private final Set<PluginStructureError> pluginStructureErrors;

        public InvalidPlugin(@NotNull PluginInfo plugin, @NotNull PluginVerificationTarget verificationTarget, @NotNull Set<PluginStructureError> pluginStructureErrors) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
            Intrinsics.checkNotNullParameter(pluginStructureErrors, "pluginStructureErrors");
            super(plugin, verificationTarget, null);
            this.pluginStructureErrors = pluginStructureErrors;
        }

        @NotNull
        public final Set<PluginStructureError> getPluginStructureErrors() {
            return this.pluginStructureErrors;
        }

        @Override
        @NotNull
        public String getVerificationVerdict() {
            return "Plugin is invalid: " + CollectionsKt.joinToString$default(this.pluginStructureErrors, null, null, null, 0, null, verificationVerdict.1.INSTANCE, 31, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/jetbrains/pluginverifier/PluginVerificationResult$NotFound;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "plugin", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "notFoundReason", "", "(Lcom/jetbrains/pluginverifier/repository/PluginInfo;Lcom/jetbrains/pluginverifier/PluginVerificationTarget;Ljava/lang/String;)V", "getNotFoundReason", "()Ljava/lang/String;", "verificationVerdict", "getVerificationVerdict", "verifier-intellij"})
    public static final class NotFound
    extends PluginVerificationResult {
        @NotNull
        private final String notFoundReason;

        public NotFound(@NotNull PluginInfo plugin, @NotNull PluginVerificationTarget verificationTarget, @NotNull String notFoundReason) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
            Intrinsics.checkNotNullParameter(notFoundReason, "notFoundReason");
            super(plugin, verificationTarget, null);
            this.notFoundReason = notFoundReason;
        }

        @NotNull
        public final String getNotFoundReason() {
            return this.notFoundReason;
        }

        @Override
        @NotNull
        public String getVerificationVerdict() {
            return "Plugin is not found: " + this.notFoundReason;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u00df\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u0012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t\u0012\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\f\u0012\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t\u0012\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\t\u0012\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\t\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u0012\b\b\u0002\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010#R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b5\u00103R\u0011\u00106\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b7\u00103R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00109R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010#R\u0011\u0010<\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b<\u00103R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010#R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010#R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010#R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u00a8\u0006E"}, d2={"Lcom/jetbrains/pluginverifier/PluginVerificationResult$Verified;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "plugin", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "dependenciesGraph", "Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;", "compatibilityProblems", "", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "ignoredProblems", "", "", "compatibilityWarnings", "Lcom/jetbrains/pluginverifier/warnings/CompatibilityWarning;", "deprecatedUsages", "Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecatedApiUsage;", "experimentalApiUsages", "Lcom/jetbrains/pluginverifier/usages/experimental/ExperimentalApiUsage;", "internalApiUsages", "Lcom/jetbrains/pluginverifier/usages/internal/InternalApiUsage;", "ignoredInternalApiUsages", "nonExtendableApiUsages", "Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableApiUsage;", "overrideOnlyMethodUsages", "Lcom/jetbrains/pluginverifier/usages/overrideOnly/OverrideOnlyMethodUsage;", "pluginStructureWarnings", "Lcom/jetbrains/pluginverifier/warnings/PluginStructureWarning;", "dynamicPluginStatus", "Lcom/jetbrains/pluginverifier/dymamic/DynamicPluginStatus;", "telemetry", "Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;", "(Lcom/jetbrains/pluginverifier/repository/PluginInfo;Lcom/jetbrains/pluginverifier/PluginVerificationTarget;Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;Ljava/util/Set;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Lcom/jetbrains/pluginverifier/dymamic/DynamicPluginStatus;Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;)V", "getCompatibilityProblems", "()Ljava/util/Set;", "getCompatibilityWarnings", "getDependenciesGraph", "()Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;", "getDeprecatedUsages", "directMissingMandatoryDependencies", "", "Lcom/jetbrains/pluginverifier/dependencies/MissingDependency;", "getDirectMissingMandatoryDependencies", "()Ljava/util/List;", "getDynamicPluginStatus", "()Lcom/jetbrains/pluginverifier/dymamic/DynamicPluginStatus;", "getExperimentalApiUsages", "hasCompatibilityProblems", "", "getHasCompatibilityProblems", "()Z", "hasCompatibilityWarnings", "getHasCompatibilityWarnings", "hasDirectMissingMandatoryDependencies", "getHasDirectMissingMandatoryDependencies", "getIgnoredInternalApiUsages", "()Ljava/util/Map;", "getIgnoredProblems", "getInternalApiUsages", "isOk", "getNonExtendableApiUsages", "getOverrideOnlyMethodUsages", "getPluginStructureWarnings", "getTelemetry", "()Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;", "verificationVerdict", "getVerificationVerdict", "()Ljava/lang/String;", "verifier-intellij"})
    @SourceDebugExtension(value={"SMAP\nPluginVerificationResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginVerificationResult.kt\ncom/jetbrains/pluginverifier/PluginVerificationResult$Verified\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n819#2:165\n847#2,2:166\n1726#2,3:168\n1774#2,4:171\n*S KotlinDebug\n*F\n+ 1 PluginVerificationResult.kt\ncom/jetbrains/pluginverifier/PluginVerificationResult$Verified\n*L\n64#1:165\n64#1:166,2\n86#1:168,3\n102#1:171,4\n*E\n"})
    public static final class Verified
    extends PluginVerificationResult {
        @NotNull
        private final DependenciesGraph dependenciesGraph;
        @NotNull
        private final Set<CompatibilityProblem> compatibilityProblems;
        @NotNull
        private final Map<CompatibilityProblem, String> ignoredProblems;
        @NotNull
        private final Set<CompatibilityWarning> compatibilityWarnings;
        @NotNull
        private final Set<DeprecatedApiUsage> deprecatedUsages;
        @NotNull
        private final Set<ExperimentalApiUsage> experimentalApiUsages;
        @NotNull
        private final Set<InternalApiUsage> internalApiUsages;
        @NotNull
        private final Map<InternalApiUsage, String> ignoredInternalApiUsages;
        @NotNull
        private final Set<NonExtendableApiUsage> nonExtendableApiUsages;
        @NotNull
        private final Set<OverrideOnlyMethodUsage> overrideOnlyMethodUsages;
        @NotNull
        private final Set<PluginStructureWarning> pluginStructureWarnings;
        @Nullable
        private final DynamicPluginStatus dynamicPluginStatus;
        @NotNull
        private final PluginTelemetry telemetry;

        public Verified(@NotNull PluginInfo plugin, @NotNull PluginVerificationTarget verificationTarget, @NotNull DependenciesGraph dependenciesGraph, @NotNull Set<? extends CompatibilityProblem> compatibilityProblems, @NotNull Map<CompatibilityProblem, String> ignoredProblems, @NotNull Set<? extends CompatibilityWarning> compatibilityWarnings, @NotNull Set<? extends DeprecatedApiUsage> deprecatedUsages, @NotNull Set<? extends ExperimentalApiUsage> experimentalApiUsages, @NotNull Set<? extends InternalApiUsage> internalApiUsages, @NotNull Map<InternalApiUsage, String> ignoredInternalApiUsages, @NotNull Set<? extends NonExtendableApiUsage> nonExtendableApiUsages, @NotNull Set<OverrideOnlyMethodUsage> overrideOnlyMethodUsages, @NotNull Set<PluginStructureWarning> pluginStructureWarnings, @Nullable DynamicPluginStatus dynamicPluginStatus, @NotNull PluginTelemetry telemetry) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
            Intrinsics.checkNotNullParameter(dependenciesGraph, "dependenciesGraph");
            Intrinsics.checkNotNullParameter(compatibilityProblems, "compatibilityProblems");
            Intrinsics.checkNotNullParameter(ignoredProblems, "ignoredProblems");
            Intrinsics.checkNotNullParameter(compatibilityWarnings, "compatibilityWarnings");
            Intrinsics.checkNotNullParameter(deprecatedUsages, "deprecatedUsages");
            Intrinsics.checkNotNullParameter(experimentalApiUsages, "experimentalApiUsages");
            Intrinsics.checkNotNullParameter(internalApiUsages, "internalApiUsages");
            Intrinsics.checkNotNullParameter(ignoredInternalApiUsages, "ignoredInternalApiUsages");
            Intrinsics.checkNotNullParameter(nonExtendableApiUsages, "nonExtendableApiUsages");
            Intrinsics.checkNotNullParameter(overrideOnlyMethodUsages, "overrideOnlyMethodUsages");
            Intrinsics.checkNotNullParameter(pluginStructureWarnings, "pluginStructureWarnings");
            Intrinsics.checkNotNullParameter(telemetry, "telemetry");
            super(plugin, verificationTarget, null);
            this.dependenciesGraph = dependenciesGraph;
            this.compatibilityProblems = compatibilityProblems;
            this.ignoredProblems = ignoredProblems;
            this.compatibilityWarnings = compatibilityWarnings;
            this.deprecatedUsages = deprecatedUsages;
            this.experimentalApiUsages = experimentalApiUsages;
            this.internalApiUsages = internalApiUsages;
            this.ignoredInternalApiUsages = ignoredInternalApiUsages;
            this.nonExtendableApiUsages = nonExtendableApiUsages;
            this.overrideOnlyMethodUsages = overrideOnlyMethodUsages;
            this.pluginStructureWarnings = pluginStructureWarnings;
            this.dynamicPluginStatus = dynamicPluginStatus;
            this.telemetry = telemetry;
        }

        public /* synthetic */ Verified(PluginInfo pluginInfo, PluginVerificationTarget pluginVerificationTarget, DependenciesGraph dependenciesGraph, Set set, Map map2, Set set2, Set set3, Set set4, Set set5, Map map3, Set set6, Set set7, Set set8, DynamicPluginStatus dynamicPluginStatus, PluginTelemetry pluginTelemetry, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 8) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 0x10) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 0x20) != 0) {
                set2 = SetsKt.emptySet();
            }
            if ((n & 0x40) != 0) {
                set3 = SetsKt.emptySet();
            }
            if ((n & 0x80) != 0) {
                set4 = SetsKt.emptySet();
            }
            if ((n & 0x100) != 0) {
                set5 = SetsKt.emptySet();
            }
            if ((n & 0x200) != 0) {
                map3 = MapsKt.emptyMap();
            }
            if ((n & 0x400) != 0) {
                set6 = SetsKt.emptySet();
            }
            if ((n & 0x800) != 0) {
                set7 = SetsKt.emptySet();
            }
            if ((n & 0x1000) != 0) {
                set8 = SetsKt.emptySet();
            }
            if ((n & 0x2000) != 0) {
                dynamicPluginStatus = null;
            }
            if ((n & 0x4000) != 0) {
                pluginTelemetry = new PluginTelemetry(new Pair[0]);
            }
            this(pluginInfo, pluginVerificationTarget, dependenciesGraph, set, map2, set2, set3, set4, set5, map3, set6, set7, set8, dynamicPluginStatus, pluginTelemetry);
        }

        @NotNull
        public final DependenciesGraph getDependenciesGraph() {
            return this.dependenciesGraph;
        }

        @NotNull
        public final Set<CompatibilityProblem> getCompatibilityProblems() {
            return this.compatibilityProblems;
        }

        @NotNull
        public final Map<CompatibilityProblem, String> getIgnoredProblems() {
            return this.ignoredProblems;
        }

        @NotNull
        public final Set<CompatibilityWarning> getCompatibilityWarnings() {
            return this.compatibilityWarnings;
        }

        @NotNull
        public final Set<DeprecatedApiUsage> getDeprecatedUsages() {
            return this.deprecatedUsages;
        }

        @NotNull
        public final Set<ExperimentalApiUsage> getExperimentalApiUsages() {
            return this.experimentalApiUsages;
        }

        @NotNull
        public final Set<InternalApiUsage> getInternalApiUsages() {
            return this.internalApiUsages;
        }

        @NotNull
        public final Map<InternalApiUsage, String> getIgnoredInternalApiUsages() {
            return this.ignoredInternalApiUsages;
        }

        @NotNull
        public final Set<NonExtendableApiUsage> getNonExtendableApiUsages() {
            return this.nonExtendableApiUsages;
        }

        @NotNull
        public final Set<OverrideOnlyMethodUsage> getOverrideOnlyMethodUsages() {
            return this.overrideOnlyMethodUsages;
        }

        @NotNull
        public final Set<PluginStructureWarning> getPluginStructureWarnings() {
            return this.pluginStructureWarnings;
        }

        @Nullable
        public final DynamicPluginStatus getDynamicPluginStatus() {
            return this.dynamicPluginStatus;
        }

        @NotNull
        public final PluginTelemetry getTelemetry() {
            return this.telemetry;
        }

        public final boolean getHasDirectMissingMandatoryDependencies() {
            return !((Collection)this.getDirectMissingMandatoryDependencies()).isEmpty();
        }

        public final boolean getHasCompatibilityProblems() {
            return !this.getHasDirectMissingMandatoryDependencies() && !((Collection)this.compatibilityProblems).isEmpty();
        }

        public final boolean getHasCompatibilityWarnings() {
            return !this.getHasDirectMissingMandatoryDependencies() && !this.getHasCompatibilityProblems() && !((Collection)this.compatibilityWarnings).isEmpty();
        }

        public final boolean isOk() {
            return !this.getHasDirectMissingMandatoryDependencies() && !this.getHasCompatibilityProblems() && !this.getHasCompatibilityWarnings();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<MissingDependency> getDirectMissingMandatoryDependencies() {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = this.dependenciesGraph.getDirectMissingDependencies();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                MissingDependency it = (MissingDependency)element$iv$iv;
                boolean bl = false;
                if (it.getDependency().isOptional()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public String getVerificationVerdict() {
            StringBuilder stringBuilder;
            StringBuilder $this$_get_verificationVerdict__u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.getDirectMissingMandatoryDependencies().isEmpty() && this.compatibilityProblems.isEmpty() && this.compatibilityWarnings.isEmpty()) {
                $this$_get_verificationVerdict__u24lambda_u243.append("Compatible");
            }
            if (!((Collection)this.getDirectMissingMandatoryDependencies()).isEmpty()) {
                $this$_get_verificationVerdict__u24lambda_u243.append(this.getDirectMissingMandatoryDependencies().size() + " missing mandatory ");
                $this$_get_verificationVerdict__u24lambda_u243.append(FormatUtilsKt.pluralize("dependency", this.getDirectMissingMandatoryDependencies().size()));
            }
            if (!((Collection)this.compatibilityProblems).isEmpty()) {
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(this.compatibilityProblems.size());
                if (!((Collection)this.getDirectMissingMandatoryDependencies()).isEmpty()) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(" possible");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(" compatibility ").append(FormatUtilsKt.pluralize("problem", this.compatibilityProblems.size()));
                Set<MissingDependency> allDirectMissingDependencies = this.dependenciesGraph.getDirectMissingDependencies();
                if (!((Collection)allDirectMissingDependencies).isEmpty()) {
                    boolean bl2;
                    block31: {
                        $this$_get_verificationVerdict__u24lambda_u243.append(", some of which may be caused by absence of ");
                        Iterable $this$all$iv = allDirectMissingDependencies;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                MissingDependency it = (MissingDependency)element$iv;
                                boolean bl3 = false;
                                if (it.getDependency().isOptional()) continue;
                                bl2 = false;
                                break block31;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        $this$_get_verificationVerdict__u24lambda_u243.append("optional ");
                    }
                    $this$_get_verificationVerdict__u24lambda_u243.append(FormatUtilsKt.pluralize("dependency", allDirectMissingDependencies.size()));
                    if (this.getVerificationTarget() instanceof PluginVerificationTarget.IDE) {
                        $this$_get_verificationVerdict__u24lambda_u243.append(" in the target IDE " + ((PluginVerificationTarget.IDE)this.getVerificationTarget()).getIdeVersion().asString());
                    }
                }
            }
            if (!((Collection)this.compatibilityWarnings).isEmpty()) {
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(this.compatibilityWarnings.size());
                $this$_get_verificationVerdict__u24lambda_u243.append(" compatibility ").append(FormatUtilsKt.pluralize("warning", this.compatibilityWarnings.size()));
            }
            if (!((Collection)this.deprecatedUsages).isEmpty()) {
                int n;
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                Iterable $this$count$iv = this.deprecatedUsages;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        DeprecatedApiUsage it = (DeprecatedApiUsage)element$iv;
                        boolean bl4 = false;
                        if (!it.getDeprecationInfo().getForRemoval() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int scheduledForRemovalNumber = n;
                int deprecatedUsagesNumber = this.deprecatedUsages.size() - scheduledForRemovalNumber;
                if (scheduledForRemovalNumber > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(scheduledForRemovalNumber + " ").append(FormatUtilsKt.pluralize("usage", scheduledForRemovalNumber)).append(" of scheduled for removal API");
                }
                if (deprecatedUsagesNumber > 0) {
                    if (scheduledForRemovalNumber > 0) {
                        $this$_get_verificationVerdict__u24lambda_u243.append(" and ");
                    }
                    $this$_get_verificationVerdict__u24lambda_u243.append(deprecatedUsagesNumber + " ").append(FormatUtilsKt.pluralize("usage", deprecatedUsagesNumber)).append(" of deprecated API");
                }
            }
            if (!((Collection)this.experimentalApiUsages).isEmpty()) {
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(this.experimentalApiUsages.size() + " ").append(FormatUtilsKt.pluralize("usage", this.experimentalApiUsages.size())).append(" of experimental API");
            }
            if (!((Collection)this.internalApiUsages).isEmpty()) {
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(this.internalApiUsages.size() + " ").append(FormatUtilsKt.pluralize("usage", this.internalApiUsages.size())).append(" of internal API");
            }
            if (!((Collection)this.nonExtendableApiUsages).isEmpty()) {
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(this.nonExtendableApiUsages.size() + " non-extendable API usage ").append(FormatUtilsKt.pluralize("violation", this.nonExtendableApiUsages.size()));
            }
            if (!((Collection)this.overrideOnlyMethodUsages).isEmpty()) {
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(this.overrideOnlyMethodUsages.size() + " override-only API usage ").append(FormatUtilsKt.pluralize("violation", this.overrideOnlyMethodUsages.size()));
            }
            if (!((Collection)this.pluginStructureWarnings).isEmpty()) {
                if (((CharSequence)$this$_get_verificationVerdict__u24lambda_u243).length() > 0) {
                    $this$_get_verificationVerdict__u24lambda_u243.append(". ");
                }
                $this$_get_verificationVerdict__u24lambda_u243.append(this.pluginStructureWarnings.size() + " plugin configuration ").append(FormatUtilsKt.pluralize("defect", this.pluginStructureWarnings.size()));
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            return string2;
        }
    }
}

