/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.analysis;

import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.ModuleDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalPluginDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginXmlUtil;
import com.jetbrains.pluginverifier.analysis.Location;
import com.jetbrains.pluginverifier.analysis.ReachabilityGraph;
import com.jetbrains.pluginverifier.analysis.TypeGraph;
import com.jetbrains.pluginverifier.analysis.TypeReferences;
import com.jetbrains.pluginverifier.analysis.TypeReferencesClassVisitor;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u000f*\u00060\u000fj\u0002`\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u0012*\u00020\u00122\n\u0010\u001b\u001a\u00060\u000fj\u0002`\u0019H\u0002\u001a \u0010\u001a\u001a\u00020\u0012*\u00020\u00122\n\u0010\u001b\u001a\u00060\u000fj\u0002`\u00192\u0006\u0010\u001c\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\f\b\u0002\u0010\u001d\"\u00020\u000f2\u00020\u000f*\f\b\u0002\u0010\u001e\"\u00020\u000f2\u00020\u000f\u00a8\u0006\u001f"}, d2={"logger", "Lorg/slf4j/Logger;", "buildClassReachabilityGraph", "Lcom/jetbrains/pluginverifier/analysis/ReachabilityGraph;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "dependenciesGraph", "Lcom/jetbrains/pluginverifier/dependencies/DependenciesGraph;", "buildTypeGraph", "Lcom/jetbrains/pluginverifier/analysis/TypeGraph;", "field", "Lcom/jetbrains/pluginverifier/analysis/Location;", "name", "", "addConstantDynamic", "", "Lcom/jetbrains/pluginverifier/analysis/TypeReferences;", "constantDynamic", "Lorg/objectweb/asm/ConstantDynamic;", "addHandle", "handle", "Lorg/objectweb/asm/Handle;", "toLogString", "Lcom/jetbrains/pluginverifier/analysis/Descriptor;", "withType", "descriptor", "location", "ClassName", "Descriptor", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nClassReachabilityAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassReachabilityAnalysis.kt\ncom/jetbrains/pluginverifier/analysis/ClassReachabilityAnalysisKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n766#2:388\n857#2,2:389\n766#2:392\n857#2:393\n1549#2:394\n1620#2,3:395\n858#2:398\n1549#2:399\n1620#2,3:400\n1855#2,2:403\n1#3:391\n*S KotlinDebug\n*F\n+ 1 ClassReachabilityAnalysis.kt\ncom/jetbrains/pluginverifier/analysis/ClassReachabilityAnalysisKt\n*L\n107#1:388\n107#1:389,2\n111#1:392\n111#1:393\n111#1:394\n111#1:395,3\n111#1:398\n112#1:399\n112#1:400,3\n113#1:403,2\n*E\n"})
public final class ClassReachabilityAnalysisKt {
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ReachabilityGraph buildClassReachabilityGraph(@NotNull IdePlugin idePlugin, @NotNull Resolver pluginResolver, @NotNull DependenciesGraph dependenciesGraph) {
        MissingDependency it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        Intrinsics.checkNotNullParameter(pluginResolver, "pluginResolver");
        Intrinsics.checkNotNullParameter(dependenciesGraph, "dependenciesGraph");
        TypeGraph typeGraph = ClassReachabilityAnalysisKt.buildTypeGraph(pluginResolver);
        ReachabilityGraph reachabilityGraph = new ReachabilityGraph(typeGraph);
        Set<String> set = PluginXmlUtil.getAllClassesReferencedFromXml(idePlugin);
        Intrinsics.checkNotNullExpressionValue(set, "getAllClassesReferencedFromXml(idePlugin)");
        Set<String> mainClasses = set;
        for (String className : mainClasses) {
            Intrinsics.checkNotNullExpressionValue(className, "className");
            reachabilityGraph.markClass(className, ReachabilityGraph.ReachabilityMark.MAIN_PLUGIN);
        }
        Iterable $this$filter$iv = dependenciesGraph.getDirectMissingDependencies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (MissingDependency)element$iv$iv;
            boolean bl = false;
            if (!it.getDependency().isOptional()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingOptionalDependencies = (List)destination$iv$iv;
        for (MissingDependency missingOptionalDependency : missingOptionalDependencies) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ModuleDescriptor it2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            MissingDependency missingDependency;
            Object element$iv$iv;
            block9: {
                Iterable iterable2 = idePlugin.getOptionalDescriptors();
                element$iv$iv = iterable2.iterator();
                while (element$iv$iv.hasNext()) {
                    it = element$iv$iv.next();
                    OptionalPluginDescriptor it3 = (OptionalPluginDescriptor)((Object)it);
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it3.getDependency(), missingOptionalDependency.getDependency())) continue;
                    missingDependency = it;
                    break block9;
                }
                missingDependency = null;
            }
            OptionalPluginDescriptor optionalPluginDescriptor = (OptionalPluginDescriptor)((Object)missingDependency);
            IdePlugin optionalPlugin = optionalPluginDescriptor != null ? optionalPluginDescriptor.getOptionalPlugin() : null;
            Iterable $i$f$filterTo2 = idePlugin.getModulesDescriptors();
            boolean $i$f$filter2 = false;
            element$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                void $this$mapTo$iv$iv2;
                it2 = (ModuleDescriptor)element$iv$iv2;
                boolean bl = false;
                Iterable $this$map$iv2 = it2.getDependencies();
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it4;
                    PluginDependency pluginDependency = (PluginDependency)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl2 = false;
                    collection.add(it4.getId());
                }
                if (!((List)destination$iv$iv3).contains(missingOptionalDependency.getDependency().getId())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it2.getModule());
            }
            List<IdePlugin> modules = (List<IdePlugin>)destination$iv$iv2;
            Iterable $this$forEach$iv = optionalPlugin != null ? CollectionsKt.plus((Collection)modules, optionalPlugin) : modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set<String> optionalClasses;
                IdePlugin it5 = (IdePlugin)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(PluginXmlUtil.getAllClassesReferencedFromXml(it5), "getAllClassesReferencedFromXml(it)");
                for (String className : optionalClasses) {
                    Intrinsics.checkNotNullExpressionValue(className, "className");
                    reachabilityGraph.markClass(className, ReachabilityGraph.ReachabilityMark.OPTIONAL_PLUGIN);
                }
            }
        }
        return reachabilityGraph;
    }

    private static final TypeGraph buildTypeGraph(Resolver pluginResolver) {
        TypeGraph graph = new TypeGraph();
        pluginResolver.processAllClasses((Function1<? super ResolutionResult<? extends ClassNode>, Boolean>)new Function1<ResolutionResult<? extends ClassNode>, Boolean>(pluginResolver, graph){
            final /* synthetic */ Resolver $pluginResolver;
            final /* synthetic */ TypeGraph $graph;
            {
                this.$pluginResolver = $pluginResolver;
                this.$graph = $graph;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ResolutionResult<? extends ClassNode> resolutionResult) {
                Intrinsics.checkNotNullParameter(resolutionResult, "resolutionResult");
                if (!(resolutionResult instanceof ResolutionResult.Found)) {
                    return true;
                }
                ClassNode classNode = (ClassNode)((ResolutionResult.Found)resolutionResult).getValue();
                TypeReferences references = new TypeReferences();
                classNode.accept(new TypeReferencesClassVisitor(references));
                HashSet<String> typeReferences = references.getTypeReferences();
                for (String typeReference : typeReferences) {
                    Intrinsics.checkNotNullExpressionValue(typeReference, "typeReference");
                    if (!this.$pluginResolver.containsClass(typeReference)) continue;
                    String string2 = classNode.name;
                    Intrinsics.checkNotNullExpressionValue(string2, "classNode.name");
                    this.$graph.addEdge(string2, typeReference);
                }
                return true;
            }
        });
        return graph;
    }

    private static final void addHandle(TypeReferences $this$addHandle, Handle handle) {
        Type type2 = Type.getObjectType(handle.getOwner());
        Intrinsics.checkNotNullExpressionValue(type2, "getObjectType(handle.owner)");
        $this$addHandle.addReferences(type2);
        Type handleType = Type.getType(handle.getDesc());
        Intrinsics.checkNotNullExpressionValue(handleType, "handleType");
        $this$addHandle.addReferences(handleType);
    }

    private static final void addConstantDynamic(TypeReferences $this$addConstantDynamic, ConstantDynamic constantDynamic) {
        Type type2 = Type.getType(constantDynamic.getDescriptor());
        Intrinsics.checkNotNullExpressionValue(type2, "getType(constantDynamic.descriptor)");
        $this$addConstantDynamic.addReferences(type2);
        Handle handle = constantDynamic.getBootstrapMethod();
        Intrinsics.checkNotNullExpressionValue(handle, "constantDynamic.bootstrapMethod");
        ClassReachabilityAnalysisKt.addHandle($this$addConstantDynamic, handle);
    }

    private static final TypeReferences withType(TypeReferences $this$withType, String descriptor2) {
        TypeReferences $this$withType_u24lambda_u246 = $this$withType;
        boolean bl = false;
        return ClassReachabilityAnalysisKt.withType($this$withType_u24lambda_u246, descriptor2, Location.Unknown.INSTANCE);
    }

    private static final TypeReferences withType(TypeReferences $this$withType, String descriptor2, Location location) {
        TypeReferences typeReferences;
        TypeReferences $this$withType_u24lambda_u247 = typeReferences = $this$withType;
        boolean bl = false;
        try {
            Type type2 = Type.getType(descriptor2);
            Intrinsics.checkNotNullExpressionValue(type2, "getType(descriptor)");
            Type type3 = type2;
            $this$withType_u24lambda_u247.addReferences(type3);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Skipping invalid descriptor at {} {}", (Object)location, (Object)ClassReachabilityAnalysisKt.toLogString(descriptor2));
        }
        return typeReferences;
    }

    private static final String toLogString(String $this$toLogString) {
        String trimmedDesc = ((Object)StringsKt.trim((CharSequence)$this$toLogString)).toString();
        int len = $this$toLogString.length() - trimmedDesc.length();
        return len > 0 ? "[" + trimmedDesc + "] (" + len + " whitespace characters trimmed)" : "[" + trimmedDesc + "]";
    }

    private static final Location field(String name) {
        Location location;
        String string2 = name;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            location = new Location.Field(it);
        } else {
            location = Location.Unknown.INSTANCE;
        }
        return location;
    }

    public static final /* synthetic */ TypeReferences access$withType(TypeReferences $receiver, String descriptor2, Location location) {
        return ClassReachabilityAnalysisKt.withType($receiver, descriptor2, location);
    }

    public static final /* synthetic */ Location access$field(String name) {
        return ClassReachabilityAnalysisKt.field(name);
    }

    public static final /* synthetic */ void access$addHandle(TypeReferences $receiver, Handle handle) {
        ClassReachabilityAnalysisKt.addHandle($receiver, handle);
    }

    public static final /* synthetic */ void access$addConstantDynamic(TypeReferences $receiver, ConstantDynamic constantDynamic) {
        ClassReachabilityAnalysisKt.addConstantDynamic($receiver, constantDynamic);
    }

    public static final /* synthetic */ TypeReferences access$withType(TypeReferences $receiver, String descriptor2) {
        return ClassReachabilityAnalysisKt.withType($receiver, descriptor2);
    }

    static {
        Logger logger = LoggerFactory.getLogger("com.jetbrains.pluginverifier.analysis.ClassReachabilityAnalysis");
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(\"com.jetbrains\u2026assReachabilityAnalysis\")");
        ClassReachabilityAnalysisKt.logger = logger;
    }
}

