/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.filtering;

import com.jetbrains.pluginverifier.filtering.KeepOnlyCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/filtering/KeepOnlyCondition;", "", "pluginId", "Lkotlin/text/Regex;", "version", "pattern", "(Lkotlin/text/Regex;Lkotlin/text/Regex;Lkotlin/text/Regex;)V", "getPattern", "()Lkotlin/text/Regex;", "getPluginId", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "serializeCondition", "", "toString", "Companion", "verifier-intellij"})
public final class KeepOnlyCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Regex pluginId;
    @Nullable
    private final Regex version;
    @NotNull
    private final Regex pattern;
    @NotNull
    private static final String USAGE = "  Keep only problem line must be in the form: [<plugin_xml_id_regexp_pattern>[:<plugin_version_regexp_pattern>]:]<problem_description_regexp_pattern>\nExamples:\norg.some.*:3.*:access to unresolved class org.foo.Foo.*                           --- keep problems for plugins 'org.some.plugin', 'org.some.other.plugin' of versions 3+\norg.jetbrains.kotlin::access to unresolved class org.jetbrains.kotlin.compiler.*  --- keep problems for all versions of Kotlin plugin\naccess to unresolved class org.jetbrains.kotlin.compiler.*                        --- keep problems for all plugins, but ignore others";

    public KeepOnlyCondition(@Nullable Regex pluginId, @Nullable Regex version, @NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.pluginId = pluginId;
        this.version = version;
        this.pattern = pattern;
    }

    @Nullable
    public final Regex getPluginId() {
        return this.pluginId;
    }

    @Nullable
    public final Regex getVersion() {
        return this.version;
    }

    @NotNull
    public final Regex getPattern() {
        return this.pattern;
    }

    @NotNull
    public final String serializeCondition() {
        StringBuilder stringBuilder;
        StringBuilder $this$serializeCondition_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.pluginId != null) {
            $this$serializeCondition_u24lambda_u240.append(this.pluginId.getPattern()).append(":");
        }
        if (this.version != null) {
            $this$serializeCondition_u24lambda_u240.append(this.version.getPattern()).append(":");
        }
        $this$serializeCondition_u24lambda_u240.append(this.pattern.getPattern());
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof KeepOnlyCondition)) return false;
        Regex regex = this.pluginId;
        Regex regex2 = ((KeepOnlyCondition)other).pluginId;
        if (!Intrinsics.areEqual(regex != null ? regex.getPattern() : null, regex2 != null ? regex2.getPattern() : null)) return false;
        Regex regex3 = this.version;
        Regex regex4 = ((KeepOnlyCondition)other).version;
        if (!Intrinsics.areEqual(regex3 != null ? regex3.getPattern() : null, regex4 != null ? regex4.getPattern() : null)) return false;
        if (!Intrinsics.areEqual(this.pattern.getPattern(), ((KeepOnlyCondition)other).pattern.getPattern())) return false;
        return true;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.pluginId, this.version, this.pattern.getPattern()};
        return Objects.hash(objectArray);
    }

    @Nullable
    public final Regex component1() {
        return this.pluginId;
    }

    @Nullable
    public final Regex component2() {
        return this.version;
    }

    @NotNull
    public final Regex component3() {
        return this.pattern;
    }

    @NotNull
    public final KeepOnlyCondition copy(@Nullable Regex pluginId, @Nullable Regex version, @NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return new KeepOnlyCondition(pluginId, version, pattern);
    }

    public static /* synthetic */ KeepOnlyCondition copy$default(KeepOnlyCondition keepOnlyCondition, Regex regex, Regex regex2, Regex regex3, int n, Object object) {
        if ((n & 1) != 0) {
            regex = keepOnlyCondition.pluginId;
        }
        if ((n & 2) != 0) {
            regex2 = keepOnlyCondition.version;
        }
        if ((n & 4) != 0) {
            regex3 = keepOnlyCondition.pattern;
        }
        return keepOnlyCondition.copy(regex, regex2, regex3);
    }

    @NotNull
    public String toString() {
        return "KeepOnlyCondition(pluginId=" + this.pluginId + ", version=" + this.version + ", pattern=" + this.pattern + ")";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/pluginverifier/filtering/KeepOnlyCondition$Companion;", "", "()V", "USAGE", "", "parseCondition", "Lcom/jetbrains/pluginverifier/filtering/KeepOnlyCondition;", "line", "verifier-intellij"})
    @SourceDebugExtension(value={"SMAP\nKeepOnlyCondition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeepOnlyCondition.kt\ncom/jetbrains/pluginverifier/filtering/KeepOnlyCondition$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n1#3:76\n*S KotlinDebug\n*F\n+ 1 KeepOnlyCondition.kt\ncom/jetbrains/pluginverifier/filtering/KeepOnlyCondition$Companion\n*L\n36#1:72\n36#1:73,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KeepOnlyCondition parseCondition(@NotNull String line) {
            KeepOnlyCondition keepOnlyCondition;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(line, "line");
            String[] stringArray = new String[]{":"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            List tokens = (List)destination$iv$iv;
            Function1 parseRegexp2 = parseCondition.parseRegexp.1.INSTANCE;
            Function1 parseRegexpOrNull2 = new Function1<String, Regex>((Function1<? super String, Regex>)parseRegexp2){
                final /* synthetic */ Function1<String, Regex> $parseRegexp;
                {
                    this.$parseRegexp = $parseRegexp;
                    super(1);
                }

                @Nullable
                public final Regex invoke(@Nullable String s2) {
                    Regex regex;
                    String string2 = s2;
                    if (string2 != null) {
                        String string3 = string2;
                        Function1<String, Regex> function1 = this.$parseRegexp;
                        String it = string3;
                        boolean bl = false;
                        regex = function1.invoke(it);
                    } else {
                        regex = null;
                    }
                    return regex;
                }
            };
            switch (tokens.size()) {
                case 1: {
                    keepOnlyCondition = new KeepOnlyCondition(null, null, (Regex)parseRegexp2.invoke(tokens.get(0)));
                    break;
                }
                case 2: {
                    keepOnlyCondition = new KeepOnlyCondition((Regex)parseRegexp2.invoke(tokens.get(0)), null, (Regex)parseRegexp2.invoke(tokens.get(1)));
                    break;
                }
                case 3: {
                    String it;
                    Object e = tokens.get(0);
                    String $i$f$mapTo2 = (String)e;
                    Object object = parseRegexpOrNull2;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    Object object2 = bl2 ? e : null;
                    e = tokens.get(1);
                    it = (String)e;
                    Function1 function1 = parseRegexpOrNull2;
                    object = (Regex)object.invoke(object2);
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)it).length() > 0;
                    Object object3 = bl4 ? e : null;
                    Regex regex = (Regex)parseRegexp2.invoke(tokens.get(2));
                    Regex regex2 = (Regex)function1.invoke(object3);
                    Object object4 = object;
                    keepOnlyCondition = new KeepOnlyCondition((Regex)object4, regex2, regex);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect keep only problem line\n" + line + "\n" + USAGE);
                }
            }
            return keepOnlyCondition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

