/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.filtering.documented;

import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblem;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemsParseException;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemsParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsParser;", "", "ignoreNonParsed", "", "(Z)V", "createParseException", "Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsParseException;", "description", "", "unwrappedDescription", "parse", "", "Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblem;", "pageBody", "parseLines", "parseUnwrappedDescription", "Companion", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDocumentedProblemsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentedProblemsParser.kt\ncom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1549#2:201\n1620#2,3:202\n*S KotlinDebug\n*F\n+ 1 DocumentedProblemsParser.kt\ncom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsParser\n*L\n132#1:201\n132#1:202,3\n*E\n"})
public final class DocumentedProblemsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean ignoreNonParsed;
    @NotNull
    private static final String METHOD_PARAMS = "\\([^\\)]*\\)";
    @NotNull
    private static final String IDENTIFIER = "[\\w.$]+";
    @NotNull
    private static final String S = "[.|#]";
    @NotNull
    private static final List<Pair<Regex, Function1<List<String>, DocumentedProblem>>> pattern2Parser;

    public DocumentedProblemsParser(boolean ignoreNonParsed) {
        this.ignoreNonParsed = ignoreNonParsed;
    }

    @NotNull
    public final List<DocumentedProblem> parse(@NotNull String pageBody) {
        Intrinsics.checkNotNullParameter(pageBody, "pageBody");
        List<String> lines = this.parseLines(pageBody);
        ArrayList documentedProblems = new ArrayList();
        int n = lines.size();
        for (int index = 0; index < n; ++index) {
            DocumentedProblem documentedProblem;
            String description2;
            if (!StringsKt.startsWith$default(lines.get(index), ": ", false, 2, null) || index <= 0 || !Companion.startsWithMarkdown(description2 = ((Object)StringsKt.trim((CharSequence)lines.get(index - 1))).toString())) continue;
            String unwrappedDescription = Companion.unwrapMarkdownTags(description2);
            if (this.parseUnwrappedDescription(unwrappedDescription) == null) {
                if (this.ignoreNonParsed) continue;
                throw this.createParseException(description2, unwrappedDescription);
            }
            ((Collection)documentedProblems).add(documentedProblem);
        }
        return documentedProblems;
    }

    /*
     * WARNING - void declaration
     */
    private final DocumentedProblemsParseException createParseException(String description2, String unwrappedDescription) {
        void $this$mapTo$iv$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$createParseException_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$createParseException_u24lambda_u241.append("Unable to parse documented problem description");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append(...)");
        StringBuilder stringBuilder3 = $this$createParseException_u24lambda_u241.append("Description: \"" + description2 + "\"");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append(...)");
        StringBuilder stringBuilder4 = $this$createParseException_u24lambda_u241.append("Description (no Markdown): \"" + unwrappedDescription + "\"");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append(...)");
        StringBuilder stringBuilder5 = $this$createParseException_u24lambda_u241.append("Only the following patterns are supported: ");
        Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append(...)");
        StringBuilder stringBuilder6 = $this$createParseException_u24lambda_u241.append("Where <method-params>='\\([^\\)]*\\)' and <identifier>='[\\w.$]+':");
        Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append(...)");
        Iterable $this$map$iv = pattern2Parser;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add((Regex)it.getFirst());
        }
        for (Regex regex : (List)destination$iv$iv) {
            StringBuilder stringBuilder7 = $this$createParseException_u24lambda_u241.append(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(regex.getPattern(), METHOD_PARAMS, "<method-params>", false, 4, null), IDENTIFIER, "<identifier>", false, 4, null), S, ".", false, 4, null));
            Intrinsics.checkNotNullExpressionValue(stringBuilder7, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder7.append('\n'), "append(...)");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String string3 = string2;
        return new DocumentedProblemsParseException(string3);
    }

    private final List<String> parseLines(String pageBody) {
        ArrayList lines = new ArrayList();
        boolean insideTitle = false;
        boolean insideComment = false;
        Iterator<String> iterator2 = StringsKt.lineSequence(pageBody).iterator();
        while (iterator2.hasNext()) {
            String line = iterator2.next();
            if (StringsKt.startsWith$default(line, "#", false, 2, null)) continue;
            if (StringsKt.startsWith$default(line, "---", false, 2, null)) {
                insideTitle = !insideTitle;
                continue;
            }
            if (insideTitle) continue;
            if (StringsKt.startsWith$default(line, "<!--", false, 2, null)) {
                insideComment = true;
                continue;
            }
            if (StringsKt.startsWith$default(line, "-->", false, 2, null)) {
                insideComment = false;
                continue;
            }
            if (insideComment) continue;
            ((Collection)lines).add(line);
        }
        return lines;
    }

    private final DocumentedProblem parseUnwrappedDescription(String unwrappedDescription) {
        for (Pair<Regex, Function1<List<String>, DocumentedProblem>> pair : pattern2Parser) {
            Regex pattern = pair.component1();
            Function1<List<String>, DocumentedProblem> parser = pair.component2();
            MatchResult matchResult = pattern.matchEntire(unwrappedDescription);
            if (matchResult == null) continue;
            List values2 = CollectionsKt.drop((Iterable)matchResult.getGroupValues(), 1);
            return parser.invoke(values2);
        }
        return null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(new Regex("([\\w.$]+).*(?:class|interface|annotation|enum) removed"), Companion.pattern2Parser.1.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+).*(?:class|interface|annotation|enum) renamed.*"), Companion.pattern2Parser.2.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+)(\\([^\\)]*\\))? method removed"), Companion.pattern2Parser.3.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+)(\\([^\\)]*\\))? method moved.*"), Companion.pattern2Parser.4.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)(\\([^\\)]*\\))? constructor removed"), Companion.pattern2Parser.5.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+)(\\([^\\)]*\\))? method return type changed.*"), Companion.pattern2Parser.6.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+)(\\([^\\)]*\\))? method parameter.*(type changed|removed).*"), Companion.pattern2Parser.7.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)(\\([^\\)]*\\))? constructor parameter.*(type changed|removed).*"), Companion.pattern2Parser.8.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+)(\\([^\\)]*\\))? method visibility changed.*"), Companion.pattern2Parser.9.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+)(\\([^\\)]*\\))? method marked final.*"), Companion.pattern2Parser.10.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+).*(?:class|interface) now (?:extends|implements) ([\\w.$]+) and inherits its final method ([\\w.$]+)(\\([^\\)]*\\))?.*"), Companion.pattern2Parser.11.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+).*(?:class|interface) now (?:extends|implements) ([\\w.$]+) and inherits its abstract method ([\\w.$]+)(\\([^\\)]*\\))?.*"), Companion.pattern2Parser.12.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+) class now interface"), Companion.pattern2Parser.13.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)(\\([^\\)]*\\))? constructor visibility changed.*"), Companion.pattern2Parser.14.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+) field removed"), Companion.pattern2Parser.15.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+) field moved.*"), Companion.pattern2Parser.16.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+) field type changed.*"), Companion.pattern2Parser.17.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+) field visibility changed.*"), Companion.pattern2Parser.18.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+) package removed"), Companion.pattern2Parser.19.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+)(\\([^\\)]*\\))? (abstract method added|marked abstract)"), Companion.pattern2Parser.20.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+).*(?:class|interface|annotation|enum) moved to package ([\\w.$]+)"), Companion.pattern2Parser.21.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)[.|#]([\\w.$]+) method ([\\w.$]+) parameter marked @([\\w.$]+)"), Companion.pattern2Parser.22.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+)(.*)type parameter ([\\w.$]+) added"), Companion.pattern2Parser.23.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+).*(?:superclass|superinterface) changed from ([\\w.$]+) to ([\\w.$]+)"), Companion.pattern2Parser.24.INSTANCE), TuplesKt.to(new Regex("([\\w.$]+) property removed from resource bundle ([\\w.$]+)"), Companion.pattern2Parser.25.INSTANCE)};
        pattern2Parser = CollectionsKt.listOf(pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R8\u0010\u0007\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b\u0012\u0004\u0012\u00020\f0\u000b0\t0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsParser$Companion;", "", "()V", "IDENTIFIER", "", "METHOD_PARAMS", "S", "pattern2Parser", "", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "Lkotlin/Function1;", "Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblem;", "getPattern2Parser$annotations", "startsWithMarkdown", "", "text", "toInternalName", "dotClassName", "unwrapMarkdownTags", "verifier-intellij"})
    @SourceDebugExtension(value={"SMAP\nDocumentedProblemsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentedProblemsParser.kt\ncom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsParser$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1726#2,3:201\n959#2,7:205\n748#2,10:212\n1#3:204\n*S KotlinDebug\n*F\n+ 1 DocumentedProblemsParser.kt\ncom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsParser$Companion\n*L\n62#1:201,3\n63#1:205,7\n64#1:212,10\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getPattern2Parser$annotations() {
        }

        @NotNull
        public final String toInternalName(@NotNull String dotClassName) {
            boolean bl;
            List parts;
            block9: {
                Intrinsics.checkNotNullParameter(dotClassName, "dotClassName");
                String[] stringArray = new String[]{"."};
                parts = StringsKt.split$default((CharSequence)dotClassName, stringArray, false, 0, 6, null);
                Iterable $this$all$iv = parts;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (((CharSequence)it).length() > 0) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean $i$a$-require-DocumentedProblemsParser$Companion$toInternalName$32 = false;
                String $i$a$-require-DocumentedProblemsParser$Companion$toInternalName$32 = "Has empty parts: " + dotClassName;
                throw new IllegalArgumentException($i$a$-require-DocumentedProblemsParser$Companion$toInternalName$32.toString());
            }
            Iterable $this$takeWhile$iv = parts;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                String it = (String)item$iv;
                boolean bl3 = false;
                if (!Character.isLowerCase(StringsKt.first(it))) break;
                list$iv.add(item$iv);
            }
            String packageName = CollectionsKt.joinToString$default(list$iv, "/", null, null, 0, null, null, 62, null);
            Iterable $this$dropWhile$iv = parts;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv2 = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv2.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl4 = false;
                if (Character.isLowerCase(StringsKt.first(it))) continue;
                list$iv2.add(item$iv);
                yielding$iv = true;
            }
            String className = CollectionsKt.joinToString$default(list$iv2, "$", null, null, 0, null, null, 62, null);
            if (((CharSequence)packageName).length() == 0) {
                return className;
            }
            if (((CharSequence)className).length() == 0) {
                return packageName;
            }
            return packageName + "/" + className;
        }

        @NotNull
        public final String unwrapMarkdownTags(@NotNull String text) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter(text, "text");
            Regex markdownLinksRegex = new Regex("\\[(.*)]\\(.*\\)");
            String result2 = text;
            while (markdownLinksRegex.containsMatchIn(result2)) {
                CharSequence charSequence2 = result2;
                charSequence = "$1";
                result2 = markdownLinksRegex.replace(charSequence2, (String)charSequence);
            }
            Regex codeQuotesRegex = new Regex("`(.*)`");
            while (codeQuotesRegex.containsMatchIn(result2)) {
                charSequence = result2;
                String string2 = "$1";
                result2 = codeQuotesRegex.replace(charSequence, string2);
            }
            return result2;
        }

        public final boolean startsWithMarkdown(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            return StringsKt.startsWith$default(text, "`", false, 2, null) || StringsKt.startsWith$default(text, "[`", false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

