/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.jdk;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.InvalidClassFileException;
import com.jetbrains.plugin.structure.classes.resolvers.JdkFileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.PackageSet;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.utils.AsmUtil;
import com.jetbrains.pluginverifier.jdk.JdkJImageResolver;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0003H\u0002J\"\u0010*\u001a\u00020!2\u0018\u0010+\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-\u0012\u0004\u0012\u00020!0,H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0018\u00100\u001a\u00020.2\u0006\u0010\"\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0003H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u000207H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00069"}, d2={"Lcom/jetbrains/pluginverifier/jdk/JdkJImageResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "jdkPath", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClasses", "", "", "getAllClasses", "()Ljava/util/Set;", "allPackages", "getAllPackages", "classNameToModuleName", "", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "fileSystem", "Ljava/nio/file/FileSystem;", "modulesPath", "nameSeparator", "packageSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/PackageSet;", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "getClassName", "classPath", "getJrtFileSystem", "javaHome", "getModuleName", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "readClass", "readClassNode", "classFilePath", "resolveClass", "resolveExactPropertyResourceBundle", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult$NotFound;", "baseName", "locale", "Ljava/util/Locale;", "Companion", "verifier-intellij"})
public final class JdkJImageResolver
extends Resolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final FileOrigin fileOrigin;
    @NotNull
    private final Map<String, String> classNameToModuleName;
    @NotNull
    private final PackageSet packageSet;
    @NotNull
    private final String nameSeparator;
    @NotNull
    private final Path modulesPath;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private static final URI JRT_SCHEME_URI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public JdkJImageResolver(@NotNull Path jdkPath, @NotNull Resolver.ReadMode readMode) {
        Map<String, String> map2;
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter(jdkPath, "jdkPath");
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        this.readMode = readMode;
        this.fileOrigin = new JdkFileOrigin(jdkPath);
        this.packageSet = new PackageSet();
        JdkJImageResolver jdkJImageResolver = this;
        try {
            JdkJImageResolver jdkJImageResolver2 = jdkJImageResolver;
            fileSystem = this.getJrtFileSystem(jdkPath);
        }
        catch (Exception exception) {
            void e;
            JdkJImageResolver jdkJImageResolver3 = jdkJImageResolver;
            throw new RuntimeException("Unable to read content from jrt:/ file system.", (Throwable)e);
        }
        jdkJImageResolver2.fileSystem = fileSystem;
        String string2 = this.fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue(string2, "fileSystem.separator");
        this.nameSeparator = string2;
        Path path = this.fileSystem.getPath("/modules", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "fileSystem.getPath(\"/modules\")");
        this.modulesPath = path;
        AutoCloseable e = Files.walk(this.modulesPath, new FileVisitOption[0]);
        jdkJImageResolver = this;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)e;
            boolean bl = false;
            map2 = stream.filter(arg_0 -> JdkJImageResolver.lambda$4$lambda$0(1.1.INSTANCE, arg_0)).collect(Collectors.toMap(arg_0 -> JdkJImageResolver.lambda$4$lambda$1(new Function1<Path, String>(this){
                final /* synthetic */ JdkJImageResolver this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final String invoke(Path p) {
                    Intrinsics.checkNotNullExpressionValue(p, "p");
                    return JdkJImageResolver.access$getClassName(this.this$0, p);
                }
            }, arg_0), arg_0 -> JdkJImageResolver.lambda$4$lambda$2(new Function1<Path, String>(this){
                final /* synthetic */ JdkJImageResolver this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final String invoke(Path p) {
                    Intrinsics.checkNotNullExpressionValue(p, "p");
                    return JdkJImageResolver.access$getModuleName(this.this$0, p);
                }
            }, arg_0), JdkJImageResolver::lambda$4$lambda$3));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(e, throwable);
        }
        Map<String, String> map3 = map2;
        Intrinsics.checkNotNullExpressionValue(map3, "walk(modulesPath).use { \u2026        )\n        )\n    }");
        jdkJImageResolver.classNameToModuleName = map3;
        for (String className : this.classNameToModuleName.keySet()) {
            Intrinsics.checkNotNullExpressionValue(className, "className");
            this.packageSet.addPackagesOfClass(className);
        }
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    private final FileSystem getJrtFileSystem(Path javaHome) {
        FileSystem fileSystem = FileSystems.newFileSystem(JRT_SCHEME_URI, MapsKt.mapOf(TuplesKt.to("java.home", ((Object)javaHome).toString())));
        Intrinsics.checkNotNullExpressionValue(fileSystem, "newFileSystem(JRT_SCHEME\u2026 to javaHome.toString()))");
        return fileSystem;
    }

    private final String getModuleName(Path classPath) {
        Path path = this.modulesPath.relativize(classPath);
        Intrinsics.checkNotNullExpressionValue(path, "modulesPath.relativize(classPath)");
        return CollectionsKt.first(path).toString();
    }

    private final String getClassName(Path classPath) {
        Path relative = this.modulesPath.relativize(classPath);
        return StringsKt.replace$default(StringsKt.substringBeforeLast$default(((Object)relative.subpath(1, relative.getNameCount())).toString(), ".class", null, 2, null), this.nameSeparator, "/", false, 4, null);
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        return this.classNameToModuleName.keySet();
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageSet.getAllPackages();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return new ResourceBundleNameSet(MapsKt.emptyMap());
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        String moduleName = this.classNameToModuleName.get(className);
        if (moduleName != null) {
            Path classPath = this.modulesPath.resolve(moduleName).resolve(StringsKt.replace$default(className, "/", this.nameSeparator, false, 4, null) + ".class");
            Intrinsics.checkNotNullExpressionValue(classPath, "classPath");
            return this.readClass(className, classPath);
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    private final ResolutionResult<ClassNode> readClass(String className, Path classPath) {
        ResolutionResult resolutionResult;
        try {
            ClassNode classNode = this.readClassNode(className, classPath);
            resolutionResult = new ResolutionResult.Found<ClassNode>(classNode, this.fileOrigin);
        }
        catch (InvalidClassFileException e) {
            resolutionResult = new ResolutionResult.Invalid(e.getMessage());
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            String string2 = e.getLocalizedMessage();
            if (string2 == null) {
                string2 = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue(string2, "e.localizedMessage ?: e.javaClass.name");
            resolutionResult = new ResolutionResult.FailedToRead(string2);
        }
        return resolutionResult;
    }

    @NotNull
    public ResolutionResult.NotFound resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        return ResolutionResult.NotFound.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ClassNode readClassNode(String className, Path classFilePath) {
        ClassNode classNode;
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = Files.newInputStream(classFilePath, object);
        Throwable throwable = null;
        try {
            InputStream inputStream2 = (InputStream)object;
            boolean bl = false;
            ClassNode classNode2 = AsmUtil.readClassNode(className, inputStream2, this.getReadMode() == Resolver.ReadMode.FULL);
            classNode = classNode2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(classNode, "newInputStream(classFile\u2026e == ReadMode.FULL)\n    }");
        return classNode;
    }

    @Override
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.classNameToModuleName.containsKey(className);
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return this.packageSet.containsPackage(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        AutoCloseable autoCloseable = Files.walk(this.modulesPath, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator2 = stream.filter(arg_0 -> JdkJImageResolver.processAllClasses$lambda$7$lambda$6(processAllClasses.1.1.INSTANCE, arg_0)).iterator();
            while (iterator2.hasNext()) {
                Path classPath = (Path)iterator2.next();
                Intrinsics.checkNotNullExpressionValue(classPath, "classPath");
                String className = this.getClassName(classPath);
                ResolutionResult<ClassNode> result2 = this.readClass(className, classPath);
                if (processor.invoke(result2).booleanValue()) continue;
                boolean bl2 = false;
                return bl2;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return true;
    }

    @Override
    public void close() {
        this.fileSystem.close();
    }

    private static final boolean lambda$4$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String lambda$4$lambda$3(String one, String string2) {
        return one;
    }

    private static final boolean processAllClasses$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getClassName(JdkJImageResolver $this, Path classPath) {
        return $this.getClassName(classPath);
    }

    public static final /* synthetic */ String access$getModuleName(JdkJImageResolver $this, Path classPath) {
        return $this.getModuleName(classPath);
    }

    static {
        URI uRI = URI.create("jrt:/");
        Intrinsics.checkNotNullExpressionValue(uRI, "create(\"jrt:/\")");
        JRT_SCHEME_URI = uRI;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/jdk/JdkJImageResolver$Companion;", "", "()V", "JRT_SCHEME_URI", "Ljava/net/URI;", "getJRT_SCHEME_URI", "()Ljava/net/URI;", "verifier-intellij"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URI getJRT_SCHEME_URI() {
            return JRT_SCHEME_URI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

