/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.output.markdown;

import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import com.jetbrains.pluginverifier.dymamic.DynamicPluginStatus;
import com.jetbrains.pluginverifier.dymamic.DynamicPlugins;
import com.jetbrains.pluginverifier.output.markdown.Markdown;
import com.jetbrains.pluginverifier.output.markdown.MarkdownResultPrinterKt;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecatedApiUsage;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalApiUsage;
import com.jetbrains.pluginverifier.usages.internal.InternalApiUsage;
import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableApiUsage;
import com.jetbrains.pluginverifier.usages.overrideOnly.OverrideOnlyMethodUsage;
import com.jetbrains.pluginverifier.warnings.CompatibilityWarning;
import com.jetbrains.pluginverifier.warnings.PluginStructureWarning;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\u001a'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\t\u001a&\u0010\n\u001a\u00020\b*\u00020\u00032\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\fH\u0002\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0010\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0011\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0012\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0013\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0014\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0015\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0016\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0017\u001a\u0016\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f*\u00020\u0018\u001a\u0015\u0010\u0019\u001a\u00020\b*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0082\u0002\u001a\u0014\u0010\u001c\u001a\u00020\b*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001aH\u0010\u001c\u001a\u00020\b\"\u0004\b\u0000\u0010\u001d*\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u001e\u0010!\u001a\u001a\u0012\u0004\u0012\u0002H\u001d\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000f0\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"REPORT_FILE_NAME", "", "markdown", "Lcom/jetbrains/pluginverifier/output/markdown/Markdown;", "out", "Ljava/io/PrintWriter;", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "appendShortAndFullDescriptions", "shortToFullDescriptions", "", "", "describe", "Lkotlin/Pair;", "Lcom/jetbrains/pluginverifier/dependencies/MissingDependency;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "Lcom/jetbrains/pluginverifier/usages/deprecated/DeprecatedApiUsage;", "Lcom/jetbrains/pluginverifier/usages/experimental/ExperimentalApiUsage;", "Lcom/jetbrains/pluginverifier/usages/internal/InternalApiUsage;", "Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableApiUsage;", "Lcom/jetbrains/pluginverifier/usages/overrideOnly/OverrideOnlyMethodUsage;", "Lcom/jetbrains/pluginverifier/warnings/CompatibilityWarning;", "Lcom/jetbrains/pluginverifier/warnings/PluginStructureWarning;", "plus", "result", "Lcom/jetbrains/pluginverifier/PluginVerificationResult$Verified;", "printVerificationResult", "T", "title", "items", "", "descriptionPropertyExtractor", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nMarkdownResultPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownResultPrinter.kt\ncom/jetbrains/pluginverifier/output/markdown/MarkdownResultPrinterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,213:1\n1855#2,2:214\n1549#2:216\n1620#2,3:217\n1490#2:220\n1520#2,3:221\n1523#2,3:231\n1855#2,2:235\n372#3,7:224\n215#4:234\n216#4:237\n*S KotlinDebug\n*F\n+ 1 MarkdownResultPrinter.kt\ncom/jetbrains/pluginverifier/output/markdown/MarkdownResultPrinterKt\n*L\n171#1:214,2\n184#1:216\n184#1:217,3\n185#1:220\n185#1:221,3\n185#1:231,3\n196#1:235,2\n185#1:224,7\n191#1:234\n191#1:237\n*E\n"})
public final class MarkdownResultPrinterKt {
    @NotNull
    private static final String REPORT_FILE_NAME = "report.md";

    @NotNull
    public static final Markdown markdown(@NotNull PrintWriter out, @NotNull Function1<? super Markdown, Unit> init) {
        Intrinsics.checkNotNullParameter(out, "out");
        Intrinsics.checkNotNullParameter(init, "init");
        Markdown markdown = new Markdown(out);
        init.invoke(markdown);
        return markdown;
    }

    private static final void plus(Markdown $this$plus, PluginVerificationResult.Verified result2) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        MarkdownResultPrinterKt.printVerificationResult($this$plus, result2);
    }

    private static final void printVerificationResult(Markdown $this$printVerificationResult, PluginVerificationResult.Verified result2) {
        PluginVerificationResult.Verified $this$printVerificationResult_u24lambda_u241 = result2;
        boolean bl = false;
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Plugin structure warnings", $this$printVerificationResult_u24lambda_u241.getPluginStructureWarnings(), printVerificationResult.1.1.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Missing dependencies", $this$printVerificationResult_u24lambda_u241.getDependenciesGraph().getDirectMissingDependencies(), printVerificationResult.1.2.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Compatibility warnings", $this$printVerificationResult_u24lambda_u241.getCompatibilityWarnings(), printVerificationResult.1.3.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Compatibility problems", $this$printVerificationResult_u24lambda_u241.getCompatibilityProblems(), printVerificationResult.1.4.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Deprecated API usages", $this$printVerificationResult_u24lambda_u241.getDeprecatedUsages(), printVerificationResult.1.5.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Experimental API usages", $this$printVerificationResult_u24lambda_u241.getExperimentalApiUsages(), printVerificationResult.1.6.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Internal API usages", $this$printVerificationResult_u24lambda_u241.getInternalApiUsages(), printVerificationResult.1.7.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Override-only API usages", $this$printVerificationResult_u24lambda_u241.getOverrideOnlyMethodUsages(), printVerificationResult.1.8.INSTANCE);
        MarkdownResultPrinterKt.printVerificationResult($this$printVerificationResult, "Non-extendable API usages", $this$printVerificationResult_u24lambda_u241.getNonExtendableApiUsages(), printVerificationResult.1.9.INSTANCE);
        String dynaStatus = "Dynamic Plugin Status";
        DynamicPluginStatus dynamicPluginStatus = $this$printVerificationResult_u24lambda_u241.getDynamicPluginStatus();
        if (dynamicPluginStatus instanceof DynamicPluginStatus.MaybeDynamic) {
            $this$printVerificationResult.h2(dynaStatus).plus($this$printVerificationResult.paragraph("Plugin can probably be enabled or disabled without IDE restart"));
        } else if (dynamicPluginStatus instanceof DynamicPluginStatus.NotDynamic) {
            $this$printVerificationResult.h2(dynaStatus).plus($this$printVerificationResult.paragraph("Plugin probably cannot be enabled or disabled without IDE restart"));
            Iterable $this$forEach$iv = DynamicPlugins.INSTANCE.simplifiedReasonsNotToLoadUnloadWithoutRestart((DynamicPluginStatus.NotDynamic)dynamicPluginStatus);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                $this$printVerificationResult.unorderedListItem(it);
            }
            $this$printVerificationResult.unorderedListEnd();
        } else if (dynamicPluginStatus == null) {
            // empty if block
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void printVerificationResult(Markdown $this$printVerificationResult, String title2, Set<? extends T> items, Function1<? super T, Pair<String, String>> descriptionPropertyExtractor) {
        if (!((Collection)items).isEmpty()) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$mapTo$iv$iv;
            $this$printVerificationResult.h2(title2 + " (" + items.size() + ")");
            Iterable $this$map$iv = items;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(descriptionPropertyExtractor.invoke(item$iv$iv));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object;
                Pair it2 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-MarkdownResultPrinterKt$printVerificationResult$shortToFullDescriptions$32 = false;
                String key$iv$iv = (String)it2.getFirst();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                Pair $i$a$-groupBy-MarkdownResultPrinterKt$printVerificationResult$shortToFullDescriptions$32 = (Pair)element$iv$iv;
                List list = list$iv$iv;
                boolean bl = false;
                list.add((String)it.getSecond());
            }
            Object shortToFullDescriptions = destination$iv$iv;
            MarkdownResultPrinterKt.appendShortAndFullDescriptions($this$printVerificationResult, (Map<String, ? extends List<String>>)shortToFullDescriptions);
        }
    }

    private static final void appendShortAndFullDescriptions(Markdown $this$appendShortAndFullDescriptions, Map<String, ? extends List<String>> shortToFullDescriptions) {
        Map<String, ? extends List<String>> $this$forEach$iv = shortToFullDescriptions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<String>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ? extends List<String>> element$iv;
            Map.Entry<String, ? extends List<String>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String shortDescription = entry.getKey();
            List<String> fullDescriptions = entry.getValue();
            if (((CharSequence)shortDescription).length() > 0) {
                $this$appendShortAndFullDescriptions.h3(shortDescription);
            }
            for (String fullDescription2 : fullDescriptions) {
                Iterable $this$forEach$iv2 = StringsKt.lines(fullDescription2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String line = (String)element$iv2;
                    boolean bl2 = false;
                    $this$appendShortAndFullDescriptions.unorderedListItem(line);
                }
            }
            $this$appendShortAndFullDescriptions.unorderedListEnd();
        }
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull PluginStructureWarning $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to("", $this$describe.getMessage());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull MissingDependency $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to("", $this$describe.getDependency() + ": " + $this$describe.getMissingReason());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull CompatibilityWarning $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to($this$describe.getShortDescription(), $this$describe.getFullDescription());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull CompatibilityProblem $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to($this$describe.getShortDescription(), $this$describe.getFullDescription());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull DeprecatedApiUsage $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to($this$describe.getShortDescription(), $this$describe.getFullDescription());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull ExperimentalApiUsage $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to($this$describe.getShortDescription(), $this$describe.getFullDescription());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull InternalApiUsage $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to($this$describe.getShortDescription(), $this$describe.getFullDescription());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull OverrideOnlyMethodUsage $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to($this$describe.getShortDescription(), $this$describe.getFullDescription());
    }

    @NotNull
    public static final Pair<String, String> describe(@NotNull NonExtendableApiUsage $this$describe) {
        Intrinsics.checkNotNullParameter($this$describe, "<this>");
        return TuplesKt.to($this$describe.getShortDescription(), $this$describe.getFullDescription());
    }

    public static final /* synthetic */ void access$plus(Markdown $receiver, PluginVerificationResult.Verified result2) {
        MarkdownResultPrinterKt.plus($receiver, result2);
    }
}

