/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.output.stream;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.intellij.problems.remapping.ignored.CliIgnoredProblemLevelRemappingManager;
import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.dependencies.MissingDependency;
import com.jetbrains.pluginverifier.dymamic.DynamicPluginStatus;
import com.jetbrains.pluginverifier.output.ResultPrinter;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.tasks.InvalidPluginFile;
import com.jetbrains.pluginverifier.usages.ApiUsage;
import com.jetbrains.pluginverifier.usages.deprecated.DeprecatedApiUsage;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalApiUsage;
import com.jetbrains.pluginverifier.usages.internal.InternalApiUsage;
import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableApiUsage;
import com.jetbrains.pluginverifier.usages.overrideOnly.OverrideOnlyMethodUsage;
import com.jetbrains.pluginverifier.warnings.CompatibilityWarning;
import com.jetbrains.pluginverifier.warnings.PluginStructureWarning;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0016J*\u0010\u0014\u001a\u00020\r*\u00060\u0015j\u0002`\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\r*\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\b*\u00020\u001dH\u0002J\u001e\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u0018*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/jetbrains/pluginverifier/output/stream/WriterResultPrinter;", "Lcom/jetbrains/pluginverifier/output/ResultPrinter;", "out", "Ljava/io/PrintWriter;", "(Ljava/io/PrintWriter;)V", "problemSolutionHintProvider", "Lcom/jetbrains/plugin/structure/intellij/problems/remapping/ignored/CliIgnoredProblemLevelRemappingManager;", "solutionHint", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "getSolutionHint", "(Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;)Ljava/lang/String;", "printInvalidPluginFiles", "", "invalidPluginFiles", "", "Lcom/jetbrains/pluginverifier/tasks/InvalidPluginFile;", "printResults", "results", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "appendShortAndFullDescriptions", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "shortToFullDescriptions", "", "printProblemSolutionHint", "indentLevel", "", "printVerificationResult", "Lcom/jetbrains/pluginverifier/PluginVerificationResult$Verified;", "Lcom/jetbrains/pluginverifier/dymamic/DynamicPluginStatus$NotDynamic;", "Companion", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nWriterResultPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriterResultPrinter.kt\ncom/jetbrains/pluginverifier/output/stream/WriterResultPrinter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,157:1\n1855#2,2:158\n3190#2,10:160\n1490#2:171\n1520#2,3:172\n1523#2,3:182\n1490#2:185\n1520#2,3:186\n1523#2,3:196\n1490#2:199\n1520#2,3:200\n1523#2,3:210\n1490#2:213\n1520#2,3:214\n1523#2,3:224\n1490#2:227\n1520#2,3:228\n1523#2,3:238\n1490#2:241\n1520#2,3:242\n1523#2,3:252\n1490#2:255\n1520#2,3:256\n1523#2,3:266\n1549#2:269\n1620#2,3:270\n1271#2,2:273\n1285#2,4:275\n1855#2,2:280\n1#3:170\n372#4,7:175\n372#4,7:189\n372#4,7:203\n372#4,7:217\n372#4,7:231\n372#4,7:245\n372#4,7:259\n215#5:279\n216#5:282\n*S KotlinDebug\n*F\n+ 1 WriterResultPrinter.kt\ncom/jetbrains/pluginverifier/output/stream/WriterResultPrinter\n*L\n29#1:158,2\n44#1:160,10\n88#1:171\n88#1:172,3\n88#1:182,3\n93#1:185\n93#1:186,3\n93#1:196,3\n98#1:199\n98#1:200,3\n98#1:210,3\n103#1:213\n103#1:214,3\n103#1:224,3\n108#1:227\n108#1:228,3\n108#1:238,3\n113#1:241\n113#1:242,3\n113#1:252,3\n118#1:255\n118#1:256,3\n118#1:266,3\n135#1:269\n135#1:270,3\n139#1:273,2\n139#1:275,4\n147#1:280,2\n88#1:175,7\n93#1:189,7\n98#1:203,7\n103#1:217,7\n108#1:231,7\n113#1:245,7\n118#1:259,7\n144#1:279\n144#1:282\n*E\n"})
public final class WriterResultPrinter
implements ResultPrinter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PrintWriter out;
    @NotNull
    private final CliIgnoredProblemLevelRemappingManager problemSolutionHintProvider;
    @NotNull
    private static final String INDENT = "    ";

    public WriterResultPrinter(@NotNull PrintWriter out) {
        Intrinsics.checkNotNullParameter(out, "out");
        this.out = out;
        this.problemSolutionHintProvider = new CliIgnoredProblemLevelRemappingManager(null, 1, null);
    }

    @Override
    public void printResults(@NotNull List<? extends PluginVerificationResult> results) {
        Intrinsics.checkNotNullParameter(results, "results");
        Iterable $this$forEach$iv = results;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginVerificationResult result2 = (PluginVerificationResult)element$iv;
            boolean bl = false;
            PluginInfo plugin = result2.getPlugin();
            PluginVerificationTarget verificationTarget = result2.getVerificationTarget();
            this.out.println("Plugin " + plugin + " against " + verificationTarget + ": " + result2.getVerificationVerdict());
            if (!(result2 instanceof PluginVerificationResult.Verified)) continue;
            this.out.println(this.printVerificationResult((PluginVerificationResult.Verified)result2));
        }
    }

    public final void printInvalidPluginFiles(@NotNull List<InvalidPluginFile> invalidPluginFiles) {
        Intrinsics.checkNotNullParameter(invalidPluginFiles, "invalidPluginFiles");
        if (!((Collection)invalidPluginFiles).isEmpty()) {
            this.out.println("The following files specified for the verification are not valid plugins:");
            for (InvalidPluginFile invalidPluginFile : invalidPluginFiles) {
                Path pluginFile = invalidPluginFile.component1();
                List<PluginProblem> pluginProblems = invalidPluginFile.component2();
                this.out.println(INDENT + pluginFile);
                Iterable $this$partition$iv = pluginProblems;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    PluginProblem it = (PluginProblem)element$iv;
                    boolean bl = false;
                    if (PluginProblemsKt.isError(it)) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair pair = new Pair(first$iv, second$iv);
                List pluginErrors = pair.component1();
                List otherPluginProblems = pair.component2();
                if (!((Collection)pluginErrors).isEmpty()) {
                    this.out.println("        Plugin problems:");
                    for (PluginProblem pluginError : pluginErrors) {
                        this.out.println("            " + pluginError);
                        this.printProblemSolutionHint(pluginError, 2);
                    }
                }
                if (!(!((Collection)otherPluginProblems).isEmpty())) continue;
                this.out.println("        Additional plugin warnings:");
                for (PluginProblem pluginProblem : otherPluginProblems) {
                    this.out.println("            " + pluginProblem);
                    this.printProblemSolutionHint(pluginProblem, 2);
                }
            }
        }
    }

    private final void printProblemSolutionHint(PluginProblem $this$printProblemSolutionHint, int indentLevel) {
        if (((CharSequence)this.getSolutionHint($this$printProblemSolutionHint)).length() == 0) {
            return;
        }
        String indent = StringsKt.repeat(" ", indentLevel * 4);
        this.out.println("        " + indent + this.getSolutionHint($this$printProblemSolutionHint));
    }

    static /* synthetic */ void printProblemSolutionHint$default(WriterResultPrinter writerResultPrinter, PluginProblem pluginProblem, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        writerResultPrinter.printProblemSolutionHint(pluginProblem, n);
    }

    /*
     * WARNING - void declaration
     */
    private final String printVerificationResult(PluginVerificationResult.Verified $this$printVerificationResult) {
        Object it;
        void it2;
        Object object;
        List list$iv$iv;
        List answer$iv$iv$iv;
        Object value$iv$iv$iv;
        boolean $i$f$getOrPut;
        Map $this$getOrPut$iv$iv$iv;
        String key$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        boolean $i$f$groupByTo;
        Map destination$iv$iv;
        WriterResultPrinter writerResultPrinter;
        StringBuilder stringBuilder;
        Set<MissingDependency> directMissingDependencies;
        Object object2;
        StringBuilder stringBuilder2;
        StringBuilder $this$printVerificationResult_u24lambda_u2418 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        if (!((Collection)$this$printVerificationResult.getPluginStructureWarnings()).isEmpty()) {
            StringBuilder stringBuilder3 = $this$printVerificationResult_u24lambda_u2418.append("Plugin structure warnings (" + $this$printVerificationResult.getPluginStructureWarnings().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append(...)");
            for (PluginStructureWarning pluginStructureWarning : $this$printVerificationResult.getPluginStructureWarnings()) {
                StringBuilder stringBuilder4;
                StringBuilder stringBuilder5 = $this$printVerificationResult_u24lambda_u2418.append(INDENT + pluginStructureWarning.getMessage());
                Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append(...)");
                Object it3 = object2 = this.getSolutionHint(pluginStructureWarning.getProblem());
                boolean bl2 = false;
                if ((!StringsKt.isBlank((CharSequence)it3) ? object2 : null) != null) {
                    Object it4;
                    it4 = it4;
                    boolean bl3 = false;
                    StringBuilder stringBuilder6 = $this$printVerificationResult_u24lambda_u2418.append("        " + (String)it4);
                    Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(...)");
                    StringBuilder stringBuilder7 = stringBuilder6.append('\n');
                    stringBuilder4 = stringBuilder7;
                    Intrinsics.checkNotNullExpressionValue(stringBuilder7, "append(...)");
                    continue;
                }
                stringBuilder4 = null;
            }
        }
        if (!((Collection)(directMissingDependencies = $this$printVerificationResult.getDependenciesGraph().getDirectMissingDependencies())).isEmpty()) {
            StringBuilder stringBuilder8 = $this$printVerificationResult_u24lambda_u2418.append("Missing dependencies: ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder8, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder8.append('\n'), "append(...)");
            for (MissingDependency missingDependency : directMissingDependencies) {
                StringBuilder stringBuilder9 = $this$printVerificationResult_u24lambda_u2418.append(INDENT + missingDependency.getDependency() + ": " + missingDependency.getMissingReason());
                Intrinsics.checkNotNullExpressionValue(stringBuilder9, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder9.append('\n'), "append(...)");
            }
        }
        if (!((Collection)$this$printVerificationResult.getCompatibilityWarnings()).isEmpty()) {
            StringBuilder stringBuilder10 = $this$printVerificationResult_u24lambda_u2418.append("Compatibility warnings (" + $this$printVerificationResult.getCompatibilityWarnings().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder10, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder10.append('\n'), "append(...)");
            Iterable iterable = $this$printVerificationResult.getCompatibilityWarnings();
            stringBuilder = $this$printVerificationResult_u24lambda_u2418;
            writerResultPrinter = this;
            boolean $i$f$groupBy = false;
            object2 = iterable;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object3;
                CompatibilityWarning it22 = (CompatibilityWarning)element$iv$iv;
                boolean $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$1732 = false;
                key$iv$iv = it22.getShortDescription();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object3;
                CompatibilityWarning $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$1732 = (CompatibilityWarning)element$iv$iv;
                object = list$iv$iv;
                boolean bl5 = false;
                object.add(it2.getFullDescription());
            }
            object = destination$iv$iv;
            writerResultPrinter.appendShortAndFullDescriptions(stringBuilder, (Map<String, ? extends List<String>>)object);
        }
        if (!((Collection)$this$printVerificationResult.getCompatibilityProblems()).isEmpty()) {
            StringBuilder stringBuilder11 = $this$printVerificationResult_u24lambda_u2418.append("Compatibility problems (" + $this$printVerificationResult.getCompatibilityProblems().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder11, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder11.append('\n'), "append(...)");
            Iterable iterable = $this$printVerificationResult.getCompatibilityProblems();
            stringBuilder = $this$printVerificationResult_u24lambda_u2418;
            writerResultPrinter = this;
            boolean $i$f$groupBy = false;
            $this$groupByTo$iv$iv = iterable;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object4;
                it = (CompatibilityProblem)element$iv$iv;
                boolean $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$1832 = false;
                key$iv$iv = ((CompatibilityProblem)it).getShortDescription();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object4;
                CompatibilityProblem $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$1832 = (CompatibilityProblem)element$iv$iv;
                object = list$iv$iv;
                boolean bl7 = false;
                object.add(it2.getFullDescription());
            }
            object = destination$iv$iv;
            writerResultPrinter.appendShortAndFullDescriptions(stringBuilder, (Map<String, ? extends List<String>>)object);
        }
        if (!((Collection)$this$printVerificationResult.getDeprecatedUsages()).isEmpty()) {
            StringBuilder stringBuilder12 = $this$printVerificationResult_u24lambda_u2418.append("Deprecated API usages (" + $this$printVerificationResult.getDeprecatedUsages().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder12, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder12.append('\n'), "append(...)");
            Iterable iterable = $this$printVerificationResult.getDeprecatedUsages();
            stringBuilder = $this$printVerificationResult_u24lambda_u2418;
            writerResultPrinter = this;
            boolean $i$f$groupBy = false;
            $this$groupByTo$iv$iv = iterable;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object5;
                it = (DeprecatedApiUsage)element$iv$iv;
                boolean $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$1932 = false;
                key$iv$iv = ((ApiUsage)it).getShortDescription();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl8 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object5 = answer$iv$iv$iv;
                } else {
                    object5 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object5;
                DeprecatedApiUsage $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$1932 = (DeprecatedApiUsage)element$iv$iv;
                object = list$iv$iv;
                boolean bl9 = false;
                object.add(it2.getFullDescription());
            }
            object = destination$iv$iv;
            writerResultPrinter.appendShortAndFullDescriptions(stringBuilder, (Map<String, ? extends List<String>>)object);
        }
        if (!((Collection)$this$printVerificationResult.getExperimentalApiUsages()).isEmpty()) {
            StringBuilder stringBuilder13 = $this$printVerificationResult_u24lambda_u2418.append("Experimental API usages (" + $this$printVerificationResult.getExperimentalApiUsages().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder13, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder13.append('\n'), "append(...)");
            Iterable iterable = $this$printVerificationResult.getExperimentalApiUsages();
            stringBuilder = $this$printVerificationResult_u24lambda_u2418;
            writerResultPrinter = this;
            boolean $i$f$groupBy = false;
            $this$groupByTo$iv$iv = iterable;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object6;
                it = (ExperimentalApiUsage)element$iv$iv;
                boolean $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2032 = false;
                key$iv$iv = ((ApiUsage)it).getShortDescription();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl10 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object6 = answer$iv$iv$iv;
                } else {
                    object6 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object6;
                ExperimentalApiUsage $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2032 = (ExperimentalApiUsage)element$iv$iv;
                object = list$iv$iv;
                boolean bl11 = false;
                object.add(it2.getFullDescription());
            }
            object = destination$iv$iv;
            writerResultPrinter.appendShortAndFullDescriptions(stringBuilder, (Map<String, ? extends List<String>>)object);
        }
        if (!((Collection)$this$printVerificationResult.getInternalApiUsages()).isEmpty()) {
            StringBuilder stringBuilder14 = $this$printVerificationResult_u24lambda_u2418.append("Internal API usages (" + $this$printVerificationResult.getInternalApiUsages().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder14, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder14.append('\n'), "append(...)");
            Iterable iterable = $this$printVerificationResult.getInternalApiUsages();
            stringBuilder = $this$printVerificationResult_u24lambda_u2418;
            writerResultPrinter = this;
            boolean $i$f$groupBy = false;
            $this$groupByTo$iv$iv = iterable;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object7;
                it = (InternalApiUsage)element$iv$iv;
                boolean $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2132 = false;
                key$iv$iv = ((ApiUsage)it).getShortDescription();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl12 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object7 = answer$iv$iv$iv;
                } else {
                    object7 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object7;
                InternalApiUsage $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2132 = (InternalApiUsage)element$iv$iv;
                object = list$iv$iv;
                boolean bl13 = false;
                object.add(it2.getFullDescription());
            }
            object = destination$iv$iv;
            writerResultPrinter.appendShortAndFullDescriptions(stringBuilder, (Map<String, ? extends List<String>>)object);
        }
        if (!((Collection)$this$printVerificationResult.getOverrideOnlyMethodUsages()).isEmpty()) {
            StringBuilder stringBuilder15 = $this$printVerificationResult_u24lambda_u2418.append("Override-only API usages (" + $this$printVerificationResult.getOverrideOnlyMethodUsages().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder15, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder15.append('\n'), "append(...)");
            Iterable iterable = $this$printVerificationResult.getOverrideOnlyMethodUsages();
            stringBuilder = $this$printVerificationResult_u24lambda_u2418;
            writerResultPrinter = this;
            boolean $i$f$groupBy = false;
            $this$groupByTo$iv$iv = iterable;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object8;
                it = (OverrideOnlyMethodUsage)element$iv$iv;
                boolean $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2232 = false;
                key$iv$iv = ((OverrideOnlyMethodUsage)it).getShortDescription();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl14 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object8 = answer$iv$iv$iv;
                } else {
                    object8 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object8;
                OverrideOnlyMethodUsage $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2232 = (OverrideOnlyMethodUsage)element$iv$iv;
                object = list$iv$iv;
                boolean bl15 = false;
                object.add(it2.getFullDescription());
            }
            object = destination$iv$iv;
            writerResultPrinter.appendShortAndFullDescriptions(stringBuilder, (Map<String, ? extends List<String>>)object);
        }
        if (!((Collection)$this$printVerificationResult.getNonExtendableApiUsages()).isEmpty()) {
            StringBuilder stringBuilder16 = $this$printVerificationResult_u24lambda_u2418.append("Non-extendable API usages (" + $this$printVerificationResult.getNonExtendableApiUsages().size() + "): ");
            Intrinsics.checkNotNullExpressionValue(stringBuilder16, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder16.append('\n'), "append(...)");
            Iterable iterable = $this$printVerificationResult.getNonExtendableApiUsages();
            stringBuilder = $this$printVerificationResult_u24lambda_u2418;
            writerResultPrinter = this;
            boolean $i$f$groupBy = false;
            $this$groupByTo$iv$iv = iterable;
            destination$iv$iv = new LinkedHashMap();
            $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object9;
                it = (NonExtendableApiUsage)element$iv$iv;
                boolean $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2332 = false;
                key$iv$iv = ((ApiUsage)it).getShortDescription();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl16 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object9 = answer$iv$iv$iv;
                } else {
                    object9 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object9;
                NonExtendableApiUsage $i$a$-groupBy-WriterResultPrinter$printVerificationResult$1$2332 = (NonExtendableApiUsage)element$iv$iv;
                object = list$iv$iv;
                boolean bl17 = false;
                object.add(it2.getFullDescription());
            }
            object = destination$iv$iv;
            writerResultPrinter.appendShortAndFullDescriptions(stringBuilder, (Map<String, ? extends List<String>>)object);
        }
        String string2 = "Dynamic Plugin Eligibility";
        DynamicPluginStatus dynamicPluginStatus = $this$printVerificationResult.getDynamicPluginStatus();
        if (dynamicPluginStatus instanceof DynamicPluginStatus.MaybeDynamic) {
            StringBuilder stringBuilder17 = $this$printVerificationResult_u24lambda_u2418.append(string2 + ":");
            Intrinsics.checkNotNullExpressionValue(stringBuilder17, "append(...)");
            StringBuilder stringBuilder18 = stringBuilder17.append('\n');
            Intrinsics.checkNotNullExpressionValue(stringBuilder18, "append(...)");
            StringBuilder stringBuilder19 = stringBuilder18.append("    Plugin can probably be enabled or disabled without IDE restart");
            Intrinsics.checkNotNullExpressionValue(stringBuilder19, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder19.append('\n'), "append(...)");
        } else if (dynamicPluginStatus instanceof DynamicPluginStatus.NotDynamic) {
            Map<String, List<String>> restrictions = this.shortToFullDescriptions((DynamicPluginStatus.NotDynamic)dynamicPluginStatus);
            String heading = string2 + " (negative due to " + restrictions.size() + " restrictions):";
            StringBuilder stringBuilder20 = $this$printVerificationResult_u24lambda_u2418.append(heading);
            Intrinsics.checkNotNullExpressionValue(stringBuilder20, "append(...)");
            StringBuilder stringBuilder21 = stringBuilder20.append('\n');
            Intrinsics.checkNotNullExpressionValue(stringBuilder21, "append(...)");
            StringBuilder stringBuilder22 = stringBuilder21.append("    Plugin probably cannot be enabled or disabled without IDE restart");
            Intrinsics.checkNotNullExpressionValue(stringBuilder22, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder22.append('\n'), "append(...)");
            this.appendShortAndFullDescriptions($this$printVerificationResult_u24lambda_u2418, restrictions);
        } else if (dynamicPluginStatus == null) {
            // empty if block
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<String>> shortToFullDescriptions(DynamicPluginStatus.NotDynamic $this$shortToFullDescriptions) {
        String reason;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$shortToFullDescriptions.getReasonsNotToLoadUnloadWithoutRestart();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            String string3 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string4 = StringsKt.removePrefix(reason, (CharSequence)"Plugin probably cannot be enabled or disabled without IDE restart because ");
            if (((CharSequence)string4).length() > 0) {
                String string5;
                void it;
                char c = string4.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
                    string5 = CharsKt.titlecase((char)it, locale);
                } else {
                    string5 = String.valueOf((char)it);
                }
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string5);
                String string6 = string4;
                int n = 1;
                String string7 = string6.substring(n);
                Intrinsics.checkNotNullExpressionValue(string7, "substring(...)");
                string2 = stringBuilder2.append(string7).toString();
            } else {
                string2 = string4;
            }
            object.add(string2);
        }
        List justReasonRestrictions = (List)destination$iv$iv;
        Iterable $this$associateWith$iv = justReasonRestrictions;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            reason = (String)element$iv$iv;
            Object t2 = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            object.put(t2, list);
        }
        return result$iv;
    }

    private final void appendShortAndFullDescriptions(StringBuilder $this$appendShortAndFullDescriptions, Map<String, ? extends List<String>> shortToFullDescriptions) {
        String indent = INDENT;
        Map<String, ? extends List<String>> $this$forEach$iv = shortToFullDescriptions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<String>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ? extends List<String>> element$iv;
            Map.Entry<String, ? extends List<String>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String shortDescription = entry.getKey();
            List<String> fullDescriptions = entry.getValue();
            StringBuilder stringBuilder = $this$appendShortAndFullDescriptions.append(indent + "#" + shortDescription);
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append(...)");
            for (String fullDescription2 : fullDescriptions) {
                Iterable $this$forEach$iv2 = StringsKt.lines(fullDescription2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String line = (String)element$iv2;
                    boolean bl2 = false;
                    StringBuilder stringBuilder2 = $this$appendShortAndFullDescriptions.append(indent + indent + line);
                    Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(...)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append(...)");
                }
            }
        }
    }

    private final String getSolutionHint(PluginProblem $this$solutionHint) {
        String string2 = this.problemSolutionHintProvider.getProblemSolutionHint($this$solutionHint);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/pluginverifier/output/stream/WriterResultPrinter$Companion;", "", "()V", "INDENT", "", "verifier-cli"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

