/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository;

import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "", "pluginId", "", "pluginName", "version", "sinceBuild", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "untilBuild", "vendor", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;Ljava/lang/String;)V", "getPluginId", "()Ljava/lang/String;", "getPluginName", "presentableName", "getPresentableName", "presentableSinceUntilRange", "getPresentableSinceUntilRange", "getSinceBuild", "()Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getUntilBuild", "getVendor", "getVersion", "isCompatibleWith", "", "ideVersion", "toString", "verifier-repository"})
public abstract class PluginInfo {
    @NotNull
    private final String pluginId;
    @NotNull
    private final String pluginName;
    @NotNull
    private final String version;
    @Nullable
    private final IdeVersion sinceBuild;
    @Nullable
    private final IdeVersion untilBuild;
    @Nullable
    private final String vendor;

    public PluginInfo(@NotNull String pluginId, @NotNull String pluginName, @NotNull String version, @Nullable IdeVersion sinceBuild, @Nullable IdeVersion untilBuild, @Nullable String vendor) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(pluginName, "pluginName");
        Intrinsics.checkNotNullParameter(version, "version");
        this.pluginId = pluginId;
        this.pluginName = pluginName;
        this.version = version;
        this.sinceBuild = sinceBuild;
        this.untilBuild = untilBuild;
        this.vendor = vendor;
    }

    @NotNull
    public final String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public final String getPluginName() {
        return this.pluginName;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final IdeVersion getSinceBuild() {
        return this.sinceBuild;
    }

    @Nullable
    public final IdeVersion getUntilBuild() {
        return this.untilBuild;
    }

    @Nullable
    public final String getVendor() {
        return this.vendor;
    }

    public final boolean isCompatibleWith(@NotNull IdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        return !(this.sinceBuild != null && this.sinceBuild.compareTo(ideVersion) > 0 || this.untilBuild != null && ideVersion.compareTo(this.untilBuild) > 0);
    }

    @NotNull
    public final String getPresentableSinceUntilRange() {
        String untilCode;
        IdeVersion ideVersion = this.sinceBuild;
        String sinceCode = ideVersion != null ? ideVersion.asStringWithoutProductCode() : null;
        IdeVersion ideVersion2 = this.untilBuild;
        String string2 = untilCode = ideVersion2 != null ? ideVersion2.asStringWithoutProductCode() : null;
        if (sinceCode != null) {
            if (untilCode != null) {
                return sinceCode + " \u2014 " + untilCode;
            }
            return sinceCode + "+";
        }
        if (untilCode != null) {
            return "1.0 \u2014 " + untilCode;
        }
        return "all";
    }

    @NotNull
    public String getPresentableName() {
        return this.pluginId + " " + this.version;
    }

    @NotNull
    public final String toString() {
        return this.getPresentableName();
    }
}

