/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.cleanup;

import com.jetbrains.pluginverifier.repository.cleanup.SpaceUnit;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0000H\u0096\u0002J\t\u0010\b\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00d6\u0001J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\fH\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "", "bytes", "", "(J)V", "compareTo", "", "other", "component1", "copy", "div", "divisor", "", "equals", "", "", "hashCode", "minus", "otherAmount", "plus", "presentableAmount", "", "times", "multiplier", "to", "spaceUnit", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceUnit;", "toString", "Companion", "verifier-repository"})
public final class SpaceAmount
implements Comparable<SpaceAmount> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long bytes;
    @NotNull
    private static final SpaceAmount ONE_BYTE = Companion.ofBytes(1L);
    @NotNull
    private static final SpaceAmount ONE_KILO_BYTE = Companion.ofKilobytes(1L);
    @NotNull
    private static final SpaceAmount ONE_MEGA_BYTE = Companion.ofMegabytes(1L);
    @NotNull
    private static final SpaceAmount ONE_GIGO_BYTE = Companion.ofGigabytes(1L);
    @NotNull
    private static final SpaceAmount ZERO_SPACE = Companion.ofBytes(0L);

    public SpaceAmount(long bytes) {
        this.bytes = bytes;
    }

    @NotNull
    public final SpaceAmount times(double multiplier) {
        return new SpaceAmount((long)((double)this.bytes * multiplier));
    }

    @NotNull
    public final SpaceAmount times(long multiplier) {
        return new SpaceAmount(this.bytes * multiplier);
    }

    @NotNull
    public final SpaceAmount times(int multiplier) {
        return new SpaceAmount(this.bytes * (long)multiplier);
    }

    @NotNull
    public final SpaceAmount plus(@NotNull SpaceAmount otherAmount) {
        Intrinsics.checkNotNullParameter(otherAmount, "otherAmount");
        return new SpaceAmount(this.bytes + otherAmount.bytes);
    }

    @NotNull
    public final SpaceAmount minus(@NotNull SpaceAmount otherAmount) {
        Intrinsics.checkNotNullParameter(otherAmount, "otherAmount");
        return new SpaceAmount(this.bytes - otherAmount.bytes);
    }

    @NotNull
    public final SpaceAmount div(double divisor) {
        return new SpaceAmount((long)((double)this.bytes / divisor));
    }

    @Override
    public int compareTo(@NotNull SpaceAmount other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.compare(this.bytes, other.bytes);
    }

    public final double to(@NotNull SpaceUnit spaceUnit) {
        Intrinsics.checkNotNullParameter((Object)spaceUnit, "spaceUnit");
        return SpaceUnit.BYTE.to(this.bytes, spaceUnit);
    }

    @NotNull
    public final String presentableAmount() {
        SpaceUnit preferredUnit = this.compareTo(ONE_KILO_BYTE) < 0 ? SpaceUnit.BYTE : (this.compareTo(ONE_MEGA_BYTE) < 0 ? SpaceUnit.KILO_BYTE : (this.compareTo(ONE_GIGO_BYTE) < 0 ? SpaceUnit.MEGA_BYTE : SpaceUnit.GIGO_BYTE));
        double targetAmount = SpaceUnit.BYTE.to(this.bytes, preferredUnit);
        if (targetAmount == (double)((long)targetAmount)) {
            return (long)targetAmount + " " + preferredUnit;
        }
        String string2 = "%.2f %s";
        Object[] objectArray = new Object[]{targetAmount, preferredUnit};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    @NotNull
    public String toString() {
        return this.presentableAmount();
    }

    private final long component1() {
        return this.bytes;
    }

    @NotNull
    public final SpaceAmount copy(long bytes) {
        return new SpaceAmount(bytes);
    }

    public static /* synthetic */ SpaceAmount copy$default(SpaceAmount spaceAmount, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = spaceAmount.bytes;
        }
        return spaceAmount.copy(l);
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpaceAmount)) {
            return false;
        }
        SpaceAmount spaceAmount = (SpaceAmount)other;
        return this.bytes == spaceAmount.bytes;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount$Companion;", "", "()V", "ONE_BYTE", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "getONE_BYTE", "()Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "ONE_GIGO_BYTE", "getONE_GIGO_BYTE", "ONE_KILO_BYTE", "getONE_KILO_BYTE", "ONE_MEGA_BYTE", "getONE_MEGA_BYTE", "ZERO_SPACE", "getZERO_SPACE", "ofBytes", "bytes", "", "ofGigabytes", "gigabytes", "ofKilobytes", "kilos", "ofMegabytes", "megabytes", "verifier-repository"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpaceAmount ofBytes(long bytes) {
            return new SpaceAmount(bytes);
        }

        @NotNull
        public final SpaceAmount ofKilobytes(long kilos) {
            return new SpaceAmount((long)SpaceUnit.KILO_BYTE.toBytes(kilos));
        }

        @NotNull
        public final SpaceAmount ofMegabytes(long megabytes) {
            return new SpaceAmount((long)SpaceUnit.MEGA_BYTE.toBytes(megabytes));
        }

        @NotNull
        public final SpaceAmount ofGigabytes(long gigabytes) {
            return new SpaceAmount((long)SpaceUnit.GIGO_BYTE.toBytes(gigabytes));
        }

        @NotNull
        public final SpaceAmount getONE_BYTE() {
            return ONE_BYTE;
        }

        @NotNull
        public final SpaceAmount getONE_KILO_BYTE() {
            return ONE_KILO_BYTE;
        }

        @NotNull
        public final SpaceAmount getONE_MEGA_BYTE() {
            return ONE_MEGA_BYTE;
        }

        @NotNull
        public final SpaceAmount getONE_GIGO_BYTE() {
            return ONE_GIGO_BYTE;
        }

        @NotNull
        public final SpaceAmount getZERO_SPACE() {
            return ZERO_SPACE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

