/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.files;

import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmount;
import com.jetbrains.pluginverifier.repository.files.SpaceWeight;
import com.jetbrains.pluginverifier.repository.resources.ResourceInfo;
import com.jetbrains.pluginverifier.repository.resources.ResourceWeight;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/repository/files/FileInfo;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceInfo;", "Ljava/nio/file/Path;", "Lcom/jetbrains/pluginverifier/repository/files/SpaceWeight;", "file", "fileSize", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "(Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;)V", "getFile", "()Ljava/nio/file/Path;", "getFileSize", "()Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "verifier-repository"})
public final class FileInfo
extends ResourceInfo<Path, SpaceWeight> {
    @NotNull
    private final Path file;
    @NotNull
    private final SpaceAmount fileSize;

    public FileInfo(@NotNull Path file2, @NotNull SpaceAmount fileSize) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(fileSize, "fileSize");
        super(file2, (ResourceWeight)new SpaceWeight(fileSize));
        this.file = file2;
        this.fileSize = fileSize;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @NotNull
    public final SpaceAmount getFileSize() {
        return this.fileSize;
    }

    @NotNull
    public String toString() {
        return "File " + this.file + " of size " + this.fileSize;
    }

    @NotNull
    public final Path component1() {
        return this.file;
    }

    @NotNull
    public final SpaceAmount component2() {
        return this.fileSize;
    }

    @NotNull
    public final FileInfo copy(@NotNull Path file2, @NotNull SpaceAmount fileSize) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(fileSize, "fileSize");
        return new FileInfo(file2, fileSize);
    }

    public static /* synthetic */ FileInfo copy$default(FileInfo fileInfo, Path path, SpaceAmount spaceAmount, int n, Object object) {
        if ((n & 1) != 0) {
            path = fileInfo.file;
        }
        if ((n & 2) != 0) {
            spaceAmount = fileInfo.fileSize;
        }
        return fileInfo.copy(path, spaceAmount);
    }

    public int hashCode() {
        int result2 = ((Object)this.file).hashCode();
        result2 = result2 * 31 + this.fileSize.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileInfo)) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)other;
        if (!Intrinsics.areEqual(this.file, fileInfo.file)) {
            return false;
        }
        return Intrinsics.areEqual(this.fileSize, fileInfo.fileSize);
    }
}

