/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.presentation.ReferencesPresentationKt;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013R\u0014\u0010\u001b\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/IllegalMethodAccessProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "bytecodeMethodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "inaccessibleMethod", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "methodAccessModifier", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "caller", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "(Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/access/AccessType;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;)V", "getBytecodeMethodReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "getCaller", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getInaccessibleMethod", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "getMethodAccessModifier", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class IllegalMethodAccessProblem
extends CompatibilityProblem {
    @NotNull
    private final MethodReference bytecodeMethodReference;
    @NotNull
    private final MethodLocation inaccessibleMethod;
    @NotNull
    private final AccessType methodAccessModifier;
    @NotNull
    private final MethodLocation caller;
    @NotNull
    private final Instruction instruction;

    public IllegalMethodAccessProblem(@NotNull MethodReference bytecodeMethodReference, @NotNull MethodLocation inaccessibleMethod, @NotNull AccessType methodAccessModifier, @NotNull MethodLocation caller2, @NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(bytecodeMethodReference, "bytecodeMethodReference");
        Intrinsics.checkNotNullParameter(inaccessibleMethod, "inaccessibleMethod");
        Intrinsics.checkNotNullParameter((Object)methodAccessModifier, "methodAccessModifier");
        Intrinsics.checkNotNullParameter(caller2, "caller");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        this.bytecodeMethodReference = bytecodeMethodReference;
        this.inaccessibleMethod = inaccessibleMethod;
        this.methodAccessModifier = methodAccessModifier;
        this.caller = caller2;
        this.instruction = instruction;
    }

    @NotNull
    public final MethodReference getBytecodeMethodReference() {
        return this.bytecodeMethodReference;
    }

    @NotNull
    public final MethodLocation getInaccessibleMethod() {
        return this.inaccessibleMethod;
    }

    @NotNull
    public final AccessType getMethodAccessModifier() {
        return this.methodAccessModifier;
    }

    @NotNull
    public final MethodLocation getCaller() {
        return this.caller;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Illegal method invocation";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.methodAccessModifier, this.inaccessibleMethod.getElementType().getPresentableName(), this.inaccessibleMethod};
        return FormatUtilsKt.formatMessage("Illegal invocation of {0} {1} {2}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray;
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object[] objectArray2 = new Object[]{StringsKt.capitalize(this.caller.getElementType().getPresentableName()), LocationsPresentationKt.formatMethodLocation(this.caller, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.SIMPLE_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.NO_PARAMETER_NAMES), this.instruction};
        $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("{0} {1} contains an *{2}* instruction referencing ", objectArray2));
        String actualMethodPresentation = LocationsPresentationKt.formatMethodLocation(this.inaccessibleMethod, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.NO_PARAMETER_NAMES);
        if (Intrinsics.areEqual(this.bytecodeMethodReference.getHostClass().getClassName(), this.inaccessibleMethod.getHostClass().getClassName())) {
            objectArray = new Object[]{this.methodAccessModifier, this.inaccessibleMethod.getElementType().getPresentableName(), actualMethodPresentation};
            $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("a {0} {1} {2} ", objectArray));
        } else {
            objectArray = new Object[]{ReferencesPresentationKt.formatMethodReference(this.bytecodeMethodReference, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME), this.methodAccessModifier, this.inaccessibleMethod.getElementType().getPresentableName(), actualMethodPresentation};
            $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("{0} which is resolved to a {1} {2} {3} ", objectArray));
        }
        objectArray = new Object[]{LocationsPresentationKt.formatClassLocation(this.caller.getHostClass(), ClassOption.FULL_NAME, ClassGenericsSignatureOption.NO_GENERICS)};
        $this$_get_fullDescription__u24lambda_u240.append(FormatUtilsKt.formatMessage("inaccessible to a class {0}. ", objectArray));
        $this$_get_fullDescription__u24lambda_u240.append("This can lead to **IllegalAccessError** exception at runtime.");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IllegalMethodAccessProblem && this.methodAccessModifier == ((IllegalMethodAccessProblem)other).methodAccessModifier && Intrinsics.areEqual(this.inaccessibleMethod, ((IllegalMethodAccessProblem)other).inaccessibleMethod) && Intrinsics.areEqual(this.caller, ((IllegalMethodAccessProblem)other).caller) && this.instruction == ((IllegalMethodAccessProblem)other).instruction;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.methodAccessModifier, this.inaccessibleMethod, this.caller, this.instruction};
        return Objects.hash(objectArray);
    }
}

