/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.hierarchy.ClassHierarchy;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.HierarchicalProblemsDescription;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.presentation.ReferencesPresentationKt;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/MethodNotFoundProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "unresolvedMethod", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "caller", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "methodOwnerHierarchy", "Lcom/jetbrains/pluginverifier/results/hierarchy/ClassHierarchy;", "(Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;Lcom/jetbrains/pluginverifier/results/hierarchy/ClassHierarchy;)V", "getCaller", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "descriptionMainPart", "", "getDescriptionMainPart", "()Ljava/lang/String;", "fullDescription", "getFullDescription", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "isCritical", "", "()Z", "getMethodOwnerHierarchy", "()Lcom/jetbrains/pluginverifier/results/hierarchy/ClassHierarchy;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUnresolvedMethod", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "equals", "other", "", "hashCode", "", "verifier-core"})
public final class MethodNotFoundProblem
extends CompatibilityProblem {
    @NotNull
    private final MethodReference unresolvedMethod;
    @NotNull
    private final MethodLocation caller;
    @NotNull
    private final Instruction instruction;
    @NotNull
    private final ClassHierarchy methodOwnerHierarchy;
    private final boolean isCritical;

    public MethodNotFoundProblem(@NotNull MethodReference unresolvedMethod, @NotNull MethodLocation caller2, @NotNull Instruction instruction, @NotNull ClassHierarchy methodOwnerHierarchy) {
        Intrinsics.checkNotNullParameter(unresolvedMethod, "unresolvedMethod");
        Intrinsics.checkNotNullParameter(caller2, "caller");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        Intrinsics.checkNotNullParameter(methodOwnerHierarchy, "methodOwnerHierarchy");
        this.unresolvedMethod = unresolvedMethod;
        this.caller = caller2;
        this.instruction = instruction;
        this.methodOwnerHierarchy = methodOwnerHierarchy;
        this.isCritical = true;
    }

    @NotNull
    public final MethodReference getUnresolvedMethod() {
        return this.unresolvedMethod;
    }

    @NotNull
    public final MethodLocation getCaller() {
        return this.caller;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @NotNull
    public final ClassHierarchy getMethodOwnerHierarchy() {
        return this.methodOwnerHierarchy;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Method not found";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{ReferencesPresentationKt.getMethodOrConstructorWord(this.unresolvedMethod), ReferencesPresentationKt.formatMethodReference(this.unresolvedMethod, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.SIMPLE_RETURN_TYPE_CLASS_NAME)};
        return FormatUtilsKt.formatMessage("Invocation of unresolved {0} {1}", objectArray);
    }

    private final String getDescriptionMainPart() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_descriptionMainPart__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object[] objectArray = new Object[]{LocationsPresentationKt.formatMethodLocation(this.caller, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE), this.instruction, ReferencesPresentationKt.getMethodOrConstructorWord(this.unresolvedMethod), ReferencesPresentationKt.formatMethodReference(this.unresolvedMethod, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME)};
        $this$_get_descriptionMainPart__u24lambda_u240.append(FormatUtilsKt.formatMessage(StringsKt.capitalize(this.caller.getElementType().getPresentableName()) + " {0} contains an *{1}* instruction referencing an unresolved {2} {3}. ", objectArray));
        $this$_get_descriptionMainPart__u24lambda_u240.append("This can lead to **NoSuchMethodError** exception at runtime.");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public String getFullDescription() {
        String hint;
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u241.append(this.getDescriptionMainPart());
        if (this.instruction != Instruction.INVOKE_SPECIAL && ((CharSequence)(hint = HierarchicalProblemsDescription.INSTANCE.presentableElementMightHaveBeenDeclaredInSuperTypes("method", this.methodOwnerHierarchy, true, true))).length() > 0) {
            Intrinsics.checkNotNullExpressionValue($this$_get_fullDescription__u24lambda_u241.append('\n'), "append(...)");
            $this$_get_fullDescription__u24lambda_u241.append(hint);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof MethodNotFoundProblem && Intrinsics.areEqual(this.unresolvedMethod, ((MethodNotFoundProblem)other).unresolvedMethod) && Intrinsics.areEqual(this.caller, ((MethodNotFoundProblem)other).caller) && this.instruction == ((MethodNotFoundProblem)other).instruction;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.unresolvedMethod, this.caller, this.instruction};
        return Objects.hash(objectArray);
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }
}

