/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.ClassGenericsSignatureOption;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/OverridingFinalMethodProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "finalMethod", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "invalidClass", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "(Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/location/ClassLocation;)V", "getFinalMethod", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getInvalidClass", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class OverridingFinalMethodProblem
extends CompatibilityProblem {
    @NotNull
    private final MethodLocation finalMethod;
    @NotNull
    private final ClassLocation invalidClass;

    public OverridingFinalMethodProblem(@NotNull MethodLocation finalMethod, @NotNull ClassLocation invalidClass) {
        Intrinsics.checkNotNullParameter(finalMethod, "finalMethod");
        Intrinsics.checkNotNullParameter(invalidClass, "invalidClass");
        this.finalMethod = finalMethod;
        this.invalidClass = invalidClass;
    }

    @NotNull
    public final MethodLocation getFinalMethod() {
        return this.finalMethod;
    }

    @NotNull
    public final ClassLocation getInvalidClass() {
        return this.invalidClass;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Final method is overridden";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Overriding a final method " + LocationsPresentationKt.formatMethodLocation(this.finalMethod, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.SIMPLE_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        return "Class " + LocationsPresentationKt.formatClassLocation(this.invalidClass, ClassOption.FULL_NAME, ClassGenericsSignatureOption.WITH_GENERICS) + " overrides the final method " + LocationsPresentationKt.formatMethodLocation(this.finalMethod, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE) + ". This can lead to **VerifyError** exception at runtime.";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof OverridingFinalMethodProblem && Intrinsics.areEqual(this.finalMethod, ((OverridingFinalMethodProblem)other).finalMethod) && Intrinsics.areEqual(this.invalidClass, ((OverridingFinalMethodProblem)other).invalidClass);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.finalMethod, this.invalidClass};
        return Objects.hash(objectArray);
    }
}

