/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import android.annotation.TargetApi;
import android.os.Build;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.annotation.Nullable;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import retrofit2.DefaultMethodSupport;

class Reflection {
    Reflection() {
    }

    boolean isDefaultMethod(Method method) {
        return false;
    }

    @Nullable
    Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object proxy, @Nullable Object[] args2) throws Throwable {
        throw new AssertionError();
    }

    String describeMethodParameter(Method method, int index) {
        return "parameter #" + (index + 1);
    }

    @TargetApi(value=24)
    @IgnoreJRERequirement
    static final class Android24
    extends Reflection {
        Android24() {
        }

        @Override
        boolean isDefaultMethod(Method method) {
            return method.isDefault();
        }

        @Override
        Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object proxy, @Nullable Object[] args2) throws Throwable {
            if (Build.VERSION.SDK_INT < 26) {
                throw new UnsupportedOperationException("Calling default methods on API 24 and 25 is not supported");
            }
            return DefaultMethodSupport.invoke(method, declaringClass, proxy, args2);
        }
    }

    @IgnoreJRERequirement
    static class Java8
    extends Reflection {
        Java8() {
        }

        @Override
        boolean isDefaultMethod(Method method) {
            return method.isDefault();
        }

        @Override
        Object invokeDefaultMethod(Method method, Class<?> declaringClass, Object proxy, @Nullable Object[] args2) throws Throwable {
            return DefaultMethodSupport.invoke(method, declaringClass, proxy, args2);
        }

        @Override
        String describeMethodParameter(Method method, int index) {
            Parameter parameter = method.getParameters()[index];
            if (parameter.isNamePresent()) {
                return "parameter '" + parameter.getName() + '\'';
            }
            return super.describeMethodParameter(method, index);
        }
    }
}

