/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.charseq;

import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0096\u0002J\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/charseq/CharReplacingCharSequence;", "", "characters", "oldChar", "", "replacement", "(Ljava/lang/CharSequence;CC)V", "length", "", "getLength", "()I", "get", "index", "subSequence", "startIndex", "endIndex", "toString", "", "structure-base"})
public final class CharReplacingCharSequence
implements CharSequence {
    private final CharSequence characters;
    private final char oldChar;
    private final char replacement;

    public int getLength() {
        return this.characters.length();
    }

    public char get(int index) {
        char c = this.characters.charAt(index);
        if (this.oldChar == this.replacement) {
            return c;
        }
        return c == this.oldChar ? this.replacement : c;
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        CharSequence subSequence = this.characters.subSequence(startIndex, endIndex);
        if (this.oldChar == this.replacement) {
            return subSequence;
        }
        return new CharReplacingCharSequence(subSequence, this.oldChar, this.replacement);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toString() {
        if (this.oldChar == this.replacement) {
            return ((Object)this.characters).toString();
        }
        CharBuffer newBuf = CharBuffer.allocate(this.characters.length());
        int n = 0;
        int n2 = this.characters.length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                newBuf.put((int)i, this.charAt((int)i));
                if (i == n2) break;
                ++i;
            }
        }
        String string = newBuf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "newBuf.toString()");
        return string;
    }

    public CharReplacingCharSequence(@NotNull CharSequence characters, char oldChar, char replacement) {
        Intrinsics.checkNotNullParameter(characters, "characters");
        this.characters = characters;
        this.oldChar = oldChar;
        this.replacement = replacement;
    }
}

