/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.InvalidClassFileException;
import com.jetbrains.plugin.structure.classes.resolvers.NamedResolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.utils.AsmUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\n\u0010\u001f\u001a\u00060 j\u0002`!2\u0006\u0010\"\u001a\u00020\tH\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003H\u0014J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001e\u001a\u00020\tH$J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020*0$2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0016R$\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00140\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/AbstractJarResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/NamedResolver;", "jarPath", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "name", "", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;Ljava/lang/String;)V", "bundleNames", "", "", "getBundleNames", "()Ljava/util/Map;", "getFileOrigin", "()Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "implementedServiceProviders", "", "", "getImplementedServiceProviders", "getJarPath", "()Ljava/nio/file/Path;", "logger", "Lorg/slf4j/Logger;", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "failedToRead", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult$FailedToRead;", "bundleResourceName", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "reason", "readClass", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "className", "", "classPath", "readPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "resolveExactPropertyResourceBundle", "baseName", "locale", "Ljava/util/Locale;", "structure-classes"})
public abstract class AbstractJarResolver
extends NamedResolver {
    private final Logger logger;
    @NotNull
    private final Path jarPath;
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final FileOrigin fileOrigin;

    @NotNull
    protected abstract Map<String, Set<String>> getBundleNames();

    @NotNull
    public abstract Map<String, Set<String>> getImplementedServiceProviders();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ResolutionResult<ClassNode> readClass(@NotNull CharSequence className, @NotNull Path classPath) {
        ResolutionResult resolutionResult;
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(classPath, "classPath");
        try {
            ClassNode classNode;
            Closeable closeable = FileUtilKt.inputStream(classPath);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                ClassNode classNode2 = AsmUtil.readClassNode(className, it, this.getReadMode() == Resolver.ReadMode.FULL);
                classNode = classNode2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Intrinsics.checkNotNullExpressionValue(classNode, "classPath.inputStream().\u2026== ReadMode.FULL)\n      }");
            ClassNode classNode3 = classNode;
            resolutionResult = new ResolutionResult.Found<ClassNode>(classNode3, this.getFileOrigin());
        }
        catch (InvalidClassFileException e) {
            resolutionResult = new ResolutionResult.Invalid(e.getMessage());
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
            resolutionResult = new ResolutionResult.FailedToRead(string);
        }
        return resolutionResult;
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        ResolutionResult resolutionResult;
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        Map<String, Set<String>> map = this.getBundleNames();
        if (!map.containsKey(baseName)) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        String string = control.toBundleName(baseName, locale);
        Intrinsics.checkNotNullExpressionValue(string, "control.toBundleName(baseName, locale)");
        String bundleName = string;
        String string2 = control.toResourceName(bundleName, "properties");
        Intrinsics.checkNotNullExpressionValue(string2, "control.toResourceName(bundleName, \"properties\")");
        String resourceName = string2;
        try {
            PropertyResourceBundle propertyResourceBundle = this.readPropertyResourceBundle(resourceName);
            if (propertyResourceBundle == null) {
                return ResolutionResult.NotFound.INSTANCE;
            }
            PropertyResourceBundle propertyResourceBundle2 = propertyResourceBundle;
            return new ResolutionResult.Found<PropertyResourceBundle>(propertyResourceBundle2, this.getFileOrigin());
        }
        catch (IOException e) {
            resolutionResult = this.failedToRead(resourceName, e, "I/O error");
        }
        catch (NullPointerException e) {
            resolutionResult = this.failedToRead(resourceName, e, "Stream is null");
        }
        catch (IllegalArgumentException e) {
            resolutionResult = this.failedToRead(resourceName, e, "Stream contains malformed Unicode sequences");
        }
        catch (MalformedInputException e) {
            resolutionResult = this.failedToRead(resourceName, e, "Stream contains an invalid UTF-8 sequence");
        }
        catch (UnmappableCharacterException e) {
            resolutionResult = this.failedToRead(resourceName, e, "Stream contains an unmappable UTF-8 sequence");
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            String string3 = e.getMessage();
            if (string3 == null) {
                string3 = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue(string3, "e.message ?: e.javaClass.name");
            resolutionResult = new ResolutionResult.Invalid(string3);
        }
        return resolutionResult;
    }

    @Nullable
    protected abstract PropertyResourceBundle readPropertyResourceBundle(@NotNull String var1);

    private final ResolutionResult.FailedToRead failedToRead(String bundleResourceName, Exception e, String reason) {
        this.logger.debug("Cannot read resource bundle '{}'. {}: {}", bundleResourceName, reason, e.getMessage(), e);
        String string = e.getMessage();
        if (string == null) {
            string = e.getClass().getName();
        }
        Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
        return new ResolutionResult.FailedToRead(string);
    }

    @NotNull
    protected Path getJarPath() {
        return this.jarPath;
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    @NotNull
    protected FileOrigin getFileOrigin() {
        return this.fileOrigin;
    }

    public AbstractJarResolver(@NotNull Path jarPath, @NotNull Resolver.ReadMode readMode, @NotNull FileOrigin fileOrigin, @NotNull String name) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(fileOrigin, "fileOrigin");
        Intrinsics.checkNotNullParameter(name, "name");
        super(name);
        this.jarPath = jarPath;
        this.readMode = readMode;
        this.fileOrigin = fileOrigin;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue(logger, "LoggerFactory.getLogger(this::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ AbstractJarResolver(Path path, Resolver.ReadMode readMode, FileOrigin fileOrigin, String string, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            string = ((Object)path.getFileName()).toString();
        }
        this(path, readMode, fileOrigin, string);
    }
}

