/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.classes;

import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.classes.DistributionIdeResolverProvider;
import com.jetbrains.plugin.structure.ide.classes.IdeResolverConfiguration;
import com.jetbrains.plugin.structure.ide.classes.IdeResolverProvider;
import java.nio.file.Path;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator;", "", "()V", "distributionIdeResolverProvider", "Lcom/jetbrains/plugin/structure/ide/classes/DistributionIdeResolverProvider;", "createIdeResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "configuration", "Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverConfiguration;", "getCompiledIdeResolverProvider", "Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverProvider;", "idePath", "Ljava/nio/file/Path;", "tryLoadCompiledIdeResolverProvider", "structure-ide-classes"})
@SourceDebugExtension(value={"SMAP\nIdeResolverCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeResolverCreator.kt\ncom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1#2:49\n288#3,2:50\n*E\n*S KotlinDebug\n*F\n+ 1 IdeResolverCreator.kt\ncom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator\n*L\n43#1,2:50\n*E\n"})
public final class IdeResolverCreator {
    private static final DistributionIdeResolverProvider distributionIdeResolverProvider;
    @NotNull
    public static final IdeResolverCreator INSTANCE;

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Ide ide2) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        return IdeResolverCreator.createIdeResolver(Resolver.ReadMode.FULL, ide2);
    }

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Resolver.ReadMode readMode, @NotNull Ide ide2) {
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(ide2, "ide");
        return IdeResolverCreator.createIdeResolver(ide2, new IdeResolverConfiguration(readMode, null, false, false, 14, null));
    }

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Ide ide2, @NotNull IdeResolverConfiguration configuration) throws InvalidIdeException {
        IdeResolverProvider ideResolverProvider;
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Path path = ide2.getIdePath();
        Intrinsics.checkNotNullExpressionValue(path, "ide.idePath");
        Path idePath = path;
        IdeResolverProvider compiledIdeResolverProvider = INSTANCE.getCompiledIdeResolverProvider(idePath);
        if (compiledIdeResolverProvider != null) {
            ideResolverProvider = compiledIdeResolverProvider;
        } else if (distributionIdeResolverProvider.supports(idePath)) {
            ideResolverProvider = distributionIdeResolverProvider;
        } else {
            throw (Throwable)new InvalidIdeException(idePath, "Invalid IDE " + ide2 + " at " + idePath);
        }
        IdeResolverProvider resolverProvider = ideResolverProvider;
        return resolverProvider.getIdeResolver(ide2, configuration);
    }

    private final IdeResolverProvider getCompiledIdeResolverProvider(Path idePath) {
        IdeResolverProvider ideResolverProvider;
        IdeResolverProvider ideResolverProvider2 = this.tryLoadCompiledIdeResolverProvider();
        if (ideResolverProvider2 != null) {
            IdeResolverProvider ideResolverProvider3;
            IdeResolverProvider it = ideResolverProvider3 = ideResolverProvider2;
            boolean bl = false;
            ideResolverProvider = it.supports(idePath) ? ideResolverProvider3 : null;
        } else {
            ideResolverProvider = null;
        }
        return ideResolverProvider;
    }

    private final IdeResolverProvider tryLoadCompiledIdeResolverProvider() {
        Object v1;
        block1: {
            ServiceLoader<IdeResolverProvider> ideManagerLoader;
            ServiceLoader<IdeResolverProvider> serviceLoader = ideManagerLoader = ServiceLoader.load(IdeResolverProvider.class);
            Intrinsics.checkNotNullExpressionValue(serviceLoader, "ideManagerLoader");
            Iterable $this$firstOrNull$iv = serviceLoader;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdeResolverProvider it = (IdeResolverProvider)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getClass().getName(), "com.jetbrains.plugin.structure.ide.jps.CompiledIdeResolverProvider")) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private IdeResolverCreator() {
    }

    static {
        IdeResolverCreator ideResolverCreator;
        INSTANCE = ideResolverCreator = new IdeResolverCreator();
        distributionIdeResolverProvider = new DistributionIdeResolverProvider();
    }
}

