/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.resolver;

import com.jetbrains.plugin.structure.ide.layout.IdeRelativePath;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponents;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponentsProvider;
import com.jetbrains.plugin.structure.ide.layout.MissingClasspathFileInLayoutComponentException;
import com.jetbrains.plugin.structure.ide.layout.MissingLayoutFileMode;
import com.jetbrains.plugin.structure.ide.layout.ResolvedLayoutComponent;
import com.jetbrains.plugin.structure.ide.problem.IdeProblem;
import com.jetbrains.plugin.structure.ide.problem.LayoutComponentHasNonExistentClasspath;
import com.jetbrains.plugin.structure.ide.resolver.ValidatingLayoutComponentsProvider;
import com.jetbrains.plugin.structure.ide.resolver.ValidatingLayoutComponentsProviderKt;
import com.jetbrains.plugin.structure.intellij.platform.LayoutComponent;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider;", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponentsProvider;", "missingLayoutFileMode", "Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;", "(Lcom/jetbrains/plugin/structure/ide/layout/MissingLayoutFileMode;)V", "logUnavailableClasspath", "", "invalidLayoutComponents", "", "Lcom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider$InvalidLayoutComponent;", "resolveLayoutComponents", "Lcom/jetbrains/plugin/structure/ide/layout/LayoutComponents;", "productInfo", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "idePath", "Ljava/nio/file/Path;", "getIdeProblems", "Lcom/jetbrains/plugin/structure/ide/problem/IdeProblem;", "Lcom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider$ValidatedLayoutComponents;", "partitionToSuccessesAndFailures", "InvalidLayoutComponent", "ValidatedLayoutComponents", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nValidatingLayoutComponentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidatingLayoutComponentsProvider.kt\ncom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1855#2:110\n819#2:111\n847#2,2:112\n1856#2:114\n1549#2:115\n1620#2,3:116\n*E\n*S KotlinDebug\n*F\n+ 1 ValidatingLayoutComponentsProvider.kt\ncom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider\n*L\n52#1:110\n53#1:111\n53#1,2:112\n52#1:114\n64#1:115\n64#1,3:116\n*E\n"})
public final class ValidatingLayoutComponentsProvider
implements LayoutComponentsProvider {
    private final MissingLayoutFileMode missingLayoutFileMode;

    @Override
    @NotNull
    public LayoutComponents resolveLayoutComponents(@NotNull ProductInfo productInfo, @NotNull Path idePath) throws MissingClasspathFileInLayoutComponentException {
        LayoutComponents layoutComponents;
        Intrinsics.checkNotNullParameter(productInfo, "productInfo");
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        LayoutComponents layoutComponents2 = LayoutComponents.Companion.of(idePath, productInfo);
        if (this.missingLayoutFileMode == MissingLayoutFileMode.IGNORE) {
            layoutComponents = layoutComponents2;
        } else {
            ValidatedLayoutComponents validatedComponents = this.partitionToSuccessesAndFailures(layoutComponents2);
            List acceptedComponents = new ArrayList();
            List ideProblems = new ArrayList();
            if (validatedComponents.hasFailures()) {
                Collection collection = ideProblems;
                Iterable iterable = this.getIdeProblems(validatedComponents);
                CollectionsKt.addAll(collection, iterable);
                if (this.missingLayoutFileMode == MissingLayoutFileMode.FAIL) {
                    throw (Throwable)MissingClasspathFileInLayoutComponentException.Companion.of(idePath, validatedComponents.getFailedComponents());
                }
                if (this.missingLayoutFileMode == MissingLayoutFileMode.SKIP_CLASSPATH) {
                    collection = acceptedComponents;
                    iterable = validatedComponents.skipMissingClasspathElements();
                    CollectionsKt.addAll(collection, iterable);
                }
                this.logUnavailableClasspath(validatedComponents.getFailures());
            }
            layoutComponents = new LayoutComponents(CollectionsKt.plus((Collection)validatedComponents.getSuccesses(), (Iterable)acceptedComponents), ideProblems);
        }
        return layoutComponents;
    }

    /*
     * WARNING - void declaration
     */
    private final ValidatedLayoutComponents partitionToSuccessesAndFailures(LayoutComponents $this$partitionToSuccessesAndFailures) {
        List okComponents = new ArrayList();
        List failedComponents = new ArrayList();
        Iterable $this$forEach$iv = $this$partitionToSuccessesAndFailures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection collection;
            void $this$filterNotTo$iv$iv;
            ResolvedLayoutComponent component = (ResolvedLayoutComponent)element$iv;
            boolean bl = false;
            Iterable $this$filterNot$iv = component.resolveClasspaths();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                IdeRelativePath it = (IdeRelativePath)element$iv$iv;
                boolean bl2 = false;
                if (it.getExists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List missingPaths = (List)destination$iv$iv;
            if (missingPaths.isEmpty()) {
                collection = okComponents;
                collection.add(component);
                continue;
            }
            collection = failedComponents;
            InvalidLayoutComponent invalidLayoutComponent = new InvalidLayoutComponent(component, missingPaths);
            collection.add(invalidLayoutComponent);
        }
        return new ValidatedLayoutComponents(okComponents, failedComponents);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IdeProblem> getIdeProblems(ValidatedLayoutComponents $this$getIdeProblems) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$getIdeProblems.getFailures();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InvalidLayoutComponent invalidLayoutComponent = (InvalidLayoutComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LayoutComponentHasNonExistentClasspath layoutComponentHasNonExistentClasspath = new LayoutComponentHasNonExistentClasspath(it.getComponent().getName(), it.getMissingClasspaths());
            collection.add(layoutComponentHasNonExistentClasspath);
        }
        return (List)destination$iv$iv;
    }

    private final void logUnavailableClasspath(List<InvalidLayoutComponent> invalidLayoutComponents) {
        if (this.missingLayoutFileMode == MissingLayoutFileMode.SKIP_SILENTLY || !ValidatingLayoutComponentsProviderKt.access$getLOG$p().isWarnEnabled()) {
            return;
        }
        String logMsg2 = CollectionsKt.joinToString$default(invalidLayoutComponents, "\n", null, null, 0, null, logUnavailableClasspath.logMsg.1.INSTANCE, 30, null);
        ValidatingLayoutComponentsProviderKt.access$getLOG$p().warn(logMsg2);
    }

    public ValidatingLayoutComponentsProvider(@NotNull MissingLayoutFileMode missingLayoutFileMode) {
        Intrinsics.checkNotNullParameter((Object)missingLayoutFileMode, "missingLayoutFileMode");
        this.missingLayoutFileMode = missingLayoutFileMode;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider$InvalidLayoutComponent;", "", "component", "Lcom/jetbrains/plugin/structure/ide/layout/ResolvedLayoutComponent;", "missingClasspaths", "", "Lcom/jetbrains/plugin/structure/ide/layout/IdeRelativePath;", "(Lcom/jetbrains/plugin/structure/ide/layout/ResolvedLayoutComponent;Ljava/util/List;)V", "getComponent", "()Lcom/jetbrains/plugin/structure/ide/layout/ResolvedLayoutComponent;", "getMissingClasspaths", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "structure-ide"})
    private static final class InvalidLayoutComponent {
        @NotNull
        private final ResolvedLayoutComponent component;
        @NotNull
        private final List<IdeRelativePath> missingClasspaths;

        @NotNull
        public final ResolvedLayoutComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final List<IdeRelativePath> getMissingClasspaths() {
            return this.missingClasspaths;
        }

        public InvalidLayoutComponent(@NotNull ResolvedLayoutComponent component, @NotNull List<IdeRelativePath> missingClasspaths) {
            Intrinsics.checkNotNullParameter(component, "component");
            Intrinsics.checkNotNullParameter(missingClasspaths, "missingClasspaths");
            this.component = component;
            this.missingClasspaths = missingClasspaths;
        }

        @NotNull
        public final ResolvedLayoutComponent component1() {
            return this.component;
        }

        @NotNull
        public final List<IdeRelativePath> component2() {
            return this.missingClasspaths;
        }

        @NotNull
        public final InvalidLayoutComponent copy(@NotNull ResolvedLayoutComponent component, @NotNull List<IdeRelativePath> missingClasspaths) {
            Intrinsics.checkNotNullParameter(component, "component");
            Intrinsics.checkNotNullParameter(missingClasspaths, "missingClasspaths");
            return new InvalidLayoutComponent(component, missingClasspaths);
        }

        public static /* synthetic */ InvalidLayoutComponent copy$default(InvalidLayoutComponent invalidLayoutComponent, ResolvedLayoutComponent resolvedLayoutComponent, List list, int n, Object object) {
            if ((n & 1) != 0) {
                resolvedLayoutComponent = invalidLayoutComponent.component;
            }
            if ((n & 2) != 0) {
                list = invalidLayoutComponent.missingClasspaths;
            }
            return invalidLayoutComponent.copy(resolvedLayoutComponent, list);
        }

        @NotNull
        public String toString() {
            return "InvalidLayoutComponent(component=" + this.component + ", missingClasspaths=" + this.missingClasspaths + ")";
        }

        public int hashCode() {
            ResolvedLayoutComponent resolvedLayoutComponent = this.component;
            List<IdeRelativePath> list = this.missingClasspaths;
            return (resolvedLayoutComponent != null ? ((Object)resolvedLayoutComponent).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof InvalidLayoutComponent)) break block3;
                    InvalidLayoutComponent invalidLayoutComponent = (InvalidLayoutComponent)object;
                    if (!Intrinsics.areEqual(this.component, invalidLayoutComponent.component) || !Intrinsics.areEqual(this.missingClasspaths, invalidLayoutComponent.missingClasspaths)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0017\u001a\u00020\u0015J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\t\u0010\u001b\u001a\u00020\u000eH\u00d6\u0001J\f\u0010\u001a\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider$ValidatedLayoutComponents;", "", "successes", "", "Lcom/jetbrains/plugin/structure/ide/layout/ResolvedLayoutComponent;", "failures", "Lcom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider$InvalidLayoutComponent;", "(Ljava/util/List;Ljava/util/List;)V", "failedComponents", "getFailedComponents", "()Ljava/util/List;", "getFailures", "getSuccesses", "existingClasspaths", "", "getExistingClasspaths", "(Lcom/jetbrains/plugin/structure/ide/layout/ResolvedLayoutComponent;)Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hasFailures", "hashCode", "", "skipMissingClasspathElements", "toString", "structure-ide"})
    @SourceDebugExtension(value={"SMAP\nValidatingLayoutComponentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidatingLayoutComponentsProvider.kt\ncom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider$ValidatedLayoutComponents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1549#2:110\n1620#2,3:111\n1549#2:114\n1620#2,3:115\n766#2:118\n857#2,2:119\n1549#2:121\n1620#2,3:122\n*E\n*S KotlinDebug\n*F\n+ 1 ValidatingLayoutComponentsProvider.kt\ncom/jetbrains/plugin/structure/ide/resolver/ValidatingLayoutComponentsProvider$ValidatedLayoutComponents\n*L\n86#1:110\n86#1,3:111\n91#1:114\n91#1,3:115\n106#1:118\n106#1,2:119\n107#1:121\n107#1,3:122\n*E\n"})
    private static final class ValidatedLayoutComponents {
        @NotNull
        private final List<ResolvedLayoutComponent> successes;
        @NotNull
        private final List<InvalidLayoutComponent> failures;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ResolvedLayoutComponent> getFailedComponents() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.failures;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InvalidLayoutComponent invalidLayoutComponent = (InvalidLayoutComponent)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ResolvedLayoutComponent resolvedLayoutComponent = it.getComponent();
                collection.add(resolvedLayoutComponent);
            }
            return (List)destination$iv$iv;
        }

        public final boolean hasFailures() {
            Collection collection = this.failures;
            return !collection.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ResolvedLayoutComponent> skipMissingClasspathElements() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getFailedComponents();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResolvedLayoutComponent resolvedLayoutComponent = (ResolvedLayoutComponent)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ResolvedLayoutComponent resolvedLayoutComponent2 = this.skipMissingClasspathElements((ResolvedLayoutComponent)it);
                collection.add(resolvedLayoutComponent2);
            }
            return (List)destination$iv$iv;
        }

        private final ResolvedLayoutComponent skipMissingClasspathElements(ResolvedLayoutComponent $this$skipMissingClasspathElements) {
            LayoutComponent layoutComponent;
            LayoutComponent layoutComponent2;
            LayoutComponent $this$with = layoutComponent2 = $this$skipMissingClasspathElements.getLayoutComponent();
            boolean bl = false;
            LayoutComponent layoutComponent3 = $this$with;
            if (layoutComponent3 instanceof LayoutComponent.ModuleV2) {
                layoutComponent = LayoutComponent.ModuleV2.copy$default((LayoutComponent.ModuleV2)$this$with, null, this.getExistingClasspaths($this$skipMissingClasspathElements), 1, null);
            } else if (layoutComponent3 instanceof LayoutComponent.Plugin) {
                layoutComponent = LayoutComponent.Plugin.copy$default((LayoutComponent.Plugin)$this$with, null, this.getExistingClasspaths($this$skipMissingClasspathElements), 1, null);
            } else if (layoutComponent3 instanceof LayoutComponent.ProductModuleV2) {
                layoutComponent = LayoutComponent.ProductModuleV2.copy$default((LayoutComponent.ProductModuleV2)$this$with, null, this.getExistingClasspaths($this$skipMissingClasspathElements), 1, null);
            } else if (layoutComponent3 instanceof LayoutComponent.PluginAlias) {
                layoutComponent = $this$with;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LayoutComponent it = layoutComponent2 = layoutComponent;
            boolean bl2 = false;
            return new ResolvedLayoutComponent($this$skipMissingClasspathElements.getIdePath(), it);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getExistingClasspaths(ResolvedLayoutComponent $this$existingClasspaths) {
            void $this$mapTo$iv$iv;
            IdeRelativePath it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$existingClasspaths.resolveClasspaths();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IdeRelativePath)element$iv$iv;
                boolean bl = false;
                if (!it.getExists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IdeRelativePath)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = ((Object)it.getRelativePath()).toString();
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<ResolvedLayoutComponent> getSuccesses() {
            return this.successes;
        }

        @NotNull
        public final List<InvalidLayoutComponent> getFailures() {
            return this.failures;
        }

        public ValidatedLayoutComponents(@NotNull List<ResolvedLayoutComponent> successes, @NotNull List<InvalidLayoutComponent> failures) {
            Intrinsics.checkNotNullParameter(successes, "successes");
            Intrinsics.checkNotNullParameter(failures, "failures");
            this.successes = successes;
            this.failures = failures;
        }

        @NotNull
        public final List<ResolvedLayoutComponent> component1() {
            return this.successes;
        }

        @NotNull
        public final List<InvalidLayoutComponent> component2() {
            return this.failures;
        }

        @NotNull
        public final ValidatedLayoutComponents copy(@NotNull List<ResolvedLayoutComponent> successes, @NotNull List<InvalidLayoutComponent> failures) {
            Intrinsics.checkNotNullParameter(successes, "successes");
            Intrinsics.checkNotNullParameter(failures, "failures");
            return new ValidatedLayoutComponents(successes, failures);
        }

        public static /* synthetic */ ValidatedLayoutComponents copy$default(ValidatedLayoutComponents validatedLayoutComponents, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = validatedLayoutComponents.successes;
            }
            if ((n & 2) != 0) {
                list2 = validatedLayoutComponents.failures;
            }
            return validatedLayoutComponents.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "ValidatedLayoutComponents(successes=" + this.successes + ", failures=" + this.failures + ")";
        }

        public int hashCode() {
            List<ResolvedLayoutComponent> list = this.successes;
            List<InvalidLayoutComponent> list2 = this.failures;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ValidatedLayoutComponents)) break block3;
                    ValidatedLayoutComponents validatedLayoutComponents = (ValidatedLayoutComponents)object;
                    if (!Intrinsics.areEqual(this.successes, validatedLayoutComponents.successes) || !Intrinsics.areEqual(this.failures, validatedLayoutComponents.failures)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

