/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.locator;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.DirectoryResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.ClassesLocator;
import com.jetbrains.plugin.structure.intellij.classes.locator.FileOriginProvider;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibDirectoryOriginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator;", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/ClassesLocator;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOriginProvider", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/FileOriginProvider;", "libDirectoryFilter", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator$LibDirectoryFilter;", "(Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/intellij/classes/locator/FileOriginProvider;Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator$LibDirectoryFilter;)V", "locationKey", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryKey;", "getLocationKey", "()Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryKey;", "findClasses", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginFile", "Ljava/nio/file/Path;", "AnyLibDirectoryFilter", "LibDirectoryFilter", "structure-intellij-classes"})
@SourceDebugExtension(value={"SMAP\nLibDirectoryLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibDirectoryLocator.kt\ncom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,60:1\n766#2:61\n857#2,2:62\n766#2:64\n857#2,2:65\n766#2:67\n857#2,2:68\n1855#2,2:74\n79#3,4:70\n83#3:76\n*E\n*S KotlinDebug\n*F\n+ 1 LibDirectoryLocator.kt\ncom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator\n*L\n31#1:61\n31#1,2:62\n33#1:64\n33#1,2:65\n34#1:67\n34#1,2:68\n35#1,2:74\n35#1,4:70\n35#1:76\n*E\n"})
public final class LibDirectoryLocator
implements ClassesLocator {
    @NotNull
    private final LibDirectoryKey locationKey;
    private final Resolver.ReadMode readMode;
    private final FileOriginProvider fileOriginProvider;
    private final LibDirectoryFilter libDirectoryFilter;

    @Override
    @NotNull
    public LibDirectoryKey getLocationKey() {
        return this.locationKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Resolver> findClasses(@NotNull IdePlugin idePlugin, @NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        Intrinsics.checkNotNullParameter(pluginFile, "pluginFile");
        Path pluginLib = pluginFile.resolve("lib");
        ArrayList resolvers = new ArrayList();
        Path path = pluginLib;
        Intrinsics.checkNotNullExpressionValue(path, "pluginLib");
        if (FileUtilKt.isDirectory(path)) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv;
            void $this$filterTo$iv$iv3;
            FileOrigin libDirectoryOrigin = this.fileOriginProvider.getFileOrigin(idePlugin, pluginFile);
            List<Path> pluginLibChildren = FileUtilKt.listFiles(pluginLib);
            Iterable $this$filter$iv2 = pluginLibChildren;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Path file = (Path)element$iv$iv;
                boolean bl = false;
                if (!(FileUtilKt.isJar(file) || FileUtilKt.isZip(file))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List jarsOrZips = (List)destination$iv$iv;
            Iterable $i$f$filter22 = pluginLibChildren;
            boolean $i$f$filter32 = false;
            destination$iv$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Path file = (Path)element$iv$iv;
                boolean bl = false;
                if (!FileUtilKt.isDirectory(file)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            LibDirectoryFilter $i$f$filter32 = this.libDirectoryFilter;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path p1 = (Path)element$iv$iv;
                boolean bl = false;
                if (!$i$f$filter32.accept(p1)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List directories = (List)destination$iv$iv3;
            List $this$closeOnException$iv = resolvers;
            boolean $i$f$closeOnException = false;
            try {
                List it = $this$closeOnException$iv;
                boolean bl = false;
                Collection collection = resolvers;
                Iterable iterable2 = JarFileResolverKt.buildJarOrZipFileResolvers(jarsOrZips, this.readMode, libDirectoryOrigin);
                CollectionsKt.addAll(collection, iterable2);
                collection = resolvers;
                iterable2 = DirectoryResolverKt.buildDirectoriesResolvers(directories, this.readMode, libDirectoryOrigin);
                CollectionsKt.addAll(collection, iterable2);
            }
            catch (Throwable e$iv) {
                Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Closeable t$iv = (Closeable)element$iv$iv;
                    boolean bl = false;
                    Closeable closeable = t$iv;
                    if (closeable == null) continue;
                    LanguageUtilsKt.closeLogged(closeable);
                }
                throw e$iv;
            }
        }
        return resolvers;
    }

    public LibDirectoryLocator(@NotNull Resolver.ReadMode readMode, @NotNull FileOriginProvider fileOriginProvider, @NotNull LibDirectoryFilter libDirectoryFilter) {
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(fileOriginProvider, "fileOriginProvider");
        Intrinsics.checkNotNullParameter(libDirectoryFilter, "libDirectoryFilter");
        this.readMode = readMode;
        this.fileOriginProvider = fileOriginProvider;
        this.libDirectoryFilter = libDirectoryFilter;
        this.locationKey = LibDirectoryKey.INSTANCE;
    }

    public /* synthetic */ LibDirectoryLocator(Resolver.ReadMode readMode, FileOriginProvider fileOriginProvider, LibDirectoryFilter libDirectoryFilter, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            fileOriginProvider = LibDirectoryOriginProvider.INSTANCE;
        }
        if ((n & 4) != 0) {
            libDirectoryFilter = AnyLibDirectoryFilter.INSTANCE;
        }
        this(readMode, fileOriginProvider, libDirectoryFilter);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator$LibDirectoryFilter;", "", "accept", "", "file", "Ljava/nio/file/Path;", "structure-intellij-classes"})
    public static interface LibDirectoryFilter {
        public boolean accept(@NotNull Path var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator$AnyLibDirectoryFilter;", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator$LibDirectoryFilter;", "()V", "accept", "", "file", "Ljava/nio/file/Path;", "structure-intellij-classes"})
    public static final class AnyLibDirectoryFilter
    implements LibDirectoryFilter {
        @NotNull
        public static final AnyLibDirectoryFilter INSTANCE;

        @Override
        public boolean accept(@NotNull Path file) {
            Intrinsics.checkNotNullParameter(file, "file");
            return true;
        }

        private AnyLibDirectoryFilter() {
        }

        static {
            AnyLibDirectoryFilter anyLibDirectoryFilter;
            INSTANCE = anyLibDirectoryFilter = new AnyLibDirectoryFilter();
        }
    }
}

