/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvision;
import com.jetbrains.plugin.structure.intellij.plugin.PluginQuery;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFindersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinderPluginProvider;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "dependencyFinder", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "(Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;Lcom/jetbrains/plugin/structure/ide/Ide;)V", "findPluginById", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginId", "", "findPluginByModule", "moduleId", "query", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvision;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginQuery;", "verifier-intellij"})
public final class DependencyFinderPluginProvider
implements PluginProvider {
    @NotNull
    private final DependencyFinder dependencyFinder;
    @NotNull
    private final Ide ide;

    public DependencyFinderPluginProvider(@NotNull DependencyFinder dependencyFinder, @NotNull Ide ide2) {
        Intrinsics.checkNotNullParameter(dependencyFinder, "dependencyFinder");
        Intrinsics.checkNotNullParameter(ide2, "ide");
        this.dependencyFinder = dependencyFinder;
        this.ide = ide2;
    }

    @Override
    @Nullable
    public IdePlugin findPluginById(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        return DependencyFindersKt.resolvePlugin(this.dependencyFinder.findPluginDependency(pluginId, false), this.ide);
    }

    @Override
    @Nullable
    public IdePlugin findPluginByModule(@NotNull String moduleId) {
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        return DependencyFindersKt.resolvePlugin(this.dependencyFinder.findPluginDependency(moduleId, true), this.ide);
    }

    @Override
    @NotNull
    public PluginProvision query(@NotNull PluginQuery query) {
        Intrinsics.checkNotNullParameter(query, "query");
        if (query.searchId()) {
            String string = query.getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string, "query.identifier");
            IdePlugin idePlugin = this.findPluginById(string);
            if (idePlugin != null) {
                IdePlugin it = idePlugin;
                boolean bl = false;
                return new PluginProvision.Found(it, PluginProvision.Source.ID);
            }
        } else if (query.searchPluginAliases()) {
            String string = query.getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string, "query.identifier");
            IdePlugin idePlugin = this.findPluginByModule(string);
            if (idePlugin != null) {
                IdePlugin it = idePlugin;
                boolean bl = false;
                return new PluginProvision.Found(it, PluginProvision.Source.ALIAS);
            }
        } else if (query.searchContentModuleId()) {
            String string = query.getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string, "query.identifier");
            IdePlugin idePlugin = this.findPluginByModule(string);
            if (idePlugin != null) {
                IdePlugin it = idePlugin;
                boolean bl = false;
                return new PluginProvision.Found(it, PluginProvision.Source.CONTENT_MODULE_ID);
            }
        }
        return PluginProvision.NotFound.INSTANCE;
    }
}

