/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.filtering.documented;

import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblem;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemKt;
import com.jetbrains.pluginverifier.results.problems.ClassNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.problems.FieldNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.MethodNotFoundProblem;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/filtering/documented/DocClassMovedToPackage;", "Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblem;", "oldClassName", "", "newPackageName", "(Ljava/lang/String;Ljava/lang/String;)V", "getNewPackageName", "()Ljava/lang/String;", "getOldClassName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "isDocumenting", "problem", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "toString", "verifier-intellij"})
public final class DocClassMovedToPackage
implements DocumentedProblem {
    @NotNull
    private final String oldClassName;
    @NotNull
    private final String newPackageName;

    public DocClassMovedToPackage(@NotNull String oldClassName, @NotNull String newPackageName) {
        Intrinsics.checkNotNullParameter(oldClassName, "oldClassName");
        Intrinsics.checkNotNullParameter(newPackageName, "newPackageName");
        this.oldClassName = oldClassName;
        this.newPackageName = newPackageName;
    }

    @NotNull
    public final String getOldClassName() {
        return this.oldClassName;
    }

    @NotNull
    public final String getNewPackageName() {
        return this.newPackageName;
    }

    @Override
    public boolean isDocumenting(@NotNull CompatibilityProblem problem, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(problem, "problem");
        Intrinsics.checkNotNullParameter(context, "context");
        CompatibilityProblem compatibilityProblem = problem;
        return compatibilityProblem instanceof ClassNotFoundProblem ? Intrinsics.areEqual(((ClassNotFoundProblem)problem).getUnresolved().getClassName(), this.oldClassName) : (compatibilityProblem instanceof MethodNotFoundProblem ? DocumentedProblemKt.access$doesMethodDependOnClass(((MethodNotFoundProblem)problem).getUnresolvedMethod(), new Function1<String, Boolean>(this){
            final /* synthetic */ DocClassMovedToPackage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it, this.this$0.getOldClassName());
            }
        }) : (compatibilityProblem instanceof FieldNotFoundProblem ? DocumentedProblemKt.access$doesFieldDependOnClass(((FieldNotFoundProblem)problem).getUnresolvedField(), new Function1<String, Boolean>(this){
            final /* synthetic */ DocClassMovedToPackage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it, this.this$0.getOldClassName());
            }
        }) : false));
    }

    @NotNull
    public final String component1() {
        return this.oldClassName;
    }

    @NotNull
    public final String component2() {
        return this.newPackageName;
    }

    @NotNull
    public final DocClassMovedToPackage copy(@NotNull String oldClassName, @NotNull String newPackageName) {
        Intrinsics.checkNotNullParameter(oldClassName, "oldClassName");
        Intrinsics.checkNotNullParameter(newPackageName, "newPackageName");
        return new DocClassMovedToPackage(oldClassName, newPackageName);
    }

    public static /* synthetic */ DocClassMovedToPackage copy$default(DocClassMovedToPackage docClassMovedToPackage, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = docClassMovedToPackage.oldClassName;
        }
        if ((n & 2) != 0) {
            string2 = docClassMovedToPackage.newPackageName;
        }
        return docClassMovedToPackage.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "DocClassMovedToPackage(oldClassName=" + this.oldClassName + ", newPackageName=" + this.newPackageName + ")";
    }

    public int hashCode() {
        int result2 = this.oldClassName.hashCode();
        result2 = result2 * 31 + this.newPackageName.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocClassMovedToPackage)) {
            return false;
        }
        DocClassMovedToPackage docClassMovedToPackage = (DocClassMovedToPackage)other;
        if (!Intrinsics.areEqual(this.oldClassName, docClassMovedToPackage.oldClassName)) {
            return false;
        }
        return Intrinsics.areEqual(this.newPackageName, docClassMovedToPackage.newPackageName);
    }
}

