/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.clazz;

import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.MethodNotImplementedProblem;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.clazz.ClassVerifier;
import com.jetbrains.pluginverifier.verifiers.hierarchy.ClassParentsVisitor;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/clazz/AbstractMethodVerifier;", "Lcom/jetbrains/pluginverifier/verifiers/clazz/ClassVerifier;", "()V", "verify", "", "classFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "MethodSignature", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nAbstractMethodVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMethodVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/clazz/AbstractMethodVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1855#2,2:53\n*S KotlinDebug\n*F\n+ 1 AbstractMethodVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/clazz/AbstractMethodVerifier\n*L\n43#1:53,2\n*E\n"})
public final class AbstractMethodVerifier
implements ClassVerifier {
    @Override
    public void verify(@NotNull ClassFile classFile, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        Intrinsics.checkNotNullParameter(context, "context");
        if (classFile.isAbstract() || classFile.isInterface()) {
            return;
        }
        HashMap<MethodSignature, MethodLocation> abstractMethods = new HashMap<MethodSignature, MethodLocation>();
        HashMap<MethodSignature, MethodLocation> implementedMethods = new HashMap<MethodSignature, MethodLocation>();
        Ref.BooleanRef hasUnresolvedParents = new Ref.BooleanRef();
        ClassParentsVisitor parentsVisitor2 = new ClassParentsVisitor(true, (Function2<? super ClassFile, ? super String, ? extends ClassFile>)new Function2<ClassFile, String, ClassFile>(context, hasUnresolvedParents){
            final /* synthetic */ VerificationContext $context;
            final /* synthetic */ Ref.BooleanRef $hasUnresolvedParents;
            {
                this.$context = $context;
                this.$hasUnresolvedParents = $hasUnresolvedParents;
                super(2);
            }

            @Nullable
            public final ClassFile invoke(@NotNull ClassFile subclassFile, @NotNull String superName) {
                Intrinsics.checkNotNullParameter(subclassFile, "subclassFile");
                Intrinsics.checkNotNullParameter(superName, "superName");
                ClassFile parentFile = ResolutionUtilKt.resolveClassChecked$default(this.$context.getClassResolver(), superName, subclassFile, this.$context, null, 8, null);
                this.$hasUnresolvedParents.element = this.$hasUnresolvedParents.element || parentFile == null;
                return parentFile;
            }
        });
        ClassParentsVisitor.visitClass$default(parentsVisitor2, classFile, true, new Function1<ClassFile, Boolean>(abstractMethods, implementedMethods){
            final /* synthetic */ HashMap<MethodSignature, MethodLocation> $abstractMethods;
            final /* synthetic */ HashMap<MethodSignature, MethodLocation> $implementedMethods;
            {
                this.$abstractMethods = $abstractMethods;
                this.$implementedMethods = $implementedMethods;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(@NotNull ClassFile parent) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(parent, "parent");
                Sequence<Method> sequence2 = parent.getMethods();
                HashMap<MethodSignature, MethodLocation> hashMap = this.$abstractMethods;
                HashMap<MethodSignature, MethodLocation> hashMap2 = this.$implementedMethods;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Method method = (Method)element$iv;
                    boolean bl = false;
                    if (method.isPrivate() || method.isStatic()) continue;
                    MethodSignature methodSignature = new MethodSignature(method.getName(), method.getDescriptor());
                    if (method.isAbstract()) {
                        ((Map)hashMap).put(methodSignature, method.getLocation());
                        continue;
                    }
                    ((Map)hashMap2).put(methodSignature, method.getLocation());
                }
                return true;
            }
        }, null, 8, null);
        if (!hasUnresolvedParents.element) {
            Set<MethodSignature> set = abstractMethods.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "abstractMethods.keys");
            Set<MethodSignature> set2 = implementedMethods.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "implementedMethods.keys");
            Iterable $this$forEach$iv = SetsKt.minus(set, (Iterable)set2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MethodLocation abstractMethod;
                MethodSignature method = (MethodSignature)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(abstractMethods.get(method));
                context.getProblemRegistrar().registerProblem(new MethodNotImplementedProblem(abstractMethod, classFile.getLocation()));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/clazz/AbstractMethodVerifier$MethodSignature;", "", "name", "", "descriptor", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescriptor", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "verifier-core"})
    private static final class MethodSignature {
        @NotNull
        private final String name;
        @NotNull
        private final String descriptor;

        public MethodSignature(@NotNull String name, @NotNull String descriptor2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            this.name = name;
            this.descriptor = descriptor2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.descriptor;
        }

        @NotNull
        public final MethodSignature copy(@NotNull String name, @NotNull String descriptor2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            return new MethodSignature(name, descriptor2);
        }

        public static /* synthetic */ MethodSignature copy$default(MethodSignature methodSignature, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = methodSignature.name;
            }
            if ((n & 2) != 0) {
                string2 = methodSignature.descriptor;
            }
            return methodSignature.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MethodSignature(name=" + this.name + ", descriptor=" + this.descriptor + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.descriptor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodSignature)) {
                return false;
            }
            MethodSignature methodSignature = (MethodSignature)other;
            if (!Intrinsics.areEqual(this.name, methodSignature.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.descriptor, methodSignature.descriptor);
        }
    }
}

