/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.method;

import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.method.ClassFileWithNoMethodsWrapper;
import com.jetbrains.pluginverifier.verifiers.method.MethodOverridingProcessor;
import com.jetbrains.pluginverifier.verifiers.method.MethodVerifier;
import com.jetbrains.pluginverifier.verifiers.method.VerificationContextWithSilentProblemRegistrar;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/method/MethodOverridingVerifier;", "Lcom/jetbrains/pluginverifier/verifiers/method/MethodVerifier;", "methodOverridingProcessors", "", "Lcom/jetbrains/pluginverifier/verifiers/method/MethodOverridingProcessor;", "(Ljava/util/List;)V", "verify", "", "method", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verifier-core"})
public final class MethodOverridingVerifier
implements MethodVerifier {
    @NotNull
    private final List<MethodOverridingProcessor> methodOverridingProcessors;

    public MethodOverridingVerifier(@NotNull List<? extends MethodOverridingProcessor> methodOverridingProcessors) {
        Intrinsics.checkNotNullParameter(methodOverridingProcessors, "methodOverridingProcessors");
        this.methodOverridingProcessors = methodOverridingProcessors;
    }

    @Override
    public void verify(@NotNull Method method, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(context, "context");
        if (method.isStatic() || method.isPrivate() || Intrinsics.areEqual(method.getName(), "<init>") || Intrinsics.areEqual(method.getName(), "<clinit>")) {
            return;
        }
        Method overriddenMethod = new MethodResolver().resolveMethod(new ClassFileWithNoMethodsWrapper(method.getContainingClassFile()), LocationToReferenceKt.toReference(method.getLocation()), method.getContainingClassFile().isInterface() ? Instruction.INVOKE_INTERFACE : Instruction.INVOKE_VIRTUAL, method, new VerificationContextWithSilentProblemRegistrar(context));
        if (overriddenMethod != null && !Intrinsics.areEqual(method.getContainingClassFile().getName(), overriddenMethod.getContainingClassFile().getName())) {
            for (MethodOverridingProcessor processor : this.methodOverridingProcessors) {
                processor.processMethodOverriding(method, overriddenMethod, context);
            }
        }
    }
}

