/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProviderResult;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvision;
import com.jetbrains.plugin.structure.intellij.plugin.PluginQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PluginProvider {
    @Nullable
    public IdePlugin findPluginById(@NotNull String var1);

    @Nullable
    public IdePlugin findPluginByModule(@NotNull String var1);

    @Nullable
    default public PluginProviderResult findPluginByIdOrModuleId(@NotNull String pluginIdOrModuleId) {
        IdePlugin plugin = this.findPluginById(pluginIdOrModuleId);
        if (plugin != null) {
            return new PluginProviderResult(PluginProviderResult.Type.PLUGIN, plugin);
        }
        plugin = this.findPluginByModule(pluginIdOrModuleId);
        if (plugin != null) {
            return new PluginProviderResult(PluginProviderResult.Type.MODULE, plugin);
        }
        return null;
    }

    default public boolean containsPlugin(@NotNull String pluginId) {
        return this.findPluginById(pluginId) != null;
    }

    @NotNull
    public PluginProvision query(@NotNull PluginQuery var1);

    default public String getPresentableName() {
        return this.toString();
    }
}

