/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.problems.MultiplePluginDescriptors;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.Classpath;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginDirectoryLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoaderProvider;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadingContext;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleScanner;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModules;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginLibDirectoryIsEmpty;
import com.jetbrains.plugin.structure.intellij.resources.CompositeResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.JarsResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0014\u0010\u0018\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader$Context;", "pluginLoaderRegistry", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "contentModuleScanner", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner;", "directoryLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader;", "getDirectoryLoader", "()Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginDirectoryLoader;", "jarLoader", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader;", "getJarLoader", "()Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader;", "hasOnlyInvalidDescriptorErrors", "", "creator", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "loadPlugin", "pluginLoadingContext", "withResolvedClasspath", "path", "Ljava/nio/file/Path;", "Context", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nLibDirectoryPluginLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibDirectoryPluginLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader\n+ 2 PluginLoaderProvider.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoaderProvider\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n21#2:140\n21#2:141\n766#3:142\n857#3,2:143\n766#3:145\n857#3,2:146\n1726#3,3:148\n*E\n*S KotlinDebug\n*F\n+ 1 LibDirectoryPluginLoader.kt\ncom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader\n*L\n35#1:140\n38#1:141\n52#1:142\n52#1,2:143\n91#1:145\n91#1,2:146\n120#1,3:148\n*E\n"})
public final class LibDirectoryPluginLoader
implements PluginLoader<Context> {
    @NotNull
    private final PluginLoaderProvider pluginLoaderRegistry;
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;
    @NotNull
    private final ContentModuleScanner contentModuleScanner;

    public LibDirectoryPluginLoader(@NotNull PluginLoaderProvider pluginLoaderRegistry, @NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter(pluginLoaderRegistry, "pluginLoaderRegistry");
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        this.pluginLoaderRegistry = pluginLoaderRegistry;
        this.fileSystemProvider = fileSystemProvider;
        this.contentModuleScanner = new ContentModuleScanner(this.fileSystemProvider);
    }

    private final JarPluginLoader getJarLoader() {
        PluginLoaderProvider this_$iv = this.pluginLoaderRegistry;
        boolean $i$f$get$structure_intellij = false;
        PluginLoader<JarPluginLoader.Context> pluginLoader = this_$iv.get$structure_intellij(JarPluginLoader.Context.class);
        if (pluginLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoader");
        }
        return (JarPluginLoader)((PluginLoader)((JarPluginLoader)pluginLoader));
    }

    private final PluginDirectoryLoader getDirectoryLoader() {
        PluginLoaderProvider this_$iv = this.pluginLoaderRegistry;
        boolean $i$f$get$structure_intellij = false;
        PluginLoader<PluginDirectoryLoader.Context> pluginLoader = this_$iv.get$structure_intellij(PluginDirectoryLoader.Context.class);
        if (pluginLoader == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginDirectoryLoader");
        }
        return (PluginDirectoryLoader)((PluginLoader)((PluginDirectoryLoader)pluginLoader));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PluginCreator loadPlugin(@NotNull Context pluginLoadingContext) {
        PluginCreator pluginCreator;
        void $this$filter$iv;
        ResourceResolver[] $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(pluginLoadingContext, "pluginLoadingContext");
        Context $this$loadPlugin_u24lambda_u242 = pluginLoadingContext;
        boolean bl = false;
        Path libDir = $this$loadPlugin_u24lambda_u242.getLibDirectoryParent().resolve("lib");
        Path path = $this$loadPlugin_u24lambda_u242.getLibDirectoryParent().resolve("dotnet");
        Intrinsics.checkNotNullExpressionValue(path, "libDirectoryParent.resolve(\"dotnet\")");
        boolean hasDotNetDirectory = FileUtilKt.exists(path);
        Intrinsics.checkNotNullExpressionValue(libDir, "libDir");
        if (!FileUtilKt.isDirectory(libDir)) {
            return PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u242.getLibDirectoryParent(), $this$loadPlugin_u24lambda_u242.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$loadPlugin_u24lambda_u242.getDescriptorPath()));
        }
        List<Path> files = FileUtilKt.listFiles(libDir);
        if (files.isEmpty()) {
            return PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u242.getLibDirectoryParent(), $this$loadPlugin_u24lambda_u242.getDescriptorPath(), (PluginProblem)new PluginLibDirectoryIsEmpty());
        }
        Iterable $this$filter$iv2 = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t2 : $this$filterTo$iv$iv2) {
            Path it = (Path)t2;
            boolean bl2 = false;
            if (!FileUtilKt.isJar(it)) continue;
            destination$iv$iv.add(t2);
        }
        List jarFiles = (List)destination$iv$iv;
        ResourceResolver libResourceResolver = new JarsResourceResolver(jarFiles, this.fileSystemProvider);
        $this$filterTo$iv$iv2 = new ResourceResolver[]{libResourceResolver, $this$loadPlugin_u24lambda_u242.getResourceResolver()};
        ResourceResolver compositeResolver = new CompositeResourceResolver(CollectionsKt.listOf($this$filterTo$iv$iv2));
        List results = new ArrayList();
        for (Path file : files) {
            PluginCreator pluginCreator2;
            if (FileUtilKt.isJar(file) || FileUtilKt.isZip(file)) {
                pluginCreator2 = this.getJarLoader().loadPlugin(new JarPluginLoader.Context(file, $this$loadPlugin_u24lambda_u242.getDescriptorPath(), $this$loadPlugin_u24lambda_u242.getValidateDescriptor(), compositeResolver, $this$loadPlugin_u24lambda_u242.getParentPlugin(), $this$loadPlugin_u24lambda_u242.getProblemResolver(), hasDotNetDirectory));
            } else {
                if (!FileUtilKt.isDirectory(file)) continue;
                pluginCreator2 = this.getDirectoryLoader().loadPlugin(new PluginDirectoryLoader.Context(file, $this$loadPlugin_u24lambda_u242.getDescriptorPath(), $this$loadPlugin_u24lambda_u242.getValidateDescriptor(), $this$loadPlugin_u24lambda_u242.getResourceResolver(), $this$loadPlugin_u24lambda_u242.getParentPlugin(), $this$loadPlugin_u24lambda_u242.getProblemResolver(), hasDotNetDirectory));
            }
            PluginCreator innerCreator = pluginCreator2;
            results.add(innerCreator);
        }
        Iterable file = results;
        boolean $i$f$filter2 = false;
        void var13_19 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv3 : var13_19) {
            PluginCreator it = (PluginCreator)element$iv$iv3;
            boolean bl3 = false;
            if (!(it.isSuccess() || this.hasOnlyInvalidDescriptorErrors(it))) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        List possibleResults = (List)destination$iv$iv2;
        switch (possibleResults.size()) {
            case 0: {
                pluginCreator = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u242.getLibDirectoryParent(), $this$loadPlugin_u24lambda_u242.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$loadPlugin_u24lambda_u242.getDescriptorPath()));
                break;
            }
            case 1: {
                pluginCreator = this.withResolvedClasspath((PluginCreator)CollectionsKt.single(possibleResults), $this$loadPlugin_u24lambda_u242.getLibDirectoryParent());
                break;
            }
            default: {
                PluginCreator first = (PluginCreator)possibleResults.get(0);
                PluginCreator pluginCreator3 = (PluginCreator)possibleResults.get(1);
                PluginProblem multipleDescriptorsProblem = new MultiplePluginDescriptors(first.getDescriptorPath(), first.getPluginFileName(), pluginCreator3.getDescriptorPath(), pluginCreator3.getPluginFileName());
                pluginCreator = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u242.getLibDirectoryParent(), $this$loadPlugin_u24lambda_u242.getDescriptorPath(), multipleDescriptorsProblem);
            }
        }
        return pluginCreator;
    }

    private final PluginCreator withResolvedClasspath(PluginCreator $this$withResolvedClasspath, Path path) {
        PluginCreator pluginCreator;
        PluginCreator $this$withResolvedClasspath_u24lambda_u243 = pluginCreator = $this$withResolvedClasspath;
        boolean bl = false;
        ContentModules contentModules = this.contentModuleScanner.getContentModules(path);
        Classpath classpath = contentModules.asClasspath();
        $this$withResolvedClasspath_u24lambda_u243.setClasspath(classpath.getUnique());
        return pluginCreator;
    }

    private final boolean hasOnlyInvalidDescriptorErrors(PluginCreator creator) {
        boolean bl;
        block7: {
            PluginCreationResult<IdePlugin> pluginCreationResult = creator.getPluginCreationResult();
            if (pluginCreationResult instanceof PluginCreationSuccess) {
                bl = false;
            } else if (pluginCreationResult instanceof PluginCreationFail) {
                List<PluginProblem> errorsAndWarnings = ((PluginCreationFail)pluginCreationResult).getErrorsAndWarnings();
                Iterable $this$all$iv = errorsAndWarnings;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PluginProblem it = (PluginProblem)element$iv;
                        boolean bl2 = false;
                        if (it.getLevel() != PluginProblem.Level.ERROR || PluginProblemsKt.isInvalidDescriptorProblem(it)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003JQ\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/LibDirectoryPluginLoader$Context;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoadingContext;", "libDirectoryParent", "Ljava/nio/file/Path;", "descriptorPath", "", "validateDescriptor", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "parentPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "hasDotNetDirectory", "(Ljava/nio/file/Path;Ljava/lang/String;ZLcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;Z)V", "getDescriptorPath", "()Ljava/lang/String;", "getHasDotNetDirectory", "()Z", "getLibDirectoryParent", "()Ljava/nio/file/Path;", "getParentPlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "getProblemResolver", "()Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "getValidateDescriptor", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "structure-intellij"})
    public static final class Context
    extends PluginLoadingContext {
        @NotNull
        private final Path libDirectoryParent;
        @NotNull
        private final String descriptorPath;
        private final boolean validateDescriptor;
        @NotNull
        private final ResourceResolver resourceResolver;
        @Nullable
        private final PluginCreator parentPlugin;
        @NotNull
        private final PluginCreationResultResolver problemResolver;
        private final boolean hasDotNetDirectory;

        public Context(@NotNull Path libDirectoryParent, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(libDirectoryParent, "libDirectoryParent");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            super(resourceResolver, problemResolver);
            this.libDirectoryParent = libDirectoryParent;
            this.descriptorPath = descriptorPath;
            this.validateDescriptor = validateDescriptor;
            this.resourceResolver = resourceResolver;
            this.parentPlugin = parentPlugin;
            this.problemResolver = problemResolver;
            this.hasDotNetDirectory = hasDotNetDirectory;
        }

        public /* synthetic */ Context(Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 0x40) != 0) {
                bl2 = false;
            }
            this(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public final Path getLibDirectoryParent() {
            return this.libDirectoryParent;
        }

        @NotNull
        public final String getDescriptorPath() {
            return this.descriptorPath;
        }

        public final boolean getValidateDescriptor() {
            return this.validateDescriptor;
        }

        @Override
        @NotNull
        public ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        @Nullable
        public final PluginCreator getParentPlugin() {
            return this.parentPlugin;
        }

        @Override
        @NotNull
        public PluginCreationResultResolver getProblemResolver() {
            return this.problemResolver;
        }

        public final boolean getHasDotNetDirectory() {
            return this.hasDotNetDirectory;
        }

        @NotNull
        public final Path component1() {
            return this.libDirectoryParent;
        }

        @NotNull
        public final String component2() {
            return this.descriptorPath;
        }

        public final boolean component3() {
            return this.validateDescriptor;
        }

        @NotNull
        public final ResourceResolver component4() {
            return this.resourceResolver;
        }

        @Nullable
        public final PluginCreator component5() {
            return this.parentPlugin;
        }

        @NotNull
        public final PluginCreationResultResolver component6() {
            return this.problemResolver;
        }

        public final boolean component7() {
            return this.hasDotNetDirectory;
        }

        @NotNull
        public final Context copy(@NotNull Path libDirectoryParent, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(libDirectoryParent, "libDirectoryParent");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            return new Context(libDirectoryParent, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, hasDotNetDirectory);
        }

        public static /* synthetic */ Context copy$default(Context context, Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                path = context.libDirectoryParent;
            }
            if ((n & 2) != 0) {
                string = context.descriptorPath;
            }
            if ((n & 4) != 0) {
                bl = context.validateDescriptor;
            }
            if ((n & 8) != 0) {
                resourceResolver = context.resourceResolver;
            }
            if ((n & 0x10) != 0) {
                pluginCreator = context.parentPlugin;
            }
            if ((n & 0x20) != 0) {
                pluginCreationResultResolver = context.problemResolver;
            }
            if ((n & 0x40) != 0) {
                bl2 = context.hasDotNetDirectory;
            }
            return context.copy(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public String toString() {
            return "Context(libDirectoryParent=" + this.libDirectoryParent + ", descriptorPath=" + this.descriptorPath + ", validateDescriptor=" + this.validateDescriptor + ", resourceResolver=" + this.resourceResolver + ", parentPlugin=" + this.parentPlugin + ", problemResolver=" + this.problemResolver + ", hasDotNetDirectory=" + this.hasDotNetDirectory + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.libDirectoryParent).hashCode();
            result2 = result2 * 31 + this.descriptorPath.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.validateDescriptor);
            result2 = result2 * 31 + this.resourceResolver.hashCode();
            result2 = result2 * 31 + (this.parentPlugin == null ? 0 : this.parentPlugin.hashCode());
            result2 = result2 * 31 + this.problemResolver.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasDotNetDirectory);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual(this.libDirectoryParent, context.libDirectoryParent)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.descriptorPath, context.descriptorPath)) {
                return false;
            }
            if (this.validateDescriptor != context.validateDescriptor) {
                return false;
            }
            if (!Intrinsics.areEqual(this.resourceResolver, context.resourceResolver)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parentPlugin, context.parentPlugin)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.problemResolver, context.problemResolver)) {
                return false;
            }
            return this.hasDotNetDirectory == context.hasDotNetDirectory;
        }
    }
}

