/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.ModuleV2Dependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginV2Dependency;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyOrigin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\u00020\f*\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/BundledPluginDependencyFinder;", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "(Lcom/jetbrains/plugin/structure/ide/Ide;)V", "getIde", "()Lcom/jetbrains/plugin/structure/ide/Ide;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "findPluginDependency", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder$Result;", "dependency", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "dependencyId", "isModule", "", "findPluginOrModuleById", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "toResult", "verifier-intellij"})
public final class BundledPluginDependencyFinder
implements DependencyFinder {
    @NotNull
    private final Ide ide;

    public BundledPluginDependencyFinder(@NotNull Ide ide2) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        this.ide = ide2;
    }

    @NotNull
    public final Ide getIde() {
        return this.ide;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "Bundled plugins of " + this.ide.getVersion().asString();
    }

    @Override
    @NotNull
    public DependencyFinder.Result findPluginDependency(@NotNull String dependencyId, boolean isModule) {
        Intrinsics.checkNotNullParameter(dependencyId, "dependencyId");
        IdePlugin bundledPluginInfo = isModule ? this.findPluginOrModuleById(this.ide, dependencyId) : this.ide.findPluginById(dependencyId);
        return this.toResult(bundledPluginInfo, dependencyId);
    }

    @Override
    @NotNull
    public DependencyFinder.Result findPluginDependency(@NotNull PluginDependency dependency) {
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        PluginDependency pluginDependency = dependency;
        return (pluginDependency instanceof ModuleV2Dependency ? true : pluginDependency instanceof PluginV2Dependency) ? this.toResult(this.findPluginOrModuleById(this.ide, dependency.getId()), dependency.getId()) : this.findPluginDependency(dependency.getId(), dependency.isModule());
    }

    private final DependencyFinder.Result toResult(IdePlugin $this$toResult, String dependencyId) {
        return $this$toResult != null ? (DependencyFinder.Result)new DependencyFinder.Result.FoundPlugin($this$toResult, DependencyOrigin.Bundled.INSTANCE) : (DependencyFinder.Result)new DependencyFinder.Result.NotFound("Dependency " + dependencyId + " is not found among the bundled plugins of " + this.ide);
    }

    private final IdePlugin findPluginOrModuleById(Ide $this$findPluginOrModuleById, String dependencyId) {
        IdePlugin idePlugin = $this$findPluginOrModuleById.findPluginById(dependencyId);
        if (idePlugin == null) {
            idePlugin = $this$findPluginOrModuleById.findPluginByModule(dependencyId);
        }
        return idePlugin;
    }
}

