/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.output.markdown;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PluginProblemsKt;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.output.OutputOptions;
import com.jetbrains.pluginverifier.output.ResultPrinter;
import com.jetbrains.pluginverifier.output.markdown.Markdown;
import com.jetbrains.pluginverifier.output.markdown.MarkdownResultPrinterKt;
import com.jetbrains.pluginverifier.tasks.InvalidPluginFile;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/pluginverifier/output/markdown/MarkdownResultPrinter;", "Lcom/jetbrains/pluginverifier/output/ResultPrinter;", "Ljava/lang/AutoCloseable;", "out", "Ljava/io/PrintWriter;", "(Ljava/io/PrintWriter;)V", "close", "", "printInvalidPluginFiles", "invalidPluginFiles", "", "Lcom/jetbrains/pluginverifier/tasks/InvalidPluginFile;", "printResult", "pluginVerificationResult", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "markdown", "Lcom/jetbrains/pluginverifier/output/markdown/Markdown;", "printResults", "results", "Companion", "verifier-cli"})
public final class MarkdownResultPrinter
implements ResultPrinter,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrintWriter out;

    public MarkdownResultPrinter(@NotNull PrintWriter out) {
        Intrinsics.checkNotNullParameter(out, "out");
        this.out = out;
    }

    @Override
    public void printResults(@NotNull List<? extends PluginVerificationResult> results) {
        Intrinsics.checkNotNullParameter(results, "results");
        MarkdownResultPrinterKt.markdown(this.out, (Function1<? super Markdown, Unit>)new Function1<Markdown, Unit>(results, this){
            final /* synthetic */ List<PluginVerificationResult> $results;
            final /* synthetic */ MarkdownResultPrinter this$0;
            {
                this.$results = $results;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Markdown $this$markdown) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter($this$markdown, "$this$markdown");
                Iterable iterable = this.$results;
                MarkdownResultPrinter markdownResultPrinter = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PluginVerificationResult it = (PluginVerificationResult)element$iv;
                    boolean bl = false;
                    MarkdownResultPrinter.access$printResult(markdownResultPrinter, it, $this$markdown);
                }
            }
        });
    }

    public final void printInvalidPluginFiles(@NotNull List<InvalidPluginFile> invalidPluginFiles) {
        Intrinsics.checkNotNullParameter(invalidPluginFiles, "invalidPluginFiles");
        MarkdownResultPrinterKt.markdown(this.out, (Function1<? super Markdown, Unit>)new Function1<Markdown, Unit>(invalidPluginFiles, this){
            final /* synthetic */ List<InvalidPluginFile> $invalidPluginFiles;
            final /* synthetic */ MarkdownResultPrinter this$0;
            {
                this.$invalidPluginFiles = $invalidPluginFiles;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Markdown $this$markdown) {
                Intrinsics.checkNotNullParameter($this$markdown, "$this$markdown");
                switch (this.$invalidPluginFiles.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        $this$markdown.h1("Invalid plugin");
                        $this$markdown.paragraph("The following file specified for the verification is not a valid plugin.");
                        break;
                    }
                    default: {
                        $this$markdown.h1("Invalid plugins");
                        MarkdownResultPrinter.access$getOut$p(this.this$0).println("The following files specified for the verification are not valid plugins.");
                    }
                }
                if (!((Collection)this.$invalidPluginFiles).isEmpty()) {
                    for (InvalidPluginFile invalidPluginFile : this.$invalidPluginFiles) {
                        Path pluginFile = invalidPluginFile.component1();
                        List<PluginProblem> pluginProblems = invalidPluginFile.component2();
                        $this$markdown.h2(String.valueOf(pluginFile.getFileName()));
                        $this$markdown.paragraph("Full path: `" + pluginFile + "`");
                        Iterable $this$partition$iv = pluginProblems;
                        boolean $i$f$partition = false;
                        ArrayList<T> first$iv = new ArrayList<T>();
                        ArrayList<T> second$iv = new ArrayList<T>();
                        for (T element$iv : $this$partition$iv) {
                            PluginProblem it = (PluginProblem)element$iv;
                            boolean bl = false;
                            if (PluginProblemsKt.isError(it)) {
                                first$iv.add(element$iv);
                                continue;
                            }
                            second$iv.add(element$iv);
                        }
                        Pair<ArrayList<E>, ArrayList<E>> pair = new Pair<ArrayList<E>, ArrayList<E>>(first$iv, second$iv);
                        List pluginErrors = pair.component1();
                        List otherPluginProblems = pair.component2();
                        if (!((Collection)pluginErrors).isEmpty()) {
                            $this$markdown.h3("Plugin Problems");
                            for (PluginProblem pluginError : pluginErrors) {
                                $this$markdown.unorderedListItem(String.valueOf(pluginError));
                            }
                            $this$markdown.unorderedListEnd();
                        }
                        if (!(!((Collection)otherPluginProblems).isEmpty())) continue;
                        String prefix = pluginErrors.isEmpty() ? "" : "Additional ";
                        $this$markdown.h3(prefix + "Plugin Warnings");
                        for (PluginProblem pluginProblem : otherPluginProblems) {
                            $this$markdown.unorderedListItem(String.valueOf(pluginProblem));
                        }
                        $this$markdown.unorderedListEnd();
                    }
                }
            }
        });
    }

    private final void printResult(PluginVerificationResult pluginVerificationResult, Markdown markdown) {
        PluginVerificationResult $this$printResult_u24lambda_u240 = pluginVerificationResult;
        boolean bl = false;
        markdown.h1("Plugin " + $this$printResult_u24lambda_u240.getPlugin() + " against " + $this$printResult_u24lambda_u240.getVerificationTarget());
        markdown.paragraph($this$printResult_u24lambda_u240.getVerificationVerdict());
        if ($this$printResult_u24lambda_u240 instanceof PluginVerificationResult.Verified) {
            MarkdownResultPrinterKt.access$plus(markdown, (PluginVerificationResult.Verified)$this$printResult_u24lambda_u240);
        }
    }

    @Override
    public void close() {
        this.out.close();
    }

    public static final /* synthetic */ void access$printResult(MarkdownResultPrinter $this, PluginVerificationResult pluginVerificationResult, Markdown markdown) {
        $this.printResult(pluginVerificationResult, markdown);
    }

    public static final /* synthetic */ PrintWriter access$getOut$p(MarkdownResultPrinter $this) {
        return $this.out;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/output/markdown/MarkdownResultPrinter$Companion;", "", "()V", "create", "Lcom/jetbrains/pluginverifier/output/markdown/MarkdownResultPrinter;", "verificationTarget", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "outputOptions", "Lcom/jetbrains/pluginverifier/output/OutputOptions;", "verifier-cli"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownResultPrinter create(@NotNull PluginVerificationTarget verificationTarget, @NotNull OutputOptions outputOptions) {
            Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
            Intrinsics.checkNotNullParameter(outputOptions, "outputOptions");
            Path reportHtmlFile = outputOptions.getTargetReportDirectory(verificationTarget).resolve("report.md");
            Intrinsics.checkNotNullExpressionValue(reportHtmlFile, "reportHtmlFile");
            PrintWriter writer = new PrintWriter(Files.newBufferedWriter(FileUtilKt.create(reportHtmlFile), new OpenOption[0]));
            return new MarkdownResultPrinter(writer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

