/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.reporting;

import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportageAggregator;
import com.jetbrains.pluginverifier.reporting.common.LogReporter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/pluginverifier/reporting/LoggingPluginVerificationReportageAggregator;", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportageAggregator;", "messageReporters", "", "Lcom/jetbrains/pluginverifier/reporting/common/LogReporter;", "", "(Ljava/util/List;)V", "resultsInDirectories", "", "Lkotlin/Pair;", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "Ljava/nio/file/Path;", "handleAggregatedReportage", "", "handleVerificationResult", "result", "targetDirectory", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nLoggingPluginVerificationReportageAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingPluginVerificationReportageAggregator.kt\ncom/jetbrains/pluginverifier/reporting/LoggingPluginVerificationReportageAggregator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1855#2,2:40\n*S KotlinDebug\n*F\n+ 1 LoggingPluginVerificationReportageAggregator.kt\ncom/jetbrains/pluginverifier/reporting/LoggingPluginVerificationReportageAggregator\n*L\n30#1:40,2\n*E\n"})
public final class LoggingPluginVerificationReportageAggregator
implements PluginVerificationReportageAggregator {
    @NotNull
    private final List<LogReporter<String>> messageReporters;
    @NotNull
    private final List<Pair<PluginVerificationResult, Path>> resultsInDirectories;

    public LoggingPluginVerificationReportageAggregator(@NotNull List<? extends LogReporter<? super String>> messageReporters) {
        Intrinsics.checkNotNullParameter(messageReporters, "messageReporters");
        this.messageReporters = messageReporters;
        this.resultsInDirectories = new ArrayList();
    }

    public /* synthetic */ LoggingPluginVerificationReportageAggregator(List list, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            Logger logger = LoggerFactory.getLogger("verification");
            Intrinsics.checkNotNullExpressionValue(logger, "getLogger(\"verification\")");
            list = CollectionsKt.listOf(new LogReporter(logger));
        }
        this(list);
    }

    @Override
    public void handleVerificationResult(@NotNull PluginVerificationResult result2, @NotNull Path targetDirectory) {
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(targetDirectory, "targetDirectory");
        this.resultsInDirectories.add(TuplesKt.to(result2, targetDirectory));
    }

    public final void handleAggregatedReportage() {
        Iterable $this$forEach$iv = this.messageReporters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogReporter reporter = (LogReporter)element$iv;
            boolean bl = false;
            for (Pair<PluginVerificationResult, Path> pair : this.resultsInDirectories) {
                String message2;
                PluginVerificationResult result2 = pair.component1();
                Path targetDirectory = pair.component2();
                String string = "Verification reports for %s saved to %s";
                Object[] objectArray = new Object[2];
                objectArray[0] = result2.getPlugin();
                Intrinsics.checkNotNullExpressionValue(targetDirectory.toAbsolutePath(), "toAbsolutePath(...)");
                Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray, objectArray.length)), "format(...)");
                reporter.report(message2);
            }
        }
    }

    public LoggingPluginVerificationReportageAggregator() {
        this(null, 1, null);
    }
}

