/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/MissingPropertyReferenceProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "propertyKey", "", "bundleBaseName", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/pluginverifier/results/location/Location;)V", "getBundleBaseName", "()Ljava/lang/String;", "fullDescription", "getFullDescription", "problemType", "getProblemType", "getPropertyKey", "shortDescription", "getShortDescription", "getUsageLocation", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class MissingPropertyReferenceProblem
extends CompatibilityProblem {
    @NotNull
    private final String propertyKey;
    @NotNull
    private final String bundleBaseName;
    @NotNull
    private final Location usageLocation;

    public MissingPropertyReferenceProblem(@NotNull String propertyKey, @NotNull String bundleBaseName, @NotNull Location usageLocation) {
        Intrinsics.checkNotNullParameter(propertyKey, "propertyKey");
        Intrinsics.checkNotNullParameter(bundleBaseName, "bundleBaseName");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        this.propertyKey = propertyKey;
        this.bundleBaseName = bundleBaseName;
        this.usageLocation = usageLocation;
    }

    @NotNull
    public final String getPropertyKey() {
        return this.propertyKey;
    }

    @NotNull
    public final String getBundleBaseName() {
        return this.bundleBaseName;
    }

    @NotNull
    public final Location getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Missing property reference";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.propertyKey, this.bundleBaseName};
        return FormatUtilsKt.formatMessage("Reference to a missing property {0} of resource bundle {1}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{StringsKt.capitalize(this.usageLocation.getElementType().getPresentableName()), this.usageLocation, this.propertyKey, this.bundleBaseName};
        return FormatUtilsKt.formatMessage("{0} {1} references property {2} that is not found in resource bundle {3}. This can lead to **MissingResourceException** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof MissingPropertyReferenceProblem && Intrinsics.areEqual(this.propertyKey, ((MissingPropertyReferenceProblem)other).propertyKey) && Intrinsics.areEqual(this.bundleBaseName, ((MissingPropertyReferenceProblem)other).bundleBaseName) && Intrinsics.areEqual(this.usageLocation, ((MissingPropertyReferenceProblem)other).usageLocation);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.propertyKey, this.bundleBaseName, this.usageLocation};
        return Objects.hash(objectArray);
    }
}

