/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.bytecode;

import com.jetbrains.pluginverifier.verifiers.bytecode.DefaultInterpreterListener;
import com.jetbrains.pluginverifier.verifiers.bytecode.InterpreterListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\f\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J$\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u0016H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J&\u0010\u001b\u001a\u00020\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u0016J2\u0010\u001e\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010 \u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u0013\u0010!\u001a\u0004\u0018\u00010\n*\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/bytecode/InterpreterAdapter;", "Lorg/objectweb/asm/tree/analysis/Interpreter;", "Lorg/objectweb/asm/tree/analysis/BasicValue;", "interpreterListener", "Lcom/jetbrains/pluginverifier/verifiers/bytecode/InterpreterListener;", "(Lcom/jetbrains/pluginverifier/verifiers/bytecode/InterpreterListener;)V", "interpreter", "Lorg/objectweb/asm/tree/analysis/BasicInterpreter;", "singleIntOpcodes", "", "", "Lcom/jetbrains/pluginverifier/verifiers/bytecode/Opcode;", "binaryOperation", "insn", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "value1", "value2", "copyOperation", "value", "merge", "naryOperation", "values", "", "newOperation", "newValue", "type", "Lorg/objectweb/asm/Type;", "returnOperation", "", "expected", "ternaryOperation", "value3", "unaryOperation", "operand", "(Lorg/objectweb/asm/tree/AbstractInsnNode;)Ljava/lang/Integer;", "verifier-core"})
public final class InterpreterAdapter
extends Interpreter<BasicValue> {
    @NotNull
    private final InterpreterListener interpreterListener;
    @NotNull
    private final BasicInterpreter interpreter;
    @NotNull
    private final List<Integer> singleIntOpcodes;

    public InterpreterAdapter(@NotNull InterpreterListener interpreterListener) {
        Intrinsics.checkNotNullParameter(interpreterListener, "interpreterListener");
        super(589824);
        this.interpreterListener = interpreterListener;
        this.interpreter = new BasicInterpreter();
        Integer[] integerArray = new Integer[]{16, 17};
        this.singleIntOpcodes = CollectionsKt.plus((Iterable)new IntRange(2, 8), (Iterable)CollectionsKt.listOf(integerArray));
    }

    public /* synthetic */ InterpreterAdapter(InterpreterListener interpreterListener, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            interpreterListener = DefaultInterpreterListener.INSTANCE;
        }
        this(interpreterListener);
    }

    @Override
    @Nullable
    public BasicValue newOperation(@Nullable AbstractInsnNode insn) {
        BasicValue basicValue;
        if (insn == null) {
            throw new AssertionError((Object)"Instruction cannot be null");
        }
        int n = insn.getOpcode();
        if (n == 18) {
            LdcInsnNode ldcInsnNode = (LdcInsnNode)insn;
            Object object = ((LdcInsnNode)insn).cst;
            Intrinsics.checkNotNullExpressionValue(object, "insn.cst");
            basicValue = this.interpreterListener.onLdc(ldcInsnNode, object, this.interpreter);
        } else if (this.singleIntOpcodes.contains(n)) {
            Integer n2 = this.operand(insn);
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl = false;
                basicValue = this.interpreterListener.onPushInt(insn, it, this.interpreter);
            } else {
                basicValue = null;
            }
        } else {
            basicValue = this.interpreter.newOperation(insn);
        }
        return basicValue;
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @Nullable List<? extends BasicValue> values2) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        return insn.getOpcode() == 183 ? this.interpreterListener.onInvokeSpecial((MethodInsnNode)insn, values2, this.interpreter) : this.interpreter.naryOperation(insn, (List)values2);
    }

    private final Integer operand(AbstractInsnNode $this$operand) {
        Integer n;
        int n2 = $this$operand.getOpcode();
        boolean bl = 2 <= n2 ? n2 < 9 : false;
        if (bl) {
            n = $this$operand.getOpcode() - 3;
        } else if (n2 == 16 ? true : n2 == 17) {
            Intrinsics.checkNotNull($this$operand, "null cannot be cast to non-null type org.objectweb.asm.tree.IntInsnNode");
            n = ((IntInsnNode)$this$operand).operand;
        } else {
            n = null;
        }
        return n;
    }

    @Override
    @Nullable
    public BasicValue newValue(@Nullable Type type2) {
        return this.interpreter.newValue(type2);
    }

    @Override
    @Nullable
    public BasicValue copyOperation(@Nullable AbstractInsnNode insn, @Nullable BasicValue value) {
        return this.interpreter.copyOperation(insn, value);
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@Nullable AbstractInsnNode insn, @Nullable BasicValue value) {
        return this.interpreter.unaryOperation(insn, value);
    }

    @Override
    @Nullable
    public BasicValue binaryOperation(@Nullable AbstractInsnNode insn, @Nullable BasicValue value1, @Nullable BasicValue value2) {
        return this.interpreter.binaryOperation(insn, value1, value2);
    }

    @Override
    @Nullable
    public BasicValue ternaryOperation(@Nullable AbstractInsnNode insn, @Nullable BasicValue value1, @Nullable BasicValue value2, @Nullable BasicValue value3) {
        return this.interpreter.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    public void returnOperation(@Nullable AbstractInsnNode insn, @Nullable BasicValue value, @Nullable BasicValue expected) {
        this.interpreter.returnOperation(insn, value, expected);
    }

    @Override
    @Nullable
    public BasicValue merge(@Nullable BasicValue value1, @Nullable BasicValue value2) {
        return this.interpreter.merge(value1, value2);
    }

    public InterpreterAdapter() {
        this(null, 1, null);
    }
}

