/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.reader.trex.classic;

import com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.StringType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.ctc.wstx.shaded.msv_core.grammar.trex.TREXGrammar;
import com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.ctc.wstx.shaded.msv_core.reader.IgnoreState;
import com.ctc.wstx.shaded.msv_core.reader.RunAwayExpressionChecker;
import com.ctc.wstx.shaded.msv_core.reader.State;
import com.ctc.wstx.shaded.msv_core.reader.TerminalState;
import com.ctc.wstx.shaded.msv_core.reader.datatype.DataTypeVocabulary;
import com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDatatypeExp;
import com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDatatypeResolver;
import com.ctc.wstx.shaded.msv_core.reader.trex.IncludePatternState;
import com.ctc.wstx.shaded.msv_core.reader.trex.RootState;
import com.ctc.wstx.shaded.msv_core.reader.trex.TREXBaseReader;
import com.ctc.wstx.shaded.msv_core.reader.trex.TREXSequencedStringChecker;
import com.ctc.wstx.shaded.msv_core.reader.trex.classic.ConcurState;
import com.ctc.wstx.shaded.msv_core.reader.trex.classic.DataState;
import com.ctc.wstx.shaded.msv_core.reader.trex.classic.DefineState;
import com.ctc.wstx.shaded.msv_core.reader.trex.classic.StringState;
import com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;

public class TREXGrammarReader
extends TREXBaseReader
implements XSDatatypeResolver {
    protected String currentGrammarURI;
    public static final String TREXNamespace = "http://www.thaiopensource.com/trex";
    private boolean issueObsoletedXMLSchemaNamespace = false;

    public static TREXGrammar parse(String grammarURL, SAXParserFactory factory2, GrammarReaderController controller) {
        TREXGrammarReader reader = new TREXGrammarReader(controller, factory2, new ExpressionPool());
        reader.parse(grammarURL);
        return reader.getResult();
    }

    public static TREXGrammar parse(InputSource grammar, SAXParserFactory factory2, GrammarReaderController controller) {
        TREXGrammarReader reader = new TREXGrammarReader(controller, factory2, new ExpressionPool());
        reader.parse(grammar);
        return reader.getResult();
    }

    public TREXGrammarReader(GrammarReaderController controller) {
        this(controller, TREXGrammarReader.createParserFactory(), new ExpressionPool());
    }

    public TREXGrammarReader(GrammarReaderController controller, SAXParserFactory parserFactory, ExpressionPool pool) {
        this(controller, parserFactory, new StateFactory(), pool);
    }

    public TREXGrammarReader(GrammarReaderController controller, SAXParserFactory parserFactory, StateFactory stateFactory, ExpressionPool pool) {
        super(controller, parserFactory, pool, stateFactory, new RootState());
    }

    @Override
    protected String localizeMessage(String propertyName, Object[] args2) {
        String format2;
        try {
            format2 = ResourceBundle.getBundle("com.ctc.wstx.shaded.msv_core.reader.trex.classic.Messages").getString(propertyName);
        }
        catch (Exception e) {
            return super.localizeMessage(propertyName, args2);
        }
        return MessageFormat.format(format2, args2);
    }

    protected TREXGrammar getGrammar() {
        return this.grammar;
    }

    @Override
    protected boolean isGrammarElement(StartTagInfo tag2) {
        if (this.currentGrammarURI == null) {
            if (tag2.namespaceURI.equals(TREXNamespace)) {
                this.currentGrammarURI = TREXNamespace;
                return true;
            }
            if (tag2.namespaceURI.equals("")) {
                this.currentGrammarURI = "";
                return true;
            }
            return false;
        }
        if (this.currentGrammarURI.equals(tag2.namespaceURI)) {
            return true;
        }
        return tag2.containsAttribute(TREXNamespace, "role");
    }

    protected StateFactory getStateFactory() {
        return (StateFactory)this.sfactory;
    }

    private String mapNamespace(String namespace2) {
        if (namespace2.equals("http://www.w3.org/2000/10/XMLSchema") || namespace2.equals("http://www.w3.org/2000/10/XMLSchema-datatypes")) {
            if (!this.issueObsoletedXMLSchemaNamespace) {
                this.reportWarning("TREXGrammarReader.Warning.ObsoletedXMLSchemaNamespace", namespace2);
            }
            this.issueObsoletedXMLSchemaNamespace = true;
            return "http://www.w3.org/2001/XMLSchema-datatypes";
        }
        return namespace2;
    }

    @Override
    public State createExpressionChildState(State parent, StartTagInfo tag2) {
        if (tag2.localName.equals("concur")) {
            return this.getStateFactory().concur(parent, tag2);
        }
        if (tag2.localName.equals("anyString")) {
            return this.getStateFactory().anyString(parent, tag2);
        }
        if (tag2.localName.equals("string")) {
            return this.getStateFactory().string(parent, tag2);
        }
        if (tag2.localName.equals("data")) {
            return this.getStateFactory().data(parent, tag2);
        }
        if (tag2.localName.equals("include")) {
            return this.getStateFactory().includePattern(parent, tag2);
        }
        String role = tag2.getAttribute(TREXNamespace, "role");
        if ("datatype".equals(role)) {
            String namespaceURI = this.mapNamespace(tag2.namespaceURI);
            DataTypeVocabulary v = this.grammar.dataTypes.get(namespaceURI);
            if (v == null) {
                this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)tag2.namespaceURI);
                this.grammar.dataTypes.put(tag2.namespaceURI, new UndefinedDataTypeVocabulary());
                return new IgnoreState();
            }
            return v.createTopLevelReaderState(tag2);
        }
        return super.createExpressionChildState(parent, tag2);
    }

    @Override
    public XSDatatypeExp resolveXSDatatype(String qName) {
        return new XSDatatypeExp((XSDatatype)this.resolveDatatype(qName), this.pool);
    }

    public Datatype resolveDatatype(String qName) {
        String[] s2 = this.splitQName(qName);
        if (s2 == null) {
            this.reportError("TREXGrammarReader.UndeclaredPrefix", (Object)qName);
            return StringType.theInstance;
        }
        s2[0] = this.mapNamespace(s2[0]);
        DataTypeVocabulary v = this.grammar.dataTypes.get(s2[0]);
        if (v == null) {
            this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)s2[0]);
            this.grammar.dataTypes.put(s2[0], new UndefinedDataTypeVocabulary());
        } else {
            try {
                return v.getType(s2[1]);
            }
            catch (DatatypeException e) {
                this.reportError("GrammarReader.UndefinedDataType", (Object)qName);
            }
        }
        return StringType.theInstance;
    }

    @Override
    public void wrapUp() {
        RunAwayExpressionChecker.check(this, this.grammar);
        if (!this.controller.hadError()) {
            this.grammar.visit(new TREXSequencedStringChecker(this, false));
        }
    }

    public static class StateFactory
    extends TREXBaseReader.StateFactory {
        public State concur(State parent, StartTagInfo tag2) {
            return new ConcurState();
        }

        public State anyString(State parent, StartTagInfo tag2) {
            return new TerminalState(Expression.anyString);
        }

        public State string(State parent, StartTagInfo tag2) {
            return new StringState();
        }

        public State data(State parent, StartTagInfo tag2) {
            return new DataState();
        }

        @Override
        public State define(State parent, StartTagInfo tag2) {
            return new DefineState();
        }

        public State includePattern(State parent, StartTagInfo tag2) {
            return new IncludePatternState();
        }
    }

    private static class UndefinedDataTypeVocabulary
    implements DataTypeVocabulary {
        private UndefinedDataTypeVocabulary() {
        }

        @Override
        public State createTopLevelReaderState(StartTagInfo tag2) {
            return new IgnoreState();
        }

        @Override
        public Datatype getType(String localTypeName) {
            return StringType.theInstance;
        }
    }
}

